/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: HeuristicCommitException.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.transaction;
 
/**
 * This exception is thrown by the rollback operation on a resource
 * to report that a heuristic decision was made and that all
 * relevant updates have been committed.
 * @author Guillaume Sauthier
 */
public class HeuristicCommitException extends Exception {

    /**
     * TODO Check for interop
     */
    private static final long serialVersionUID = -3977609782149921760L;

    /**
     * Creates a new HeuristicCommitException
     */
    public HeuristicCommitException() {
    }

    /**
     * Creates a new HeuristicCommitException from a String message.
     * @param msg Exception message
     */
    public HeuristicCommitException(String msg) {
        super(msg);
    }

}
