/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Status.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.transaction;
 
/**
 * The Status interface defines static variables used for transaction status codes.
 * @author Guillaume Sauthier
 */
public interface Status {
    
    /**
     * A transaction is associated with the target object and
     * it is in the active state. An implementation returns this
     * status after a transaction has been started and prior to a
     * Coordinator issuing any prepares, unless the transaction has
     * been marked for rollback.
     */
    static final int STATUS_ACTIVE = 0;
    
    /**
     * A transaction is associated with the target object and it
     * has been marked for rollback, perhaps as a result of a
     * setRollbackOnly operation.
     */
    static final int STATUS_MARKED_ROLLBACK = 1;
    
    /**
     * A transaction is associated with the target object and it has
     * been prepared. That is, all subordinates have agreed to commit.
     * The target object may be waiting for instructions from a superior
     * as to how to proceed.
     */
    static final int STATUS_PREPARED = 2;
    
    /**
     * A transaction is associated with the target object and it has
     * been committed. It is likely that heuristics exist; otherwise,
     * the transaction would have been destroyed and NoTransaction
     * returned.
     */
    static final int STATUS_COMMITTED = 3;
    
    /**
     * A transaction is associated with the target object and the
     * outcome has been determined to be rollback. It is likely that
     * heuristics exist; otherwise, the transaction would have been
     * destroyed and NoTransaction returned.
     */
    static final int STATUS_ROLLEDBACK = 4;
    
    /**
     * A transaction is associated with the target object but its
     * current status cannot be determined. This is a transient
     * condition and a subsequent invocation will ultimately return
     * a different status.
     */
    static final int STATUS_UNKNOWN = 5;
    
    /**
     * No transaction is currently associated with the target
     * object. This will occur after a transaction has completed.
     */
    static final int STATUS_NO_TRANSACTION = 6;
    
    /**
     * A transaction is associated with the target object and it
     * is in the process of preparing. An implementation returns
     * this status if it has started preparing, but has not yet
     * completed the process. The likely reason for this is that
     * the implementation is probably waiting for responses to
     * prepare from one or more Resources.
     */
    static final int STATUS_PREPARING = 7;
    
    /**
     * A transaction is associated with the target object and it
     * is in the process of committing. An implementation returns
     * this status if it has decided to commit but has not yet
     * completed the committing process. This occurs because the
     * implementation is probably waiting for responses from one
     * or more Resources.
     */
    static final int STATUS_COMMITTING = 8;
    
    /**
     * A transaction is associated with the target object and it
     * is in the process of rolling back. An implementation returns
     * this status if it has decided to rollback but has not yet
     * completed the process. The implementation is probably waiting
     * for responses from one or more Resources.
     */
    static final int STATUS_ROLLING_BACK = 9;
}
