/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Synchronization.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.transaction;
 
/**
 * The transaction manager supports a synchronization mechanism that
 * allows the interested party to be notified before and after the
 * transaction completes. Using the registerSynchronization method,
 * the application server registers a Synchronization object for the
 * transaction currently associated with the target Transaction
 * object.
 * @author Guillaume Sauthier
 */
public interface Synchronization {

    /**
     * The beforeCompletion method is called by the transaction
     * manager prior to the start of the two-phase transaction
     * commit process. This call is executed with the transaction
     * context of the transaction that is being committed.
     */
    void beforeCompletion();
    
    /**
     * This method is called by the transaction manager after
     * the transaction is committed or rolled back.
     * @param status The status of the transaction completion.
     */
    void afterCompletion(int status);
}
