/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nodeaudit;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.commons.collections4.MultiValuedMap;
import org.owasp.dependencycheck.analyzer.NodePackageAnalyzer;

@ThreadSafe
public final class NpmPayloadBuilder {
    private NpmPayloadBuilder() {
    }

    public static JsonObject build(JsonObject lockJson, JsonObject packageJson, MultiValuedMap<String, String> dependencyMap, boolean skipDevDependencies) {
        JsonObjectBuilder payloadBuilder = Json.createObjectBuilder();
        NpmPayloadBuilder.addProjectInfo(packageJson, payloadBuilder);
        JsonObjectBuilder requiresBuilder = Json.createObjectBuilder();
        if (packageJson.containsKey((Object)"dependencies")) {
            packageJson.getJsonObject("dependencies").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> newValue, TreeMap::new)).forEach((key, value) -> {
                if (NodePackageAnalyzer.shouldSkipDependency(key, ((JsonString)value).getString())) {
                    return;
                }
                requiresBuilder.add(key, value);
                dependencyMap.put(key, (Object)value.toString());
            });
        }
        if (!skipDevDependencies && packageJson.containsKey((Object)"devDependencies")) {
            packageJson.getJsonObject("devDependencies").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> newValue, TreeMap::new)).forEach((key, value) -> {
                if (NodePackageAnalyzer.shouldSkipDependency(key, ((JsonString)value).getString())) {
                    return;
                }
                requiresBuilder.add(key, value);
                dependencyMap.put(key, (Object)value.toString());
            });
        }
        payloadBuilder.add("requires", (JsonValue)requiresBuilder.build());
        JsonObjectBuilder dependenciesBuilder = Json.createObjectBuilder();
        int lockJsonVersion = lockJson.containsKey((Object)"lockfileVersion") ? lockJson.getInt("lockfileVersion") : 1;
        JsonObject dependencies = lockJson.getJsonObject("dependencies");
        if (lockJsonVersion >= 2 && dependencies == null) {
            dependencies = lockJson.getJsonObject("packages");
        }
        if (dependencies != null) {
            dependencies.forEach((k, value) -> {
                String key = k;
                int indexOfNodeModule = key.lastIndexOf("node_modules/");
                if (indexOfNodeModule >= 0) {
                    key = key.substring(indexOfNodeModule + "node_modules".length() + 1);
                }
                JsonObject dep = (JsonObject)value;
                if (lockJsonVersion > 2 && dep.containsKey((Object)"dependencies") && dep.get((Object)"dependencies") instanceof JsonObject) {
                    JsonObjectBuilder depBuilder = Json.createObjectBuilder((JsonObject)dep);
                    depBuilder.remove("dependencies");
                    depBuilder.add("requires", (JsonValue)dep.get((Object)"dependencies"));
                    dep = depBuilder.build();
                }
                String version = dep.getString("version", "");
                boolean isDev = dep.getBoolean("dev", false);
                if (skipDevDependencies && isDev) {
                    return;
                }
                if (NodePackageAnalyzer.shouldSkipDependency(key, version)) {
                    return;
                }
                dependencyMap.put((Object)key, (Object)version);
                dependenciesBuilder.add(key, (JsonValue)NpmPayloadBuilder.buildDependencies(dep, dependencyMap));
            });
        }
        payloadBuilder.add("dependencies", (JsonValue)dependenciesBuilder.build());
        NpmPayloadBuilder.addConstantElements(payloadBuilder);
        return payloadBuilder.build();
    }

    public static JsonObject build(JsonObject packageJson, MultiValuedMap<String, String> dependencyMap, boolean skipDevDependencies) {
        JsonObjectBuilder payloadBuilder = Json.createObjectBuilder();
        NpmPayloadBuilder.addProjectInfo(packageJson, payloadBuilder);
        JsonObjectBuilder requiresBuilder = Json.createObjectBuilder();
        JsonObjectBuilder dependenciesBuilder = Json.createObjectBuilder();
        JsonObject dependencies = packageJson.getJsonObject("dependencies");
        if (dependencies != null) {
            dependencies.forEach((name, value) -> {
                String version;
                if (value.getValueType() == JsonValue.ValueType.OBJECT) {
                    JsonObject dep = (JsonObject)value;
                    version = Optional.ofNullable(dep.getJsonString("version")).map(JsonString::getString).orElse(null);
                    boolean isDev = dep.getBoolean("dev", false);
                    if (skipDevDependencies && isDev) {
                        return;
                    }
                    if (NodePackageAnalyzer.shouldSkipDependency(name, version)) {
                        return;
                    }
                    dependencyMap.put(name, (Object)version);
                    dependenciesBuilder.add(name, (JsonValue)NpmPayloadBuilder.buildDependencies(dep, dependencyMap));
                } else {
                    String tmp = value.toString();
                    version = tmp.startsWith("\"") ? tmp.substring(1, tmp.length() - 1) : tmp;
                }
                requiresBuilder.add(name, Objects.isNull(version) ? "*" : "^" + version);
            });
        }
        payloadBuilder.add("requires", (JsonValue)requiresBuilder.build());
        payloadBuilder.add("dependencies", (JsonValue)dependenciesBuilder.build());
        NpmPayloadBuilder.addConstantElements(payloadBuilder);
        return payloadBuilder.build();
    }

    private static void addProjectInfo(JsonObject packageJson, JsonObjectBuilder payloadBuilder) {
        String projectName = packageJson.getString("name", "");
        String projectVersion = packageJson.getString("version", "");
        if (!projectName.isEmpty()) {
            payloadBuilder.add("name", projectName);
        }
        if (!projectVersion.isEmpty()) {
            payloadBuilder.add("version", projectVersion);
        }
    }

    private static void addConstantElements(JsonObjectBuilder payloadBuilder) {
        payloadBuilder.add("install", (JsonValue)Json.createArrayBuilder().build());
        payloadBuilder.add("remove", (JsonValue)Json.createArrayBuilder().build());
        payloadBuilder.add("metadata", Json.createObjectBuilder().add("npm_version", "6.9.0").add("node_version", "v10.5.0").add("platform", "linux"));
    }

    private static JsonObject buildDependencies(JsonObject dep, MultiValuedMap<String, String> dependencyMap) {
        JsonObjectBuilder depBuilder = Json.createObjectBuilder();
        Optional.ofNullable(dep.getJsonString("version")).map(JsonString::getString).ifPresent(version -> depBuilder.add("version", version));
        if (dep.containsKey((Object)"integrity")) {
            depBuilder.add("integrity", dep.getString("integrity"));
        }
        if (dep.containsKey((Object)"requires")) {
            JsonObjectBuilder requiresBuilder = Json.createObjectBuilder();
            dep.getJsonObject("requires").forEach((key, value) -> {
                if (NodePackageAnalyzer.shouldSkipDependency(key, ((JsonString)value).getString())) {
                    return;
                }
                requiresBuilder.add(key, value);
            });
            depBuilder.add("requires", (JsonValue)requiresBuilder.build());
        }
        if (dep.containsKey((Object)"dependencies")) {
            JsonObjectBuilder dependeciesBuilder = Json.createObjectBuilder();
            dep.getJsonObject("dependencies").forEach((key, value) -> {
                if (value.getValueType() == JsonValue.ValueType.OBJECT) {
                    JsonObject currentDep = (JsonObject)value;
                    String v = currentDep.getString("version");
                    dependencyMap.put(key, (Object)v);
                    dependeciesBuilder.add(key, (JsonValue)NpmPayloadBuilder.buildDependencies(currentDep, dependencyMap));
                } else {
                    String tmp = value.toString();
                    String v = tmp.startsWith("\"") ? tmp.substring(1, tmp.length() - 1) : tmp;
                    dependencyMap.put(key, (Object)v);
                    dependeciesBuilder.add(key, v);
                }
            });
            depBuilder.add("dependencies", (JsonValue)dependeciesBuilder.build());
        }
        return depBuilder.build();
    }
}

