/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;

@NotThreadSafe
public class FileFilterBuilder {
    private final Set<String> filenames = new HashSet<String>();
    private final Set<String> extensions = new HashSet<String>();
    private final List<IOFileFilter> fileFilters = new ArrayList<IOFileFilter>();

    public static FileFilterBuilder newInstance() {
        return new FileFilterBuilder();
    }

    public FileFilterBuilder addFilenames(String ... names) {
        this.filenames.addAll(Arrays.asList(names));
        return this;
    }

    public FileFilterBuilder addExtensions(String ... extensions) {
        return this.addExtensions(Arrays.asList(extensions));
    }

    public FileFilterBuilder addExtensions(Iterable<String> extensions) {
        for (String extension : extensions) {
            this.extensions.add((String)(extension.startsWith(".") ? extension : "." + extension));
        }
        return this;
    }

    public FileFilterBuilder addFileFilters(IOFileFilter ... filters) {
        this.fileFilters.addAll(Arrays.asList(filters));
        return this;
    }

    public FileFilter build() {
        if (this.filenames.isEmpty() && this.extensions.isEmpty() && this.fileFilters.isEmpty()) {
            throw new IllegalStateException("May only be invoked after at least one add... method has been invoked.");
        }
        OrFileFilter filter = new OrFileFilter();
        if (!this.filenames.isEmpty()) {
            filter.addFileFilter((IOFileFilter)new NameFileFilter(new ArrayList<String>(this.filenames)));
        }
        if (!this.extensions.isEmpty()) {
            filter.addFileFilter((IOFileFilter)new SuffixFileFilter(new ArrayList<String>(this.extensions), IOCase.INSENSITIVE));
        }
        for (IOFileFilter iof : this.fileFilters) {
            filter.addFileFilter(iof);
        }
        return filter;
    }
}

