/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.composer.ComposerException;
import org.owasp.dependencycheck.data.composer.ComposerLockParser;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class ComposerLockAnalyzer
extends AbstractFileTypeAnalyzer {
    public static final String DEPENDENCY_ECOSYSTEM = "php";
    private static final Logger LOGGER = LoggerFactory.getLogger(ComposerLockAnalyzer.class);
    private static final String ANALYZER_NAME = "Composer.lock analyzer";
    private static final String COMPOSER_LOCK = "composer.lock";
    private static final FileFilter FILE_FILTER = FileFilterBuilder.newInstance().addFilenames("composer.lock").build();

    @Override
    protected FileFilter getFileFilter() {
        return FILE_FILTER;
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        engine.removeDependency(dependency);
        try (FileInputStream fis = new FileInputStream(dependency.getActualFile());){
            ComposerLockParser clp = new ComposerLockParser(fis);
            LOGGER.debug("Checking composer.lock file {}", (Object)dependency.getActualFilePath());
            clp.process();
            clp.getDependencies().stream().map(dep -> {
                Dependency d = new Dependency(dependency.getActualFile(), true);
                String filePath = String.format("%s:%s/%s/%s", dependency.getFilePath(), dep.getGroup(), dep.getProject(), dep.getVersion());
                d.setName(dep.getProject());
                d.setVersion(dep.getVersion());
                try {
                    PackageURL purl = PackageURLBuilder.aPackageURL().withType("composer").withNamespace(dep.getGroup()).withName(dep.getProject()).withVersion(dep.getVersion()).build();
                    d.addSoftwareIdentifier(new PurlIdentifier(purl, Confidence.HIGHEST));
                }
                catch (MalformedPackageURLException ex) {
                    LOGGER.debug("Unable to build package url for composer", (Throwable)ex);
                    d.addSoftwareIdentifier(new GenericIdentifier("composer:" + dep.getGroup() + "/" + dep.getProject() + "@" + dep.getVersion(), Confidence.HIGHEST));
                }
                d.setPackagePath(String.format("%s:%s", dep.getProject(), dep.getVersion()));
                d.setEcosystem(DEPENDENCY_ECOSYSTEM);
                d.setFilePath(filePath);
                d.setSha1sum(Checksum.getSHA1Checksum((String)filePath));
                d.setSha256sum(Checksum.getSHA256Checksum((String)filePath));
                d.setMd5sum(Checksum.getMD5Checksum((String)filePath));
                d.addEvidence(EvidenceType.VENDOR, COMPOSER_LOCK, "vendor", dep.getGroup(), Confidence.HIGHEST);
                d.addEvidence(EvidenceType.PRODUCT, COMPOSER_LOCK, "product", dep.getProject(), Confidence.HIGHEST);
                d.addEvidence(EvidenceType.VERSION, COMPOSER_LOCK, "version", dep.getVersion(), Confidence.HIGHEST);
                return d;
            }).forEach(d -> {
                LOGGER.debug("Adding dependency {}", (Object)d.getDisplayFileName());
                engine.addDependency((Dependency)d);
            });
        }
        catch (IOException ex) {
            LOGGER.warn("Error opening dependency {}", (Object)dependency.getActualFilePath());
        }
        catch (ComposerException ce) {
            LOGGER.warn("Error parsing composer.json {}", (Object)dependency.getActualFilePath(), (Object)ce);
        }
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.composer.lock.enabled";
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.INFORMATION_COLLECTION;
    }
}

