/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.lucene;

import java.io.IOException;
import java.util.ArrayDeque;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

@NotThreadSafe
public abstract class AbstractTokenizingFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final ArrayDeque<String> tokens = new ArrayDeque();

    protected CharTermAttribute getTermAtt() {
        return this.termAtt;
    }

    protected ArrayDeque<String> getTokens() {
        return this.tokens;
    }

    public AbstractTokenizingFilter(TokenStream stream) {
        super(stream);
    }

    public void reset() throws IOException {
        super.reset();
        this.tokens.clear();
    }

    protected boolean addTerm() {
        boolean termAdded;
        boolean bl = termAdded = !this.tokens.isEmpty();
        if (termAdded) {
            String term = this.tokens.pop();
            this.clearAttributes();
            this.termAtt.append(term);
        }
        return termAdded;
    }
}

