/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.pac4j.core.profile.RawDataObject;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProfileHelper {
    private static final Logger logger = LoggerFactory.getLogger(ProfileHelper.class);

    public static boolean isTypedIdOf(String id, Class<? extends UserProfile> clazz) {
        return id != null && clazz != null && id.startsWith(clazz.getSimpleName() + "#");
    }

    public static UserProfile buildProfile(String typedId, Map<String, Object> attributes) {
        String className;
        String[] values;
        if (typedId != null && (values = typedId.split("#")) != null && values.length == 2 && (className = values[0]) != null) {
            try {
                String completeName;
                if ("CasProfile".equals(className) || "CasProxyProfile".equals(className)) {
                    completeName = "org.pac4j.cas.profile." + className;
                } else if ("Saml2Profile".equals(className)) {
                    completeName = "org.pac4j.saml.profile.Saml2Profile";
                } else if ("HttpProfile".equals(className)) {
                    completeName = "org.pac4j.http.profile.HttpProfile";
                } else if ("MyOpenIdProfile".equals(className)) {
                    completeName = "org.pac4j.openid.profile.myopenid.MyOpenIdProfile";
                } else if ("YahooOpenIdProfile".equals(className)) {
                    completeName = "org.pac4j.openid.profile.yahoo.YahooOpenIdProfile";
                } else if ("GaeUserServiceProfile".equals(className)) {
                    completeName = "org.pac4j.gae.profile.GaeUserServiceProfile";
                } else {
                    String packageName = className.substring(0, className.length() - 7).toLowerCase();
                    completeName = "org.pac4j.oauth.profile." + packageName + "." + className;
                }
                Constructor<?> constructor = Class.forName(completeName).getDeclaredConstructor(new Class[0]);
                UserProfile userProfile = (UserProfile)constructor.newInstance(new Object[0]);
                userProfile.build(typedId, attributes);
                logger.debug("userProfile built : {}", (Object)userProfile);
                return userProfile;
            }
            catch (Exception e) {
                logger.error("Cannot build instance", (Throwable)e);
            }
        }
        return null;
    }

    public static void setKeepRawData(boolean keepRawData) {
        RawDataObject.setKeepRawData(keepRawData);
    }
}

