/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.http.ajax.AjaxRequestResolver;
import org.pac4j.core.http.ajax.DefaultAjaxRequestResolver;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.QueryParameterCallbackUrlResolver;
import org.pac4j.core.http.url.DefaultUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.core.logout.LogoutActionBuilder;
import org.pac4j.core.logout.NoLogoutActionBuilder;
import org.pac4j.core.logout.processor.LogoutProcessor;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.redirect.RedirectionActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;

public abstract class IndirectClient
extends BaseClient {
    public static final String ATTEMPTED_AUTHENTICATION_SUFFIX = "$attemptedAuthentication";
    private static final String STATE_SESSION_PARAMETER = "$stateSessionParameter";
    private static final String NONCE_SESSION_PARAMETER = "$nonceSessionParameter";
    private static final String CODE_VERIFIER_SESSION_PARAMETER = "$codeVerifierSessionParameter";
    protected String callbackUrl;
    protected UrlResolver urlResolver;
    protected CallbackUrlResolver callbackUrlResolver;
    private AjaxRequestResolver ajaxRequestResolver;
    private RedirectionActionBuilder redirectionActionBuilder;
    private LogoutProcessor logoutProcessor;
    private LogoutActionBuilder logoutActionBuilder = NoLogoutActionBuilder.INSTANCE;
    private boolean checkAuthenticationAttempt = true;

    @Override
    protected void beforeInternalInit(boolean forceReinit) {
        CommonHelper.assertNotBlank("callbackUrl", this.callbackUrl, "set it up either on this IndirectClient or on the global Config");
        if (this.urlResolver == null) {
            this.urlResolver = new DefaultUrlResolver();
        }
        if (this.callbackUrlResolver == null) {
            this.callbackUrlResolver = this.newDefaultCallbackUrlResolver();
        }
        if (this.ajaxRequestResolver == null) {
            this.ajaxRequestResolver = new DefaultAjaxRequestResolver();
        }
        if (this.saveProfileInSession == null) {
            this.saveProfileInSession = true;
        }
    }

    @Override
    protected final void afterInternalInit(boolean forceReinit) {
        CommonHelper.assertNotNull("redirectionActionBuilder", this.redirectionActionBuilder);
        CommonHelper.assertNotNull("credentialsExtractor", this.getCredentialsExtractor());
        CommonHelper.assertNotNull("authenticator", this.getAuthenticator());
        CommonHelper.assertNotNull("profileCreator", this.getProfileCreator());
        CommonHelper.assertNotNull("logoutActionBuilder", this.logoutActionBuilder);
    }

    protected CallbackUrlResolver newDefaultCallbackUrlResolver() {
        return new QueryParameterCallbackUrlResolver();
    }

    @Override
    public final Optional<RedirectionAction> getRedirectionAction(CallContext ctx) {
        this.init();
        WebContext webContext = ctx.webContext();
        SessionStore sessionStore = ctx.sessionStore();
        if (this.ajaxRequestResolver.isAjax(ctx)) {
            HttpAction httpAction = this.ajaxRequestResolver.buildAjaxResponse(ctx, this.redirectionActionBuilder);
            this.logger.debug("AJAX request detected -> returning " + httpAction + " for " + ctx.webContext().getFullRequestURL());
            this.cleanRequestedUrl(webContext, sessionStore);
            throw httpAction;
        }
        Optional<Object> attemptedAuth = sessionStore.get(webContext, this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX);
        if (attemptedAuth.isPresent() && !"".equals(attemptedAuth.get())) {
            this.logger.debug("authentication already attempted -> 401");
            this.cleanAttemptedAuthentication(webContext, sessionStore);
            this.cleanRequestedUrl(webContext, sessionStore);
            throw HttpActionHelper.buildUnauthenticatedAction(webContext);
        }
        return this.redirectionActionBuilder.getRedirectionAction(ctx);
    }

    @Override
    protected void checkCredentials(CallContext ctx, Credentials credentials) {
        WebContext webContext = ctx.webContext();
        SessionStore sessionStore = ctx.sessionStore();
        if (credentials == null && this.getProfileFactoryWhenNotAuthenticated() == null) {
            this.logger.debug("no credentials and profile returned -> remember the authentication attempt");
            this.saveAttemptedAuthentication(webContext, sessionStore);
        } else {
            this.cleanAttemptedAuthentication(webContext, sessionStore);
        }
    }

    @Override
    public HttpAction processLogout(CallContext ctx, Credentials credentials) {
        this.init();
        CommonHelper.assertNotNull("logoutProcessor", this.logoutProcessor);
        return this.logoutProcessor.processLogout(ctx, credentials);
    }

    @Override
    public final Optional<RedirectionAction> getLogoutAction(CallContext ctx, UserProfile currentProfile, String targetUrl) {
        this.init();
        return this.logoutActionBuilder.getLogoutAction(ctx, currentProfile, targetUrl);
    }

    public String computeFinalCallbackUrl(WebContext context) {
        this.init();
        return this.callbackUrlResolver.compute(this.urlResolver, this.callbackUrl, this.getName(), context);
    }

    private void cleanRequestedUrl(WebContext context, SessionStore sessionStore) {
        this.logger.debug("clean requested URL from session");
        sessionStore.set(context, "pac4jRequestedUrl", null);
    }

    private void cleanAttemptedAuthentication(WebContext context, SessionStore sessionStore) {
        this.logger.debug("clean authentication attempt from session");
        sessionStore.set(context, this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX, null);
    }

    public String getStateSessionAttributeName() {
        return this.getName() + STATE_SESSION_PARAMETER;
    }

    public String getNonceSessionAttributeName() {
        return this.getName() + NONCE_SESSION_PARAMETER;
    }

    public String getCodeVerifierSessionAttributeName() {
        return this.getName() + CODE_VERIFIER_SESSION_PARAMETER;
    }

    private void saveAttemptedAuthentication(WebContext context, SessionStore sessionStore) {
        if (this.checkAuthenticationAttempt) {
            this.logger.debug("save authentication attempt in session");
            sessionStore.set(context, this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX, "true");
        }
    }

    protected void setRedirectionActionBuilderIfUndefined(RedirectionActionBuilder redirectActionBuilder) {
        if (this.redirectionActionBuilder == null) {
            this.redirectionActionBuilder = redirectActionBuilder;
        }
    }

    protected void setLogoutProcessorIfUndefined(LogoutProcessor logoutProcessor) {
        if (this.logoutProcessor == null) {
            this.logoutProcessor = logoutProcessor;
        }
    }

    protected void setLogoutActionBuilderIfUndefined(LogoutActionBuilder logoutActionBuilder) {
        if (this.logoutActionBuilder == null || this.logoutActionBuilder == NoLogoutActionBuilder.INSTANCE) {
            this.logoutActionBuilder = logoutActionBuilder;
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public IndirectClient setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public IndirectClient setUrlResolver(UrlResolver urlResolver) {
        this.urlResolver = urlResolver;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public IndirectClient setCallbackUrlResolver(CallbackUrlResolver callbackUrlResolver) {
        this.callbackUrlResolver = callbackUrlResolver;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public IndirectClient setAjaxRequestResolver(AjaxRequestResolver ajaxRequestResolver) {
        this.ajaxRequestResolver = ajaxRequestResolver;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public IndirectClient setRedirectionActionBuilder(RedirectionActionBuilder redirectionActionBuilder) {
        this.redirectionActionBuilder = redirectionActionBuilder;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public IndirectClient setLogoutProcessor(LogoutProcessor logoutProcessor) {
        this.logoutProcessor = logoutProcessor;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public IndirectClient setLogoutActionBuilder(LogoutActionBuilder logoutActionBuilder) {
        this.logoutActionBuilder = logoutActionBuilder;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public IndirectClient setCheckAuthenticationAttempt(boolean checkAuthenticationAttempt) {
        this.checkAuthenticationAttempt = checkAuthenticationAttempt;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UrlResolver getUrlResolver() {
        return this.urlResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CallbackUrlResolver getCallbackUrlResolver() {
        return this.callbackUrlResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AjaxRequestResolver getAjaxRequestResolver() {
        return this.ajaxRequestResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RedirectionActionBuilder getRedirectionActionBuilder() {
        return this.redirectionActionBuilder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogoutProcessor getLogoutProcessor() {
        return this.logoutProcessor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogoutActionBuilder getLogoutActionBuilder() {
        return this.logoutActionBuilder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isCheckAuthenticationAttempt() {
        return this.checkAuthenticationAttempt;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "IndirectClient(super=" + super.toString() + ", callbackUrl=" + this.callbackUrl + ", urlResolver=" + this.urlResolver + ", callbackUrlResolver=" + this.callbackUrlResolver + ", ajaxRequestResolver=" + this.ajaxRequestResolver + ", redirectionActionBuilder=" + this.redirectionActionBuilder + ", logoutProcessor=" + this.logoutProcessor + ", logoutActionBuilder=" + this.logoutActionBuilder + ", checkAuthenticationAttempt=" + this.checkAuthenticationAttempt + ")";
    }
}

