/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.credentials.extractor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextHelper;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.CredentialsException;

public class ParameterExtractor
implements CredentialsExtractor {
    private final String parameterName;
    private boolean supportGetRequest;
    private boolean supportPostRequest;

    public ParameterExtractor(String parameterName) {
        this(parameterName, false, true);
    }

    public ParameterExtractor(String parameterName, boolean supportGetRequest, boolean supportPostRequest) {
        this.parameterName = parameterName;
        this.supportGetRequest = supportGetRequest;
        this.supportPostRequest = supportPostRequest;
    }

    @Override
    public Optional<Credentials> extract(CallContext ctx) {
        WebContext webContext = ctx.webContext();
        if (WebContextHelper.isGet(webContext) && !this.supportGetRequest) {
            throw new CredentialsException("GET requests not supported");
        }
        if (WebContextHelper.isPost(webContext) && !this.supportPostRequest) {
            throw new CredentialsException("POST requests not supported");
        }
        Optional<String> value = webContext.getRequestParameter(this.parameterName);
        if (value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new TokenCredentials(value.get()));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ParameterExtractor(parameterName=" + this.parameterName + ", supportGetRequest=" + this.supportGetRequest + ", supportPostRequest=" + this.supportPostRequest + ")";
    }
}

