/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.matching.matcher;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.matching.matcher.Matcher;
import org.pac4j.core.util.CommonHelper;

public class HeaderMatcher
implements Matcher {
    private String headerName;
    private String expectedValue;
    protected Pattern pattern;

    public HeaderMatcher() {
    }

    public HeaderMatcher(String headerName, String expectedValue) {
        this.setHeaderName(headerName);
        this.setExpectedValue(expectedValue);
    }

    @Override
    public boolean matches(CallContext ctx) {
        CommonHelper.assertNotBlank("headerName", this.headerName);
        Optional<String> headerValue = ctx.webContext().getRequestHeader(this.headerName);
        boolean headerNull = this.expectedValue == null && headerValue.isEmpty();
        boolean headerMatches = headerValue.isPresent() && this.pattern != null && this.pattern.matcher(headerValue.get()).matches();
        return headerNull || headerMatches;
    }

    public void setExpectedValue(String expectedValue) {
        this.expectedValue = expectedValue;
        if (expectedValue != null) {
            this.pattern = Pattern.compile(expectedValue);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getHeaderName() {
        return this.headerName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getExpectedValue() {
        return this.expectedValue;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Pattern getPattern() {
        return this.pattern;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "HeaderMatcher(headerName=" + this.headerName + ", expectedValue=" + this.expectedValue + ", pattern=" + this.pattern + ")";
    }
}

