/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.resource;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.pac4j.core.util.InitializableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public abstract class SpringResourceLoader<M>
extends InitializableObject {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringResourceLoader.class);
    private static final long NO_LAST_MODIFIED = -1L;
    private final Lock lock = new ReentrantLock();
    private final AtomicBoolean byteArrayHasChanged = new AtomicBoolean(true);
    private long lastModified = -1L;
    protected final Resource resource;
    protected M loaded;

    @Override
    protected final void internalInit(boolean forceReinit) {
        this.internalLoad();
        this.hasChanged();
    }

    public final M load() {
        if (this.lock.tryLock()) {
            try {
                if (this.hasChanged()) {
                    this.internalLoad();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.loaded;
    }

    public boolean hasChanged() {
        if (this.resource != null) {
            long newLastModified;
            if (this.resource instanceof ByteArrayResource) {
                return this.byteArrayHasChanged.getAndSet(false);
            }
            try {
                newLastModified = this.resource.lastModified();
            }
            catch (Exception e) {
                newLastModified = -1L;
            }
            boolean hasChanged = this.lastModified != newLastModified;
            LOGGER.debug("lastModified: {} / newLastModified: {} -> hasChanged: {}", new Object[]{this.lastModified, newLastModified, hasChanged});
            this.lastModified = newLastModified;
            return hasChanged;
        }
        return false;
    }

    protected abstract void internalLoad();

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SpringResourceLoader(Resource resource) {
        this.resource = resource;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getLastModified() {
        return this.lastModified;
    }
}

