/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.configuration;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.picketlink.idm.api.CredentialEncoder;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.api.cfg.IdentityConfiguration;
import org.picketlink.idm.api.cfg.IdentityConfigurationRegistry;
import org.picketlink.idm.cache.APICacheProvider;
import org.picketlink.idm.common.exception.IdentityConfigurationException;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.IdentitySessionFactoryImpl;
import org.picketlink.idm.impl.api.session.mapper.DirectIdentityObjectTypeMapperImpl;
import org.picketlink.idm.impl.api.session.mapper.IdentityObjectTypeMapper;
import org.picketlink.idm.impl.api.session.mapper.IdentityObjectTypeMapperImpl;
import org.picketlink.idm.impl.configuration.IdentityConfigurationContextImpl;
import org.picketlink.idm.impl.configuration.IdentityRepositoryConfigurationContextImpl;
import org.picketlink.idm.impl.configuration.IdentitySessionConfigurationContext;
import org.picketlink.idm.impl.configuration.IdentityStoreConfigurationContextImpl;
import org.picketlink.idm.impl.configuration.jaxb2.JAXB2IdentityConfiguration;
import org.picketlink.idm.impl.credential.HashingEncoder;
import org.picketlink.idm.impl.helper.CopyOnWriteRegistry;
import org.picketlink.idm.spi.configuration.IdentityConfigurationContext;
import org.picketlink.idm.spi.configuration.IdentityConfigurationContextRegistry;
import org.picketlink.idm.spi.configuration.IdentityRepositoryConfigurationContext;
import org.picketlink.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.picketlink.idm.spi.configuration.metadata.IdentityConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityRepositoryConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.RealmConfigurationMetaData;
import org.picketlink.idm.spi.repository.IdentityStoreRepository;
import org.picketlink.idm.spi.store.IdentityStore;

public class IdentityConfigurationImpl
implements IdentityConfiguration,
IdentityConfigurationRegistry,
IdentityConfigurationContextRegistry,
Serializable {
    private static final Logger log = Logger.getLogger(IdentityConfigurationImpl.class.getName());
    private IdentityConfigurationMetaData configMD;
    private final CopyOnWriteRegistry registry = new CopyOnWriteRegistry();

    public void register(Object object, String name) throws IdentityException {
        if (!this.registry.register(name, object)) {
            throw new IdentityException("Cannot register object in IdentityContext with name: " + name);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("registering object: " + name + " ; " + object.getClass());
        }
    }

    public void unregister(String name) {
        if (this.registry.unregister(name) == null) {
            log.info("Cannot unregister object from IdentityContext with name: " + name);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("unregistering object: " + name);
        }
    }

    public Object getObject(String name) throws IdentityException {
        Object o = this.registry.getRegistration(name);
        if (o == null) {
            throw new IdentityException("No such mapping in IdentityContext: " + name);
        }
        return o;
    }

    public IdentityConfigurationRegistry getIdentityConfigurationRegistry() {
        return this;
    }

    public IdentityConfiguration configure(IdentityConfigurationMetaData configMD) {
        this.configMD = configMD;
        return this;
    }

    public IdentityConfiguration configure(File configFile) throws IdentityConfigurationException {
        IdentityConfigurationMetaData configMD;
        this.configMD = configMD = JAXB2IdentityConfiguration.createConfigurationMetaData(configFile);
        return this;
    }

    public IdentityConfiguration configure(String configResource) throws IdentityConfigurationException {
        IdentityConfigurationMetaData configMD;
        this.configMD = configMD = JAXB2IdentityConfiguration.createConfigurationMetaData(configResource);
        return this;
    }

    public IdentitySessionFactory buildIdentitySessionFactory() throws IdentityConfigurationException {
        Map<String, IdentitySessionConfigurationContext> realmMap = null;
        if (this.configMD == null) {
            throw new IdentityConfigurationException("Failed to build IdentitySessionFactory. Configuration not initialized");
        }
        try {
            realmMap = this.createRealmMap(this.configMD);
        }
        catch (Exception e) {
            throw new IdentityConfigurationException("Failed to build IdentitySessionFactory", (Throwable)e);
        }
        return new IdentitySessionFactoryImpl(this.configMD, realmMap);
    }

    private Map<String, IdentitySessionConfigurationContext> createRealmMap(IdentityConfigurationMetaData configMD) throws Exception {
        IdentityConfigurationContextImpl configurationContext = new IdentityConfigurationContextImpl(configMD, this);
        HashMap<String, IdentityStore> bootstrappedIdentityStores = new HashMap<String, IdentityStore>();
        HashMap<String, IdentityStore> bootstrappedAttributeStores = new HashMap<String, IdentityStore>();
        for (IdentityStoreConfigurationMetaData metaData : configMD.getIdentityStores()) {
            Class<?> storeClass = null;
            try {
                storeClass = Class.forName(metaData.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IdentityException("Cannot instantiate identity store:" + metaData.getClassName(), (Throwable)e);
            }
            Class[] partypes = new Class[]{String.class};
            Constructor<?> ct = storeClass.getConstructor(partypes);
            Object[] argList = new Object[]{metaData.getId()};
            IdentityStore store = (IdentityStore)ct.newInstance(argList);
            IdentityStoreConfigurationContextImpl storeConfigurationCtx = new IdentityStoreConfigurationContextImpl(configMD, this, metaData);
            store.bootstrap((IdentityStoreConfigurationContext)storeConfigurationCtx);
            bootstrappedIdentityStores.put(store.getId(), store);
            bootstrappedAttributeStores.put(store.getId(), store);
        }
        HashMap<String, IdentityStoreRepository> bootstrappedRepositories = new HashMap<String, IdentityStoreRepository>();
        for (IdentityRepositoryConfigurationMetaData metaData : configMD.getRepositories()) {
            Class<?> repoClass = null;
            try {
                repoClass = Class.forName(metaData.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IdentityException("Cannot instantiate identity store:" + metaData.getClassName(), (Throwable)e);
            }
            Class[] partypes = new Class[]{String.class};
            Constructor<?> ct = repoClass.getConstructor(partypes);
            Object[] argList = new Object[]{metaData.getId()};
            IdentityStoreRepository repo = (IdentityStoreRepository)ct.newInstance(argList);
            IdentityRepositoryConfigurationContextImpl repoConfigurationContext = new IdentityRepositoryConfigurationContextImpl(configMD, this, metaData);
            repo.bootstrap((IdentityRepositoryConfigurationContext)repoConfigurationContext, bootstrappedIdentityStores, bootstrappedAttributeStores);
            bootstrappedRepositories.put(repo.getId(), repo);
        }
        HashMap<String, IdentitySessionConfigurationContext> sessionCtxMap = new HashMap<String, IdentitySessionConfigurationContext>();
        for (RealmConfigurationMetaData metaData : configMD.getRealms()) {
            String realmName = metaData.getId();
            IdentityStoreRepository repo = (IdentityStoreRepository)bootstrappedRepositories.get(metaData.getIdentityRepositoryIdRef());
            IdentityObjectTypeMapper mapper = null;
            mapper = metaData.getGroupTypeMappings() == null || metaData.getGroupTypeMappings().isEmpty() ? new DirectIdentityObjectTypeMapperImpl(metaData.getIdentityMapping()) : new IdentityObjectTypeMapperImpl(metaData.getGroupTypeMappings(), metaData.getIdentityMapping());
            HashMap cacheProps = new HashMap();
            String cacheClassName = null;
            String cacheRegistryName = null;
            if (metaData.getOptions() != null) {
                for (String key : metaData.getOptions().keySet()) {
                    if (!key.startsWith("cache.")) continue;
                    if (((List)metaData.getOptions().get(key)).size() > 0) {
                        cacheProps.put(key, ((List)metaData.getOptions().get(key)).get(0));
                    }
                    if (key.equals("cache.providerClass") && ((List)metaData.getOptions().get(key)).size() > 0) {
                        cacheClassName = (String)((List)metaData.getOptions().get(key)).get(0);
                    }
                    if (!key.equals("cache.providerRegistryName") || ((List)metaData.getOptions().get(key)).size() <= 0) continue;
                    cacheRegistryName = (String)((List)metaData.getOptions().get(key)).get(0);
                }
            }
            APICacheProvider provider = null;
            if (cacheRegistryName != null) {
                try {
                    provider = (APICacheProvider)configurationContext.getConfigurationRegistry().getObject(cacheRegistryName);
                }
                catch (Exception e) {
                    throw new IdentityException("Cannot find APICacheProvider in ConfigurationRegistry using provided name:" + cacheRegistryName, (Throwable)e);
                }
            }
            if (cacheClassName != null) {
                Class<?> repoClass = null;
                try {
                    repoClass = Class.forName(cacheClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new IdentityException("Cannot instantiate APICacheProvider:" + cacheClassName, (Throwable)e);
                }
                Constructor<?> ct = repoClass.getConstructor(new Class[0]);
                provider = (APICacheProvider)ct.newInstance(new Object[0]);
                provider.initialize(cacheProps, (IdentityConfigurationRegistry)configurationContext.getConfigurationRegistry());
            }
            CredentialEncoder credentialEncoder = this.createCredentialEncoder(metaData, configurationContext);
            IdentitySessionConfigurationContext sessionConfigCtx = new IdentitySessionConfigurationContext(realmName, configMD, repo, mapper, provider, credentialEncoder, configurationContext, metaData.getOptions());
            sessionCtxMap.put(realmName, sessionConfigCtx);
        }
        return sessionCtxMap;
    }

    public CredentialEncoder createCredentialEncoder(RealmConfigurationMetaData metaData, IdentityConfigurationContext configurationContext) throws Exception {
        HashMap credentialEncoderProps = new HashMap();
        String credentialEncoderClassName = null;
        String credentialEncoderRegistryName = null;
        if (metaData.getOptions() != null) {
            for (String key : metaData.getOptions().keySet()) {
                if (!key.startsWith("credentialEncoder.")) continue;
                if (((List)metaData.getOptions().get(key)).size() > 0) {
                    credentialEncoderProps.put(key, ((List)metaData.getOptions().get(key)).get(0));
                }
                if (key.equals("credentialEncoder.class") && ((List)metaData.getOptions().get(key)).size() > 0) {
                    credentialEncoderClassName = (String)((List)metaData.getOptions().get(key)).get(0);
                }
                if (!key.equals("credentialEncoder.registryName") || ((List)metaData.getOptions().get(key)).size() <= 0) continue;
                credentialEncoderRegistryName = (String)((List)metaData.getOptions().get(key)).get(0);
            }
        }
        CredentialEncoder credentialEncoder = null;
        if (credentialEncoderRegistryName != null) {
            try {
                credentialEncoder = (CredentialEncoder)configurationContext.getConfigurationRegistry().getObject(credentialEncoderRegistryName);
            }
            catch (Exception e) {
                throw new IdentityException("Cannot find CredentialEncoder in ConfigurationRegistry using provided name:" + credentialEncoderRegistryName, (Throwable)e);
            }
        }
        if (credentialEncoderClassName != null) {
            Class<?> encoderClass;
            try {
                encoderClass = Class.forName(credentialEncoderClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IdentityException("Cannot instantiate CredentialEncoder of class: " + credentialEncoderClassName, (Throwable)e);
            }
            Constructor<?> ct = encoderClass.getConstructor(new Class[0]);
            credentialEncoder = (CredentialEncoder)ct.newInstance(new Object[0]);
            credentialEncoder.initialize(credentialEncoderProps);
        }
        if (credentialEncoder == null) {
            credentialEncoder = new HashingEncoder();
            credentialEncoder.initialize(credentialEncoderProps);
        }
        return credentialEncoder;
    }
}

