/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import junit.framework.Assert;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.AttributeDescription;
import org.picketlink.idm.api.Credential;
import org.picketlink.idm.api.CredentialType;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.User;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.APITestContext;
import org.picketlink.idm.impl.api.BinaryCredential;
import org.picketlink.idm.impl.api.PasswordCredential;
import org.picketlink.idm.impl.api.SimpleAttribute;
import org.picketlink.idm.impl.api.session.IdentitySessionImpl;

public class OrganizationTest
extends Assert {
    APITestContext ctx;

    public OrganizationTest(APITestContext ctx) {
        this.ctx = ctx;
    }

    public void setCtx(APITestContext ctx) {
        this.ctx = ctx;
    }

    public APITestContext getCtx() {
        return this.ctx;
    }

    public void testRedHatOrganization(String realmName) throws Exception {
        String ORGANIZATION = "ORGANIZATION";
        String ORGANIZATION_UNIT = "ORGANIZATION_UNIT";
        String DIVISION = "DIVISION";
        String DEPARTMENT = "DEPARTMENT";
        String PROJECT = "PROJECT";
        String PEOPLE = "PEOPLE";
        IdentitySessionFactory factory = this.ctx.getIdentitySessionFactory();
        IdentitySession session = factory.createIdentitySession(realmName);
        this.ctx.begin();
        Group rhOrg = session.getPersistenceManager().createGroup("RedHat", ORGANIZATION);
        Group jbossDivision = session.getPersistenceManager().createGroup("JBoss", DIVISION);
        Group rhelDivision = session.getPersistenceManager().createGroup("RHEL", DIVISION);
        session.getRelationshipManager().associateGroups(rhOrg, jbossDivision);
        session.getRelationshipManager().associateGroups(rhOrg, rhelDivision);
        Group itDepartment = session.getPersistenceManager().createGroup("IT", DEPARTMENT);
        Group hrDepartment = session.getPersistenceManager().createGroup("HR", DEPARTMENT);
        session.getRelationshipManager().associateGroups(jbossDivision, itDepartment);
        session.getRelationshipManager().associateGroups(jbossDivision, hrDepartment);
        Group rndDepartment = session.getPersistenceManager().createGroup("RnD", DEPARTMENT);
        session.getRelationshipManager().associateGroups(itDepartment, rndDepartment);
        Group projectsOU = session.getPersistenceManager().createGroup("Projects", ORGANIZATION_UNIT);
        Group commonFrameworksOU = session.getPersistenceManager().createGroup("Common Frameworks", ORGANIZATION_UNIT);
        session.getRelationshipManager().associateGroups(rndDepartment, projectsOU);
        Group portalProject = session.getPersistenceManager().createGroup("Portal", PROJECT);
        Group soaProject = session.getPersistenceManager().createGroup("SOA", PROJECT);
        Group jbpmProject = session.getPersistenceManager().createGroup("jBPM", PROJECT);
        Group seamProject = session.getPersistenceManager().createGroup("Seam", PROJECT);
        Group asProject = session.getPersistenceManager().createGroup("AS", PROJECT);
        Group securityProject = session.getPersistenceManager().createGroup("Security", PROJECT);
        session.getRelationshipManager().associateGroups(projectsOU, portalProject);
        session.getRelationshipManager().associateGroups(projectsOU, soaProject);
        session.getRelationshipManager().associateGroups(projectsOU, jbpmProject);
        session.getRelationshipManager().associateGroups(projectsOU, asProject);
        session.getRelationshipManager().associateGroups(projectsOU, seamProject);
        OrganizationTest.assertTrue((boolean)session.getRelationshipManager().isAssociated((IdentityType)projectsOU, (IdentityType)portalProject));
        OrganizationTest.assertTrue((boolean)session.getRelationshipManager().isAssociated((IdentityType)projectsOU, (IdentityType)soaProject));
        OrganizationTest.assertTrue((boolean)session.getRelationshipManager().isAssociated((IdentityType)projectsOU, (IdentityType)jbpmProject));
        OrganizationTest.assertTrue((boolean)session.getRelationshipManager().isAssociated((IdentityType)projectsOU, (IdentityType)asProject));
        OrganizationTest.assertTrue((boolean)session.getRelationshipManager().isAssociated((IdentityType)projectsOU, (IdentityType)seamProject));
        session.getRelationshipManager().associateGroups(commonFrameworksOU, portalProject);
        Group employeesGroup = session.getPersistenceManager().createGroup("Employees", PEOPLE);
        User theuteUser = session.getPersistenceManager().createUser("theute");
        User mlittleUser = session.getPersistenceManager().createUser("mlittle");
        User bgeorgesUser = session.getPersistenceManager().createUser("bgeorges");
        User asaldhanaUser = session.getPersistenceManager().createUser("asaldhana");
        User janderseUser = session.getPersistenceManager().createUser("janderse");
        User bdawidowUser = session.getPersistenceManager().createUser("bdawidow");
        User claprunUser = session.getPersistenceManager().createUser("claprun");
        User whalesUser = session.getPersistenceManager().createUser("whales");
        User sshahUser = session.getPersistenceManager().createUser("sshah");
        User mwringeUser = session.getPersistenceManager().createUser("mwringe");
        session.getRelationshipManager().associateUser(employeesGroup, theuteUser);
        session.getRelationshipManager().associateUser(employeesGroup, mlittleUser);
        session.getRelationshipManager().associateUser(employeesGroup, asaldhanaUser);
        session.getRelationshipManager().associateUser(employeesGroup, bdawidowUser);
        session.getRelationshipManager().associateUser(employeesGroup, claprunUser);
        session.getRelationshipManager().associateUser(employeesGroup, whalesUser);
        session.getRelationshipManager().associateUser(employeesGroup, sshahUser);
        session.getRelationshipManager().associateUser(employeesGroup, mwringeUser);
        Group portalTeamGroup = session.getPersistenceManager().createGroup("Portal Team", PEOPLE);
        session.getRelationshipManager().associateUser(portalTeamGroup, bdawidowUser);
        session.getRelationshipManager().associateUser(portalTeamGroup, claprunUser);
        session.getRelationshipManager().associateUser(portalTeamGroup, whalesUser);
        session.getRelationshipManager().associateUser(portalTeamGroup, sshahUser);
        session.getRelationshipManager().associateUser(portalTeamGroup, mwringeUser);
        session.getRelationshipManager().associateGroups(commonFrameworksOU, portalTeamGroup);
        RoleType developerRT = session.getRoleManager().createRoleType("Developer");
        RoleType managerRT = session.getRoleManager().createRoleType("Manager");
        RoleType leadDeveloperRT = session.getRoleManager().createRoleType("Lead Developer");
        RoleType productManagerRT = session.getRoleManager().createRoleType("Product Manager");
        session.getRoleManager().createRole(managerRT, bgeorgesUser, commonFrameworksOU);
        session.getRoleManager().createRole(developerRT, theuteUser, portalProject);
        session.getRoleManager().createRole(developerRT, bdawidowUser, portalProject);
        session.getRoleManager().createRole(developerRT, claprunUser, portalProject);
        session.getRoleManager().createRole(developerRT, whalesUser, portalProject);
        session.getRoleManager().createRole(developerRT, sshahUser, portalProject);
        session.getRoleManager().createRole(developerRT, mwringeUser, portalProject);
        session.getRoleManager().createRole(leadDeveloperRT, theuteUser, portalProject);
        session.getRoleManager().createRole(managerRT, theuteUser, portalTeamGroup);
        session.getRoleManager().createRole(productManagerRT, janderseUser, portalProject);
        session.getRoleManager().createRole(developerRT, mlittleUser, portalProject);
        session.getRoleManager().createRole(productManagerRT, mlittleUser, portalProject);
        session.getRoleManager().createRole(developerRT, asaldhanaUser, asProject);
        session.getRoleManager().createRole(developerRT, asaldhanaUser, securityProject);
        session.getRoleManager().createRole(leadDeveloperRT, asaldhanaUser, securityProject);
        Collection roleTypes = session.getRoleManager().findUserRoleTypes(theuteUser);
        OrganizationTest.assertEquals((int)3, (int)roleTypes.size());
        OrganizationTest.assertTrue((boolean)roleTypes.contains(developerRT));
        OrganizationTest.assertTrue((boolean)roleTypes.contains(leadDeveloperRT));
        OrganizationTest.assertTrue((boolean)roleTypes.contains(managerRT));
        OrganizationTest.assertFalse((boolean)roleTypes.contains(productManagerRT));
        OrganizationTest.assertTrue((boolean)session.getRoleManager().hasRole(theuteUser, portalProject, developerRT));
        OrganizationTest.assertTrue((boolean)session.getRoleManager().hasRole(theuteUser, portalProject, leadDeveloperRT));
        OrganizationTest.assertTrue((boolean)session.getRoleManager().hasRole(theuteUser, portalTeamGroup, managerRT));
        roleTypes = session.getRoleManager().findUserRoleTypes(asaldhanaUser);
        OrganizationTest.assertEquals((int)2, (int)roleTypes.size());
        OrganizationTest.assertTrue((boolean)roleTypes.contains(developerRT));
        OrganizationTest.assertTrue((boolean)roleTypes.contains(leadDeveloperRT));
        roleTypes = session.getRoleManager().findRoleTypes(asaldhanaUser, securityProject);
        OrganizationTest.assertEquals((int)2, (int)roleTypes.size());
        OrganizationTest.assertTrue((boolean)roleTypes.contains(leadDeveloperRT));
        roleTypes = session.getRoleManager().findRoleTypes(asaldhanaUser, asProject);
        OrganizationTest.assertEquals((int)1, (int)roleTypes.size());
        OrganizationTest.assertTrue((boolean)roleTypes.contains(developerRT));
        OrganizationTest.assertTrue((boolean)session.getRoleManager().hasRole(asaldhanaUser, asProject, developerRT));
        Collection identities = session.getRelationshipManager().findAssociatedUsers(portalTeamGroup, false);
        OrganizationTest.assertEquals((int)5, (int)identities.size());
        OrganizationTest.assertTrue((boolean)identities.contains(claprunUser));
        OrganizationTest.assertTrue((boolean)identities.contains(mwringeUser));
        OrganizationTest.assertTrue((boolean)identities.contains(sshahUser));
        OrganizationTest.assertTrue((boolean)identities.contains(whalesUser));
        OrganizationTest.assertTrue((boolean)identities.contains(bdawidowUser));
        Collection groups = session.getRelationshipManager().findAssociatedGroups(rndDepartment, PROJECT, true, false);
        OrganizationTest.assertEquals((int)0, (int)groups.size());
        groups = session.getRelationshipManager().findAssociatedGroups(asaldhanaUser, PEOPLE);
        OrganizationTest.assertEquals((int)1, (int)groups.size());
        OrganizationTest.assertTrue((boolean)groups.contains(employeesGroup));
        groups = session.getRelationshipManager().findAssociatedGroups(sshahUser, PEOPLE);
        OrganizationTest.assertEquals((int)2, (int)groups.size());
        OrganizationTest.assertTrue((boolean)groups.contains(employeesGroup));
        OrganizationTest.assertTrue((boolean)groups.contains(portalTeamGroup));
        Attribute[] userInfo = new Attribute[]{new SimpleAttribute("user.name.given", (Object[])new String[]{"Boleslaw"}), new SimpleAttribute("user.name.family", (Object[])new String[]{"Dawidowicz"}), new SimpleAttribute("email", (Object[])new String[]{"bd@example.com"})};
        session.getAttributesManager().addAttributes((IdentityType)bdawidowUser, userInfo);
        Map attributes = session.getAttributesManager().getAttributes((IdentityType)bdawidowUser);
        OrganizationTest.assertEquals((int)3, (int)attributes.keySet().size());
        OrganizationTest.assertEquals((Object)"Dawidowicz", (Object)((Attribute)attributes.get("user.name.family")).getValue());
        userInfo = new Attribute[]{new SimpleAttribute("description", (Object[])new String[]{"some description"})};
        session.getAttributesManager().addAttributes((IdentityType)bdawidowUser, userInfo);
        session.getAttributesManager().updateAttributes((IdentityType)bdawidowUser, userInfo);
        attributes = session.getAttributesManager().getAttributes((IdentityType)bdawidowUser);
        OrganizationTest.assertEquals((int)3, (int)attributes.keySet().size());
        OrganizationTest.assertEquals(null, attributes.get("description"));
        Random random = new Random();
        AttributeDescription attributeDescription = session.getAttributesManager().getAttributeDescription((IdentityType)bdawidowUser, "picture");
        if (attributeDescription != null && attributeDescription.getType().equals("binary")) {
            byte[] picture = new byte[921600];
            random.nextBytes(picture);
            userInfo = new Attribute[]{new SimpleAttribute("picture", (Object[])new byte[][]{picture})};
            session.getAttributesManager().addAttributes((IdentityType)bdawidowUser, userInfo);
            attributes = session.getAttributesManager().getAttributes((IdentityType)bdawidowUser);
            OrganizationTest.assertEquals((int)4, (int)attributes.keySet().size());
            OrganizationTest.assertEquals((Object)"Dawidowicz", (Object)((Attribute)attributes.get("user.name.family")).getValue());
            OrganizationTest.assertTrue((boolean)Arrays.equals((byte[])((Attribute)attributes.get("picture")).getValue(), picture));
            picture = new byte[50600];
            random.nextBytes(picture);
            userInfo = new Attribute[]{new SimpleAttribute("picture", (Object[])new byte[][]{picture})};
            session.getAttributesManager().updateAttributes((IdentityType)bdawidowUser, userInfo);
            attributes = session.getAttributesManager().getAttributes((IdentityType)bdawidowUser);
            OrganizationTest.assertEquals((int)4, (int)attributes.keySet().size());
            OrganizationTest.assertTrue((boolean)Arrays.equals((byte[])((Attribute)attributes.get("picture")).getValue(), picture));
        }
        OrganizationTest.assertNull((Object)session.getAttributesManager().findUserByUniqueAttribute("email", (Object)"toto"));
        User user = session.getAttributesManager().findUserByUniqueAttribute("email", (Object)"bd@example.com");
        OrganizationTest.assertEquals((Object)bdawidowUser, (Object)user);
        attributeDescription = session.getAttributesManager().getAttributeDescription((IdentityType)bdawidowUser, "email");
        if (attributeDescription != null && attributeDescription.isUnique()) {
            try {
                userInfo = new Attribute[]{new SimpleAttribute("email", (Object[])new String[]{"bd@example.com"})};
                session.getAttributesManager().addAttributes((IdentityType)theuteUser, userInfo);
                OrganizationTest.fail();
            }
            catch (IdentityException e) {
                // empty catch block
            }
        }
        User anotherOne = bdawidowUser;
        if (session.getAttributesManager().isCredentialTypeSupported((CredentialType)PasswordCredential.TYPE)) {
            session.getAttributesManager().updatePassword(anotherOne, "Password2000");
            OrganizationTest.assertTrue((boolean)session.getAttributesManager().validatePassword(anotherOne, "Password2000"));
            OrganizationTest.assertFalse((boolean)session.getAttributesManager().validatePassword(anotherOne, "Password2001"));
            OrganizationTest.assertFalse((boolean)session.getAttributesManager().validatePassword(anotherOne, "Password2002"));
            session.getAttributesManager().updatePassword(anotherOne, "Password2002");
            OrganizationTest.assertTrue((boolean)session.getAttributesManager().validatePassword(anotherOne, "Password2002"));
            OrganizationTest.assertFalse((boolean)session.getAttributesManager().validatePassword(anotherOne, "Password2001"));
            OrganizationTest.assertFalse((boolean)session.getAttributesManager().validatePassword(anotherOne, "wirdPasswordValue"));
            OrganizationTest.assertFalse((boolean)session.getAttributesManager().validatePassword(anotherOne, "Password2003"));
            session.getAttributesManager().updatePassword(anotherOne, "Password2003");
            OrganizationTest.assertTrue((boolean)session.getAttributesManager().validatePassword(anotherOne, "Password2003"));
            OrganizationTest.assertFalse((boolean)session.getAttributesManager().validatePassword(anotherOne, "Password2005"));
            OrganizationTest.assertFalse((boolean)session.getAttributesManager().validatePassword(anotherOne, "Password2006"));
            OrganizationTest.assertFalse((boolean)session.getAttributesManager().validatePassword(anotherOne, "Password2007"));
            PasswordCredential password = new PasswordCredential("SuperPassword2345", ((IdentitySessionImpl)session).getCredentialEncoder(), anotherOne.getKey());
            session.getAttributesManager().updateCredential(anotherOne, (Credential)password);
            OrganizationTest.assertTrue((boolean)session.getAttributesManager().validateCredentials(anotherOne, new Credential[]{password}));
        }
        if (session.getAttributesManager().isCredentialTypeSupported((CredentialType)BinaryCredential.TYPE)) {
            byte[] cert = new byte[512000];
            random.nextBytes(cert);
            BinaryCredential binaryCredential = new BinaryCredential(cert);
            session.getAttributesManager().updateCredential(anotherOne, (Credential)binaryCredential);
            OrganizationTest.assertTrue((boolean)session.getAttributesManager().validateCredentials(anotherOne, new Credential[]{binaryCredential}));
        }
        session.getPersistenceManager().createUser("!(06_13_07 Sche) !(0");
        User u1 = session.getPersistenceManager().findUser("!(06_13_07 Sche) !(0");
        OrganizationTest.assertNotNull((Object)u1);
        this.ctx.commit();
    }

    public void testSamplePortal(String realmName) throws Exception {
        String SYSTEM = "SYSTEM";
        String ADMINISTRATION = "ADMINISTRATION";
        String COMMUNITY = "COMMUNITY";
        String ORGANIZATION = "ORGANIZATION";
        String ORGANIZATION_UNIT = "ORGANIZATION_UNIT";
        String OFFICE = "OFFICE";
        String DIVISION = "DIVISION";
        String DEPARTMENT = "DEPARTMENT";
        String SECURITY = "SECURITY";
        String PEOPLE = "PEOPLE";
        IdentitySessionFactory factory = this.ctx.getIdentitySessionFactory();
        IdentitySession session = factory.createIdentitySession(realmName);
        this.ctx.begin();
        RoleType adminRT = session.getRoleManager().createRoleType("Admin");
        RoleType accountAdminRT = session.getRoleManager().createRoleType("Account Admin");
        RoleType managerRT = session.getRoleManager().createRoleType("Manager");
        RoleType officeManagerRT = session.getRoleManager().createRoleType("Office Manager");
        RoleType contributorRT = session.getRoleManager().createRoleType("Contributor");
        RoleType communityOwnerRT = session.getRoleManager().createRoleType("Community Owner");
        RoleType communityMemberRT = session.getRoleManager().createRoleType("Community Member");
        RoleType communityForumModeratorRT = session.getRoleManager().createRoleType("Community Forum Moderator");
        RoleType communityCMSAdminRT = session.getRoleManager().createRoleType("Community CMS Admin");
        Group communityRootGroup = session.getPersistenceManager().createGroup("COMMUNITY_ROOT", SYSTEM);
        Group securityRootGroup = session.getPersistenceManager().createGroup("SECURITY_ROOT", SYSTEM);
        Group organizationRootGroup = session.getPersistenceManager().createGroup("ORGANIZATION_ROOT", SYSTEM);
        Group usersROOTGroup = session.getPersistenceManager().createGroup("USERS_ROOT", SYSTEM);
        this.ctx.commit();
        this.ctx.begin();
        Group portalLoversCommunity = session.getPersistenceManager().createGroup("Portal Lovers", COMMUNITY);
        Group baseJumpingCommunity = session.getPersistenceManager().createGroup("BASE Jumping", COMMUNITY);
        Group geeksCommunity = session.getPersistenceManager().createGroup("Geeks", COMMUNITY);
        session.getRelationshipManager().associateGroups(communityRootGroup, portalLoversCommunity);
        session.getRelationshipManager().associateGroups(communityRootGroup, baseJumpingCommunity);
        session.getRelationshipManager().associateGroups(communityRootGroup, geeksCommunity);
        Group portalAdminGroup = session.getPersistenceManager().createGroup("Poral Admin", SECURITY);
        Group cmsAdminGroup = session.getPersistenceManager().createGroup("CMS Admin", SECURITY);
        Group userAdminGroup = session.getPersistenceManager().createGroup("User Admin", SECURITY);
        Group cmsEditorGroup = session.getPersistenceManager().createGroup("CMS Editor", SECURITY);
        session.getRelationshipManager().associateGroups(securityRootGroup, portalAdminGroup);
        session.getRelationshipManager().associateGroups(securityRootGroup, cmsAdminGroup);
        session.getRelationshipManager().associateGroups(securityRootGroup, userAdminGroup);
        session.getRelationshipManager().associateGroups(securityRootGroup, cmsEditorGroup);
        Group acmeOrg = session.getPersistenceManager().createGroup("ACME", ORGANIZATION);
        session.getRelationshipManager().associateGroups(organizationRootGroup, acmeOrg);
        Group departmentsOU = session.getPersistenceManager().createGroup("Departments", ORGANIZATION_UNIT);
        Group officesOU = session.getPersistenceManager().createGroup("Offices", ORGANIZATION_UNIT);
        Group employeesOU = session.getPersistenceManager().createGroup("Employees", ORGANIZATION_UNIT);
        session.getRelationshipManager().associateGroups(acmeOrg, departmentsOU);
        session.getRelationshipManager().associateGroups(acmeOrg, officesOU);
        session.getRelationshipManager().associateGroups(acmeOrg, employeesOU);
        Group hrDepart = session.getPersistenceManager().createGroup("HR", DEPARTMENT);
        Group financeDepart = session.getPersistenceManager().createGroup("Finance", DEPARTMENT);
        Group rndDepart = session.getPersistenceManager().createGroup("R&D", DEPARTMENT);
        session.getRelationshipManager().associateGroups(departmentsOU, hrDepart);
        session.getRelationshipManager().associateGroups(departmentsOU, financeDepart);
        session.getRelationshipManager().associateGroups(departmentsOU, rndDepart);
        Group parisOffice = session.getPersistenceManager().createGroup("Paris", OFFICE);
        Group londonOffice = session.getPersistenceManager().createGroup("London", OFFICE);
        Group nyOffice = session.getPersistenceManager().createGroup("New York", OFFICE);
        session.getRelationshipManager().associateGroups(officesOU, parisOffice);
        session.getRelationshipManager().associateGroups(officesOU, londonOffice);
        session.getRelationshipManager().associateGroups(officesOU, nyOffice);
        User anneUser = session.getPersistenceManager().createUser("anne");
        User marieUser = session.getPersistenceManager().createUser("marie");
        User eveUser = session.getPersistenceManager().createUser("eve");
        User angelinaUser = session.getPersistenceManager().createUser("angelina");
        User joannaUser = session.getPersistenceManager().createUser("joanna");
        User merilUser = session.getPersistenceManager().createUser("meril");
        User johnUser = session.getPersistenceManager().createUser("john");
        User stanUser = session.getPersistenceManager().createUser("stan");
        User chrisUser = session.getPersistenceManager().createUser("chris");
        User billUser = session.getPersistenceManager().createUser("bill");
        User jackUser = session.getPersistenceManager().createUser("jack");
        this.ctx.commit();
        this.ctx.begin();
        session.getRelationshipManager().associateUser(usersROOTGroup, anneUser);
        session.getRelationshipManager().associateUser(usersROOTGroup, marieUser);
        session.getRelationshipManager().associateUser(usersROOTGroup, eveUser);
        session.getRelationshipManager().associateUser(usersROOTGroup, angelinaUser);
        session.getRelationshipManager().associateUser(usersROOTGroup, joannaUser);
        session.getRelationshipManager().associateUser(usersROOTGroup, merilUser);
        session.getRelationshipManager().associateUser(usersROOTGroup, johnUser);
        session.getRelationshipManager().associateUser(usersROOTGroup, stanUser);
        session.getRelationshipManager().associateUser(usersROOTGroup, chrisUser);
        session.getRelationshipManager().associateUser(usersROOTGroup, billUser);
        session.getRelationshipManager().associateUser(usersROOTGroup, jackUser);
        this.ctx.commit();
        this.ctx.begin();
        session.getAttributesManager().addAttribute((IdentityType)anneUser, "user.name.given", (Object)"Anne");
        session.getAttributesManager().addAttribute((IdentityType)anneUser, "user.name.family", (Object)"Smith");
        session.getAttributesManager().addAttribute((IdentityType)anneUser, "user.jobtitle", (Object)"Senior Software Developer");
        session.getAttributesManager().addAttribute((IdentityType)anneUser, "user.business-info.online.email", (Object)"anne.smith@acme.com");
        session.getAttributesManager().addAttribute((IdentityType)anneUser, "user.business-info.telecom.mobile.number", (Object)"777 777 777 7 77");
        session.getRelationshipManager().associateUser(parisOffice, anneUser);
        session.save();
        this.ctx.commit();
        this.ctx.begin();
        session.getRoleManager().createRole(communityMemberRT, anneUser, baseJumpingCommunity);
        session.getRoleManager().createRole(communityForumModeratorRT, anneUser, baseJumpingCommunity);
        session.getRoleManager().createRole(communityCMSAdminRT, anneUser, baseJumpingCommunity);
        session.getRelationshipManager().associateUser(cmsAdminGroup, anneUser);
        session.getRoleManager().createRole(communityOwnerRT, anneUser, geeksCommunity);
        session.getAttributesManager().addAttribute((IdentityType)angelinaUser, "user.name.given", (Object)"Angelina");
        session.getAttributesManager().addAttribute((IdentityType)angelinaUser, "user.name.family", (Object)"Blond");
        session.getAttributesManager().addAttribute((IdentityType)angelinaUser, "user.jobtitle", (Object)"Very important looking job title");
        session.getAttributesManager().addAttribute((IdentityType)angelinaUser, "user.business-info.online.email", (Object)"angelina1979@acme.com");
        session.getAttributesManager().addAttribute((IdentityType)angelinaUser, "user.business-info.telecom.mobile.number", (Object)"888 88 88 8888");
        session.getRelationshipManager().associateUser(londonOffice, angelinaUser);
        session.getRoleManager().createRole(officeManagerRT, angelinaUser, londonOffice);
        session.getRoleManager().createRole(communityMemberRT, angelinaUser, geeksCommunity);
        session.getRoleManager().createRole(communityCMSAdminRT, angelinaUser, geeksCommunity);
        session.getRelationshipManager().associateUser(cmsEditorGroup, angelinaUser);
        OrganizationTest.assertEquals((int)11, (int)session.getRelationshipManager().findAssociatedUsers(usersROOTGroup, false).size());
        OrganizationTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedUsers(parisOffice, false).size());
        OrganizationTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedUsers(londonOffice, false).size());
        OrganizationTest.assertTrue((boolean)session.getRoleManager().hasRole(anneUser, geeksCommunity, communityOwnerRT));
        OrganizationTest.assertTrue((boolean)session.getRelationshipManager().isAssociated((IdentityType)cmsAdminGroup, (IdentityType)anneUser));
        Collection groups = session.getRelationshipManager().findAssociatedGroups(anneUser);
        OrganizationTest.assertEquals((int)3, (int)groups.size());
        OrganizationTest.assertTrue((boolean)groups.contains(usersROOTGroup));
        OrganizationTest.assertTrue((boolean)groups.contains(parisOffice));
        OrganizationTest.assertTrue((boolean)groups.contains(cmsAdminGroup));
        this.ctx.commit();
    }
}

