/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api;

import junit.framework.Assert;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.api.User;
import org.picketlink.idm.impl.api.APITestContext;

public class PersistenceManagerTest
extends Assert {
    APITestContext ctx;
    private String ORGANIZATION = "ORGANIZATION";
    private String ORGANIZATION_UNIT = "ORGANIZATION_UNIT";
    private String DIVISION = "DIVISION";
    private String DEPARTMENT = "DEPARTMENT";
    private String PROJECT = "PROJECT";
    private String PEOPLE = "PEOPLE";

    public PersistenceManagerTest(APITestContext ctx) {
        this.ctx = ctx;
    }

    public void setCtx(APITestContext ctx) {
        this.ctx = ctx;
    }

    public APITestContext getCtx() {
        return this.ctx;
    }

    public void testMethods(String realmName) throws Exception {
        IdentitySessionFactory factory = this.ctx.getIdentitySessionFactory();
        IdentitySession session = factory.createIdentitySession(realmName);
        this.ctx.begin();
        try {
            session.getPersistenceManager().createUser("lol_._._lolo");
            PersistenceManagerTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            session.getPersistenceManager().createGroup("jbpid_group_idtoto", this.ORGANIZATION);
            PersistenceManagerTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Group group1 = session.getPersistenceManager().createGroup("groupName1", this.ORGANIZATION);
        PersistenceManagerTest.assertNotNull((Object)group1);
        PersistenceManagerTest.assertEquals((String)group1.getGroupType(), (String)this.ORGANIZATION);
        PersistenceManagerTest.assertEquals((String)group1.getName(), (String)"groupName1");
        String group1Id = session.getPersistenceManager().createGroupKey("groupName1", this.ORGANIZATION);
        PersistenceManagerTest.assertEquals((String)group1Id, (String)group1.getKey());
        group1 = session.getPersistenceManager().findGroupByKey(group1Id);
        PersistenceManagerTest.assertNotNull((Object)group1);
        PersistenceManagerTest.assertEquals((String)group1.getGroupType(), (String)this.ORGANIZATION);
        PersistenceManagerTest.assertEquals((String)group1.getName(), (String)"groupName1");
        session.getPersistenceManager().createGroup("groupName2", this.ORGANIZATION);
        session.getPersistenceManager().createGroup("groupName3", this.PROJECT);
        PersistenceManagerTest.assertEquals((int)2, (int)session.getPersistenceManager().getGroupTypeCount(this.ORGANIZATION));
        PersistenceManagerTest.assertEquals((int)1, (int)session.getPersistenceManager().getGroupTypeCount(this.PROJECT));
        PersistenceManagerTest.assertEquals((int)0, (int)session.getPersistenceManager().getGroupTypeCount(this.DEPARTMENT));
        PersistenceManagerTest.assertEquals((int)2, (int)session.getPersistenceManager().findGroup(this.ORGANIZATION).size());
        PersistenceManagerTest.assertEquals((int)1, (int)session.getPersistenceManager().findGroup(this.PROJECT).size());
        PersistenceManagerTest.assertEquals((int)0, (int)session.getPersistenceManager().findGroup(this.DEPARTMENT).size());
        session.getPersistenceManager().removeGroup(group1, false);
        String id = session.getPersistenceManager().createGroupKey("groupName2", this.ORGANIZATION);
        session.getPersistenceManager().removeGroup(id, false);
        id = session.getPersistenceManager().createGroupKey("groupName3", this.PROJECT);
        session.getPersistenceManager().removeGroup(id, false);
        PersistenceManagerTest.assertEquals((int)0, (int)session.getPersistenceManager().findGroup(this.ORGANIZATION, (IdentitySearchCriteria)null).size());
        PersistenceManagerTest.assertEquals((int)0, (int)session.getPersistenceManager().findGroup(this.PROJECT).size());
        PersistenceManagerTest.assertEquals((int)0, (int)session.getPersistenceManager().findGroup(this.DEPARTMENT).size());
        PersistenceManagerTest.assertEquals((int)0, (int)session.getPersistenceManager().getGroupTypeCount(this.ORGANIZATION));
        PersistenceManagerTest.assertEquals((int)0, (int)session.getPersistenceManager().getGroupTypeCount(this.PROJECT));
        PersistenceManagerTest.assertEquals((int)0, (int)session.getPersistenceManager().getGroupTypeCount(this.DEPARTMENT));
        User u1 = session.getPersistenceManager().createUser("olo");
        PersistenceManagerTest.assertNotNull((Object)u1);
        PersistenceManagerTest.assertEquals((String)u1.getKey(), (String)"olo");
        session.getPersistenceManager().createUser("anna");
        PersistenceManagerTest.assertEquals((int)2, (int)session.getPersistenceManager().getUserCount());
        PersistenceManagerTest.assertNotNull((Object)session.getPersistenceManager().findUser("olo"));
        PersistenceManagerTest.assertNotNull((Object)session.getPersistenceManager().findUser("anna"));
        PersistenceManagerTest.assertEquals((int)2, (int)session.getPersistenceManager().findUser((IdentitySearchCriteria)null).size());
        session.getPersistenceManager().removeUser(u1, false);
        PersistenceManagerTest.assertEquals((int)1, (int)session.getPersistenceManager().getUserCount());
        session.getPersistenceManager().removeUser("anna", false);
        PersistenceManagerTest.assertEquals((int)0, (int)session.getPersistenceManager().getUserCount());
        PersistenceManagerTest.assertEquals((int)0, (int)session.getPersistenceManager().findUser((IdentitySearchCriteria)null).size());
        this.ctx.commit();
    }
}

