/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api;

import java.util.HashMap;
import junit.framework.Assert;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.SortOrder;
import org.picketlink.idm.api.User;
import org.picketlink.idm.impl.api.APITestContext;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;

public class RoleManagerTest
extends Assert {
    APITestContext ctx;
    private String ORGANIZATION = "ORGANIZATION";
    private String ORGANIZATION_UNIT = "ORGANIZATION_UNIT";
    private String DIVISION = "DIVISION";
    private String DEPARTMENT = "DEPARTMENT";
    private String PROJECT = "PROJECT";
    private String PEOPLE = "PEOPLE";

    public RoleManagerTest(APITestContext ctx) {
        this.ctx = ctx;
    }

    public void setCtx(APITestContext ctx) {
        this.ctx = ctx;
    }

    public APITestContext getCtx() {
        return this.ctx;
    }

    public void testMethods(String realmName) throws Exception {
        IdentitySessionFactory factory = this.ctx.getIdentitySessionFactory();
        IdentitySession session = factory.createIdentitySession(realmName);
        this.ctx.begin();
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findRoleTypes(null).size());
        RoleType rt1 = session.getRoleManager().createRoleType("rt1");
        RoleType rt2 = session.getRoleManager().createRoleType("rt2");
        RoleType rt3 = session.getRoleManager().createRoleType("rt3");
        RoleType rt4 = session.getRoleManager().createRoleType("rt4");
        RoleManagerTest.assertEquals((int)4, (int)session.getRoleManager().findRoleTypes(null).size());
        session.getRoleManager().removeRoleType(rt1);
        session.getRoleManager().removeRoleType(rt2);
        RoleManagerTest.assertEquals((int)2, (int)session.getRoleManager().findRoleTypes(null).size());
        session.getRoleManager().removeRoleType("rt3");
        session.getRoleManager().removeRoleType("rt4");
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findRoleTypes(null).size());
        User user1 = session.getPersistenceManager().createUser("user1");
        User user2 = session.getPersistenceManager().createUser("user2");
        User user3 = session.getPersistenceManager().createUser("user3");
        User user4 = session.getPersistenceManager().createUser("user4");
        Group group1 = session.getPersistenceManager().createGroup("group1", this.ORGANIZATION);
        Group group2 = session.getPersistenceManager().createGroup("group2", this.ORGANIZATION_UNIT);
        Group group3 = session.getPersistenceManager().createGroup("group3", this.ORGANIZATION_UNIT);
        Group group4 = session.getPersistenceManager().createGroup("group4", this.DEPARTMENT);
        Group group5 = session.getPersistenceManager().createGroup("group5", this.DEPARTMENT);
        rt1 = session.getRoleManager().createRoleType("rt1");
        rt2 = session.getRoleManager().createRoleType("rt2");
        rt3 = session.getRoleManager().createRoleType("rt3");
        rt4 = session.getRoleManager().createRoleType("rt4");
        RoleManagerTest.assertEquals((int)4, (int)session.getRoleManager().findRoleTypes(null).size());
        Role role1 = session.getRoleManager().createRole(rt1, user1, group1);
        Role role2 = session.getRoleManager().createRole(rt1, user1, group2);
        Role role3 = session.getRoleManager().createRole("rt2", user1.getKey(), group1.getKey());
        RoleManagerTest.assertEquals((int)2, (int)session.getRoleManager().findRoles((IdentityType)user1, rt1).size());
        RoleManagerTest.assertEquals((int)1, (int)session.getRoleManager().findRoles((IdentityType)user1, rt2).size());
        RoleManagerTest.assertEquals((int)1, (int)session.getRoleManager().findRoles((IdentityType)group1, rt1).size());
        RoleManagerTest.assertEquals((int)1, (int)session.getRoleManager().findRoles((IdentityType)group1, rt2).size());
        RoleManagerTest.assertEquals((int)2, (int)session.getRoleManager().findGroupRoleTypes(group1).size());
        RoleManagerTest.assertEquals((int)1, (int)session.getRoleManager().findGroupRoleTypes(group2.getKey(), null).size());
        RoleManagerTest.assertEquals((int)2, (int)session.getRoleManager().findRoles((IdentityType)user1, rt1).size());
        RoleManagerTest.assertEquals((int)1, (int)session.getRoleManager().findRoles(user1.getKey(), "rt2").size());
        RoleManagerTest.assertEquals((int)1, (int)session.getRoleManager().findRoles(group1.getKey(), "rt1").size());
        RoleManagerTest.assertEquals((int)1, (int)session.getRoleManager().findRoles((IdentityType)group1, rt1).size());
        IdentitySearchCriteria crit = new IdentitySearchCriteriaImpl().page(0, 2);
        crit.sort(SortOrder.ASCENDING);
        RoleManagerTest.assertEquals((int)3, (int)session.getRoleManager().findRoles((IdentityType)user1, null, null).size());
        RoleManagerTest.assertEquals((int)2, (int)session.getRoleManager().findRoles((IdentityType)user1, null, crit).size());
        RoleManagerTest.assertEquals((int)2, (int)session.getRoleManager().findRoles((IdentityType)group1, null, null).size());
        RoleManagerTest.assertEquals((int)2, (int)session.getRoleManager().findRoles((IdentityType)group1, null, crit).size());
        RoleManagerTest.assertEquals((int)1, (int)session.getRoleManager().findRoles((IdentityType)group2, null, crit).size());
        RoleManagerTest.assertEquals((int)2, (int)session.getRoleManager().findGroupsWithRelatedRole(user1, null).size());
        RoleManagerTest.assertEquals((int)1, (int)session.getRoleManager().findGroupsWithRelatedRole(user1.getKey(), this.ORGANIZATION, null).size());
        RoleManagerTest.assertEquals((int)2, (int)session.getRoleManager().findRoleTypes(user1, group1).size());
        RoleManagerTest.assertEquals((int)1, (int)session.getRoleManager().findRoleTypes(user1.getKey(), group2.getKey(), null).size());
        RoleManagerTest.assertEquals((int)2, (int)session.getRoleManager().findUserRoleTypes(user1).size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findUserRoleTypes(user2.getKey(), null).size());
        RoleManagerTest.assertTrue((boolean)session.getRoleManager().hasRole(user1, group1, rt1));
        RoleManagerTest.assertTrue((boolean)session.getRoleManager().hasRole(user1, group1, rt2));
        RoleManagerTest.assertTrue((boolean)session.getRoleManager().hasRole("user1", group2.getKey(), "rt1"));
        RoleManagerTest.assertFalse((boolean)session.getRoleManager().hasRole("user2", group2.getKey(), "rt1"));
        RoleManagerTest.assertFalse((boolean)session.getRoleManager().hasRole(user1, group1, rt3));
        RoleManagerTest.assertFalse((boolean)session.getRoleManager().hasRole(user1, group4, rt3));
        RoleManagerTest.assertEquals((int)2, (int)session.getRoleManager().getRolesCount((IdentityType)group1, null, null));
        RoleManagerTest.assertEquals((int)1, (int)session.getRoleManager().getRolesCount((IdentityType)group2, null, null));
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().getProperties(role1).keySet().size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().getProperties(rt1).keySet().size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().getProperties(rt1.getName()).keySet().size());
        session.getRoleManager().setProperty(role1, "roleProp1", "val1");
        session.getRoleManager().setProperty(role1, "roleProp1", "val2");
        session.getRoleManager().setProperty(role1, "roleProp2", "val1");
        session.getRoleManager().setProperty(rt1, "rtProp1", "val1");
        session.getRoleManager().setProperty(rt1.getName(), "rtProp1", "val2");
        session.getRoleManager().setProperty(rt1, "rtProp2", "val1");
        session.getRoleManager().setProperty(rt1, "rtProp3", "val1");
        RoleManagerTest.assertEquals((int)2, (int)session.getRoleManager().getProperties(role1).keySet().size());
        RoleManagerTest.assertEquals((int)3, (int)session.getRoleManager().getProperties(rt1).keySet().size());
        RoleManagerTest.assertEquals((int)3, (int)session.getRoleManager().getProperties(rt1.getName()).keySet().size());
        RoleManagerTest.assertEquals((String)"val2", (String)((String)session.getRoleManager().getProperties(role1).get("roleProp1")));
        RoleManagerTest.assertEquals((String)"val1", (String)((String)session.getRoleManager().getProperties(role1).get("roleProp2")));
        RoleManagerTest.assertEquals((String)"val2", (String)((String)session.getRoleManager().getProperties(rt1).get("rtProp1")));
        RoleManagerTest.assertEquals((String)"val1", (String)((String)session.getRoleManager().getProperties(rt1).get("rtProp2")));
        RoleManagerTest.assertEquals((String)"val1", (String)((String)session.getRoleManager().getProperties(rt1).get("rtProp3")));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("prop5", "val1");
        session.getRoleManager().setProperties(role2, props);
        RoleManagerTest.assertEquals((int)1, (int)session.getRoleManager().getProperties(role2).keySet().size());
        RoleManagerTest.assertEquals((String)"val1", (String)((String)session.getRoleManager().getProperties(role2).get("prop5")));
        props.put("prop6", "val3");
        session.getRoleManager().setProperties(rt2, props);
        session.getRoleManager().setProperties(rt3.getName(), props);
        RoleManagerTest.assertEquals((int)2, (int)session.getRoleManager().getProperties(rt2).keySet().size());
        RoleManagerTest.assertEquals((String)"val3", (String)((String)session.getRoleManager().getProperties(rt2).get("prop6")));
        RoleManagerTest.assertEquals((String)"val3", (String)((String)session.getRoleManager().getProperties(rt3).get("prop6")));
        session.getRoleManager().removeProperty(role2, "prop5");
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().getProperties(role2).keySet().size());
        session.getRoleManager().removeProperty(rt2, "prop6");
        RoleManagerTest.assertEquals((int)1, (int)session.getRoleManager().getProperties(rt2).keySet().size());
        session.getRoleManager().removeProperty(rt2, "prop5");
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().getProperties(rt2).keySet().size());
        session.getRoleManager().removeRole(rt1, user1, group1);
        session.getRoleManager().removeRole(role2);
        session.getRoleManager().removeRole("rt2", user1.getKey(), group1.getKey());
        RoleManagerTest.assertFalse((boolean)session.getRoleManager().hasRole(user1, group1, rt1));
        RoleManagerTest.assertFalse((boolean)session.getRoleManager().hasRole(user1, group1, rt2));
        RoleManagerTest.assertFalse((boolean)session.getRoleManager().hasRole("user1", group2.getKey(), "rt1"));
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findRoles((IdentityType)user1, rt1).size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findRoles((IdentityType)user1, rt2).size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findRoles((IdentityType)group1, rt1).size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findRoles((IdentityType)group1, rt2).size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findGroupRoleTypes(group1).size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findGroupRoleTypes(group2.getKey(), null).size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findRoles((IdentityType)user1, rt1).size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findRoles(user1.getKey(), "rt2").size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findRoles(group1.getKey(), "rt1").size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findRoles((IdentityType)group1, rt1).size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findRoles((IdentityType)user1, null, crit).size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findRoles((IdentityType)group1, null, crit).size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findRoles((IdentityType)group2, null, crit).size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findGroupsWithRelatedRole(user1, null).size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findGroupsWithRelatedRole(user1.getKey(), this.ORGANIZATION, null).size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findRoleTypes(user1, group1).size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findRoleTypes(user1.getKey(), group2.getKey(), null).size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findUserRoleTypes(user1).size());
        RoleManagerTest.assertEquals((int)0, (int)session.getRoleManager().findUserRoleTypes(user2.getKey(), null).size());
        session.getPersistenceManager().createUser("u1");
        Group g1 = session.getPersistenceManager().createGroup("g1", this.ORGANIZATION);
        session.getRoleManager().createRole("rt1", "u1", g1.getKey());
        RoleManagerTest.assertNotNull((Object)session.getRoleManager().getRole("rt1", "u1", g1.getKey()));
        session.getRoleManager().removeRoleType("rt1");
        RoleManagerTest.assertNull((Object)session.getRoleManager().getRole("rt1", "u1", g1.getKey()));
        this.ctx.commit();
    }
}

