/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api;

import junit.framework.Assert;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.User;
import org.picketlink.idm.api.query.RoleQuery;
import org.picketlink.idm.api.query.RoleQueryBuilder;
import org.picketlink.idm.impl.api.APITestContext;

public class RoleQueryTest
extends Assert {
    private APITestContext ctx;
    private String ORGANIZATION = "ORGANIZATION";
    private String ORGANIZATION_UNIT = "ORGANIZATION_UNIT";
    private String DEPARTMENT = "DEPARTMENT";

    public RoleQueryTest(APITestContext testContext) {
        this.ctx = testContext;
    }

    public void testQuery(String realmName) throws Exception {
        this.ctx.begin();
        IdentitySession ids = this.ctx.getIdentitySessionFactory().getCurrentIdentitySession(realmName);
        User user1 = ids.getPersistenceManager().createUser("user1");
        User user2 = ids.getPersistenceManager().createUser("user2");
        User user3 = ids.getPersistenceManager().createUser("user3");
        User user4 = ids.getPersistenceManager().createUser("user4");
        Group group1 = ids.getPersistenceManager().createGroup("group1", this.ORGANIZATION);
        Group group2 = ids.getPersistenceManager().createGroup("group2", this.ORGANIZATION_UNIT);
        Group group3 = ids.getPersistenceManager().createGroup("group3", this.ORGANIZATION_UNIT);
        Group group4 = ids.getPersistenceManager().createGroup("group4", this.DEPARTMENT);
        Group group5 = ids.getPersistenceManager().createGroup("group5", this.DEPARTMENT);
        RoleType rt1 = ids.getRoleManager().createRoleType("rt1");
        RoleType rt2 = ids.getRoleManager().createRoleType("rt2");
        RoleType rt3 = ids.getRoleManager().createRoleType("rt3");
        RoleType rt4 = ids.getRoleManager().createRoleType("rt4");
        Role role1 = ids.getRoleManager().createRole(rt1, user1, group1);
        Role role2 = ids.getRoleManager().createRole(rt1, user1, group2);
        Role role3 = ids.getRoleManager().createRole("rt2", user1.getKey(), group1.getKey());
        RoleQueryBuilder rqb = ids.createRoleQueryBuilder();
        rqb.setUser("user1");
        RoleQuery rq = rqb.createQuery();
        RoleQueryTest.assertEquals((int)3, (int)ids.execute(rq).size());
        rqb.setGroup(group1);
        rq = rqb.createQuery();
        RoleQueryTest.assertEquals((int)2, (int)ids.execute(rq).size());
        rqb.setRoleType(rt2);
        rq = rqb.createQuery();
        RoleQueryTest.assertEquals((int)1, (int)ids.execute(rq).size());
        rqb.reset();
        rqb.setGroup(group2);
        rqb.setRoleType(rt1);
        rq = rqb.createQuery();
        RoleQueryTest.assertEquals((int)1, (int)ids.execute(rq).size());
        RoleQueryTest.assertEquals((Object)role2, (Object)ids.uniqueResult(rq));
        this.ctx.commit();
    }
}

