/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api;

import java.util.List;
import junit.framework.Assert;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.SortOrder;
import org.picketlink.idm.api.User;
import org.picketlink.idm.api.query.UserQuery;
import org.picketlink.idm.api.query.UserQueryBuilder;
import org.picketlink.idm.impl.api.APITestContext;

public class UserQueryTest
extends Assert {
    private APITestContext ctx;
    private String ORGANIZATION = "ORGANIZATION";
    private String ORGANIZATION_UNIT = "ORGANIZATION_UNIT";
    private String DEPARTMENT = "DEPARTMENT";

    public UserQueryTest(APITestContext testContext) {
        this.ctx = testContext;
    }

    public void testQuery(String realmName) throws Exception {
        this.ctx.begin();
        IdentitySession ids = this.ctx.getIdentitySessionFactory().getCurrentIdentitySession(realmName);
        User user1 = ids.getPersistenceManager().createUser("user1");
        User user2 = ids.getPersistenceManager().createUser("user2");
        User user3 = ids.getPersistenceManager().createUser("user3");
        User user4 = ids.getPersistenceManager().createUser("user4");
        User testUser1 = ids.getPersistenceManager().createUser("testUser1");
        User testUser2 = ids.getPersistenceManager().createUser("testUser2");
        User testUser3 = ids.getPersistenceManager().createUser("testUser3");
        User testUser4 = ids.getPersistenceManager().createUser("testUser4");
        Group group1 = ids.getPersistenceManager().createGroup("group1", this.ORGANIZATION);
        Group group2 = ids.getPersistenceManager().createGroup("group2", this.ORGANIZATION_UNIT);
        Group group3 = ids.getPersistenceManager().createGroup("group3", this.ORGANIZATION_UNIT);
        Group group4 = ids.getPersistenceManager().createGroup("group4", this.DEPARTMENT);
        Group group5 = ids.getPersistenceManager().createGroup("group5", this.DEPARTMENT);
        ids.getRelationshipManager().associateUser(group1, user1);
        ids.getRelationshipManager().associateUser(group1, user2);
        RoleType rt1 = ids.getRoleManager().createRoleType("rt1");
        RoleType rt2 = ids.getRoleManager().createRoleType("rt2");
        RoleType rt3 = ids.getRoleManager().createRoleType("rt3");
        RoleType rt4 = ids.getRoleManager().createRoleType("rt4");
        Role role1 = ids.getRoleManager().createRole(rt1, user1, group1);
        Role role2 = ids.getRoleManager().createRole(rt1, user1, group2);
        Role role3 = ids.getRoleManager().createRole("rt2", user1.getKey(), group1.getKey());
        UserQueryBuilder qb = ids.createUserQueryBuilder();
        qb.withUserId("user1");
        UserQuery q = qb.createQuery();
        UserQueryTest.assertEquals((int)1, (int)ids.execute(q).size());
        UserQueryTest.assertEquals((int)1, (int)ids.list(q).size());
        UserQueryTest.assertEquals((String)"user1", (String)ids.uniqueResult(q).getKey());
        qb.reset();
        qb.addAssociatedGroup(group2);
        UserQueryTest.assertEquals((int)0, (int)ids.execute(qb.createQuery()).size());
        qb.reset();
        qb.addAssociatedGroup(group1);
        UserQueryTest.assertEquals((int)2, (int)ids.execute(qb.createQuery()).size());
        qb.reset();
        qb.addAssociatedGroup(group1);
        qb.withUserId(user1.getKey());
        UserQueryTest.assertEquals((int)1, (int)ids.execute(qb.createQuery()).size());
        qb.reset();
        qb.addAssociatedGroup(group2);
        qb.withUserId(user1.getKey());
        UserQueryTest.assertEquals((int)0, (int)ids.execute(qb.createQuery()).size());
        qb.reset();
        qb.addAssociatedGroup(group1);
        qb.addGroupConnectedWithRole(group2);
        UserQueryTest.assertEquals((int)1, (int)ids.execute(qb.createQuery()).size());
        UserQueryTest.assertEquals((Object)user1, (Object)ids.uniqueResult(qb.createQuery()));
        qb.reset();
        qb.addRelatedGroup(group1);
        UserQueryTest.assertEquals((int)2, (int)ids.execute(qb.createQuery()).size());
        qb.reset();
        qb.addRelatedGroup(group2);
        qb.addAssociatedGroup(group1);
        UserQueryTest.assertEquals((int)1, (int)ids.execute(qb.createQuery()).size());
        UserQueryTest.assertEquals((Object)user1, (Object)ids.uniqueResult(qb.createQuery()));
        qb.reset();
        UserQueryTest.assertEquals((int)8, (int)ids.execute(qb.createQuery()).size());
        qb.reset();
        UserQueryTest.assertEquals((int)8, (int)ids.execute(qb.createQuery()).size());
        qb.reset();
        qb.sort(SortOrder.ASCENDING);
        List results = ids.list(qb.createQuery());
        UserQueryTest.assertEquals((Object)testUser1, results.get(0));
        UserQueryTest.assertEquals((Object)user4, results.get(7));
        qb.reset();
        qb.sort(SortOrder.DESCENDING);
        results = ids.list(qb.createQuery());
        UserQueryTest.assertEquals((Object)testUser1, results.get(7));
        UserQueryTest.assertEquals((Object)user4, results.get(0));
        qb.reset();
        qb.sort(SortOrder.DESCENDING);
        qb.idFilter("test*");
        results = ids.list(qb.createQuery());
        UserQueryTest.assertEquals((int)4, (int)results.size());
        UserQueryTest.assertEquals((Object)testUser1, results.get(3));
        UserQueryTest.assertEquals((Object)testUser4, results.get(0));
        qb.reset();
        qb.sort(SortOrder.ASCENDING);
        qb.idFilter("user*");
        qb.page(1, 2);
        results = ids.list(qb.createQuery());
        UserQueryTest.assertEquals((int)2, (int)results.size());
        UserQueryTest.assertEquals((Object)user2, results.get(0));
        UserQueryTest.assertEquals((Object)user3, results.get(1));
        ids.getAttributesManager().addAttribute((IdentityType)user4, "lastName", (Object)"gtn");
        ids.getAttributesManager().addAttribute((IdentityType)user3, "email", (Object)"user3@localhost");
        qb.reset();
        qb.attributeValuesFilter("lastName", new String[]{"*gtn*"});
        results = ids.list(qb.createQuery());
        UserQueryTest.assertEquals((int)1, (int)results.size());
        UserQueryTest.assertEquals((Object)user4, results.get(0));
        qb.reset();
        qb.attributeValuesFilter("email", new String[]{"*user3*"});
        results = ids.list(qb.createQuery());
        UserQueryTest.assertEquals((int)1, (int)results.size());
        UserQueryTest.assertEquals((Object)user3, results.get(0));
        this.ctx.commit();
    }
}

