/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.test.support.opends;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.opends.server.types.DirectoryEnvironmentConfig;
import org.opends.server.types.InitializationException;
import org.opends.server.util.EmbeddedUtils;

public class OpenDSService {
    private String serverRoot = "";

    public OpenDSService(String serverRoot) {
        this.serverRoot = serverRoot;
    }

    public DirectoryEnvironmentConfig getConfig() {
        DirectoryEnvironmentConfig config = new DirectoryEnvironmentConfig();
        try {
            File root;
            if (this.getServerRoot() != null) {
                root = new File(this.getServerRoot());
            } else {
                URL rootURL = Thread.currentThread().getContextClassLoader().getResource("opends/config/config.ldif");
                if (rootURL == null) {
                    throw new IllegalStateException("opends root doesn't exist");
                }
                try {
                    root = new File(rootURL.toURI());
                }
                catch (URISyntaxException e) {
                    root = new File(rootURL.getPath());
                }
                if (root != null) {
                    root = root.getParentFile().getParentFile();
                }
            }
            if (root == null || !root.exists()) {
                throw new IllegalStateException("opends root doesn't exist: " + this.getServerRoot());
            }
            if (!root.isDirectory()) {
                throw new IllegalStateException("opends root is not a directory: " + this.getServerRoot());
            }
            config.setServerRoot(root);
            config.setForceDaemonThreads(true);
        }
        catch (InitializationException e) {
            e.printStackTrace();
        }
        return config;
    }

    public void start() {
        if (!EmbeddedUtils.isRunning()) {
            try {
                EmbeddedUtils.startServer((DirectoryEnvironmentConfig)this.getConfig());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        if (EmbeddedUtils.isRunning()) {
            EmbeddedUtils.stopServer((String)this.getClass().getName(), null);
        }
    }

    public String getServerRoot() {
        return this.serverRoot;
    }

    public void setServerRoot(String serverRoot) {
        this.serverRoot = serverRoot;
    }
}

