/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.common.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.util.SecurityActions;
import org.picketlink.common.util.XMLSignatureUtil;

public class ProvidersUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static synchronized void ensure() {
        AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                ProvidersUtil.addXMLDSigRI();
                ProvidersUtil.addJceProvider("BC", "org.bouncycastle.jce.provider.BouncyCastleProvider");
                return true;
            }
        });
    }

    private static void addXMLDSigRI() {
        try {
            Class<?> clazz = SecurityActions.loadClass(XMLSignatureUtil.class, "org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI");
            if (clazz == null) {
                throw logger.classNotLoadedError("org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI");
            }
            ProvidersUtil.addJceProvider("ApacheXMLDSig", (Provider)clazz.newInstance());
        }
        finally {
            return;
        }
    }

    private static String addJceProvider(String name, Provider provider) {
        Provider currentProvider = Security.getProvider(name);
        if (currentProvider == null) {
            try {
                int ret = 0;
                Provider[] provs = Security.getProviders();
                for (int i = 0; i < provs.length; ++i) {
                    if (!"SUN".equals(provs[i].getName()) && !"IBMJCE".equals(provs[i].getName())) continue;
                    ret = Security.insertProviderAt(provider, i + 2);
                    break;
                }
                if (ret == 0) {
                    ret = Security.insertProviderAt(provider, 2);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("The provider " + provider.getName() + " - " + provider.getVersion() + " was added at position: " + ret);
                }
                return provider.getName();
            }
            catch (Throwable t) {
                if (logger.isDebugEnabled()) {
                    logger.jceProviderCouldNotBeLoaded(name, t);
                }
                return null;
            }
        }
        return currentProvider.getName();
    }

    private static String addJceProvider(String name, String className) {
        Provider currentProvider = Security.getProvider(name);
        if (currentProvider == null) {
            try {
                Class<Provider> clazz = Class.forName(className).asSubclass(Provider.class);
                Provider provider = clazz.newInstance();
                return ProvidersUtil.addJceProvider(name, provider);
            }
            catch (Throwable t) {
                if (logger.isDebugEnabled()) {
                    logger.jceProviderCouldNotBeLoaded(name, t);
                }
                return null;
            }
        }
        return currentProvider.getName();
    }
}

