/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.picketlink.identity.federation.saml.v1.assertion;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * <complexType name="AudienceRestrictionConditionType"> <complexContent> <extension base="saml:ConditionAbstractType">
 * <sequence> <element ref="saml:Audience" maxOccurs="unbounded"/> </sequence>
 *
 * </extension> </complexContent> </complexType>
 *
 * @author Anil.Saldhana@redhat.com
 * @since Jun 22, 2011
 */
public class SAML11AudienceRestrictionCondition extends SAML11ConditionAbstractType {
    private static final long serialVersionUID = 1L;

    protected List<URI> audience = new ArrayList<URI>();

    public void add(URI advice) {
        this.audience.add(advice);
    }

    public void addAll(List<URI> advice) {
        this.audience.addAll(advice);
    }

    public boolean remove(URI advice) {
        return this.audience.remove(advice);
    }

    public List<URI> get() {
        return Collections.unmodifiableList(audience);
    }
}