/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.pdp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.PrivilegedActionException;
import javax.annotation.Resource;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceProvider;
import org.jboss.security.xacml.core.JBossPDP;
import org.jboss.security.xacml.interfaces.PolicyDecisionPoint;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.common.util.SystemPropertiesUtil;
import org.picketlink.identity.federation.core.pdp.SecurityActions;
import org.picketlink.identity.federation.core.saml.v2.util.SOAPSAMLXACMLUtil;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLResponseWriter;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.XACMLAuthzDecisionQueryType;
import org.w3c.dom.Document;

@WebServiceProvider(serviceName="SOAPSAMLXACMLPDP", portName="SOAPSAMLXACMLPort", targetNamespace="urn:picketlink:identity-federation:pdp", wsdlLocation="WEB-INF/wsdl/SOAPSAMLXACMLPDP.wsdl")
public class SOAPSAMLXACMLPDP
implements Provider<Source> {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    @Resource
    protected WebServiceContext context;
    protected String policyConfigFileName = "policyConfig.xml";
    protected PolicyDecisionPoint pdp;
    protected String issuer = "PicketLinkPDP";

    public SOAPSAMLXACMLPDP() {
        try {
            this.pdp = this.getPDP();
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
    }

    public Source invoke(Source request) {
        try {
            Document doc = (Document)DocumentUtil.getNodeFromSource((Source)request);
            if (logger.isTraceEnabled()) {
                logger.trace("XACML Received Message: " + DocumentUtil.asString((Document)doc));
            }
            XACMLAuthzDecisionQueryType xacmlQuery = SOAPSAMLXACMLUtil.getXACMLQueryType(doc);
            ResponseType samlResponseType = SOAPSAMLXACMLUtil.handleXACMLQuery(this.pdp, this.issuer, xacmlQuery);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLStreamWriter xmlStreamWriter = StaxUtil.getXMLStreamWriter((OutputStream)baos);
            SAMLResponseWriter samlResponseWriter = new SAMLResponseWriter(xmlStreamWriter);
            samlResponseWriter.write(samlResponseType);
            Document responseDocument = DocumentUtil.getDocument((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            return new DOMSource(responseDocument.getDocumentElement());
        }
        catch (Exception e) {
            throw logger.xacmlPDPMessageProcessingError((Throwable)e);
        }
    }

    private PolicyDecisionPoint getPDP() throws PrivilegedActionException {
        InputStream is;
        SystemPropertiesUtil.ensure();
        URL url = SecurityActions.loadResource(this.getClass(), this.policyConfigFileName);
        if (url == null) {
            throw logger.fileNotLocated(this.policyConfigFileName);
        }
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException((Throwable)logger.resourceNotFound(url.getPath()));
        }
        return new JBossPDP(is);
    }
}

