/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.writers;

import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.security.xacml.core.model.context.RequestType;
import org.jboss.security.xacml.core.model.context.ResponseType;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.identity.federation.core.saml.v2.util.SAMLXACMLUtil;
import org.picketlink.identity.federation.core.saml.v2.writers.BaseWriter;
import org.picketlink.identity.federation.saml.v2.assertion.AdviceType;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.AudienceRestrictionType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextClassRefType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextDeclRefType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextDeclType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionsType;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedElementType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.federation.saml.v2.assertion.URIType;
import org.picketlink.identity.federation.saml.v2.profiles.xacml.assertion.XACMLAuthzDecisionStatementType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAssertionWriter
extends BaseWriter {
    public SAMLAssertionWriter(XMLStreamWriter writer) {
        super(writer);
    }

    public void write(AssertionType assertion) throws ProcessingException {
        AdviceType advice;
        ConditionsType conditions;
        SubjectType subject;
        Element sig;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.ASSERTION.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeDefaultNameSpace((XMLStreamWriter)this.writer, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ID.get(), (String)assertion.getID());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.VERSION.get(), (String)assertion.getVersion());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ISSUE_INSTANT.get(), (String)assertion.getIssueInstant().toString());
        NameIDType issuer = assertion.getIssuer();
        if (issuer != null) {
            this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        }
        if ((sig = assertion.getSignature()) != null) {
            StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)sig);
        }
        if ((subject = assertion.getSubject()) != null) {
            this.write(subject);
        }
        if ((conditions = assertion.getConditions()) != null) {
            List<ConditionAbstractType> typeOfConditions;
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.CONDITIONS.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
            if (conditions.getNotBefore() != null) {
                StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.NOT_BEFORE.get(), (String)conditions.getNotBefore().toString());
            }
            if (conditions.getNotOnOrAfter() != null) {
                StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.NOT_ON_OR_AFTER.get(), (String)conditions.getNotOnOrAfter().toString());
            }
            if ((typeOfConditions = conditions.getConditions()) != null) {
                for (ConditionAbstractType typeCondition : typeOfConditions) {
                    if (!(typeCondition instanceof AudienceRestrictionType)) continue;
                    AudienceRestrictionType art = (AudienceRestrictionType)typeCondition;
                    StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.AUDIENCE_RESTRICTION.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
                    List<URI> audiences = art.getAudience();
                    if (audiences != null) {
                        for (URI audience : audiences) {
                            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.AUDIENCE.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
                            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)audience.toString());
                            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
                        }
                    }
                    StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
                }
            }
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if ((advice = assertion.getAdvice()) != null) {
            throw logger.notImplementedYet("Advice");
        }
        Set<StatementAbstractType> statements = assertion.getStatements();
        if (statements != null) {
            for (StatementAbstractType statement : statements) {
                if (statement instanceof AuthnStatementType) {
                    this.write((AuthnStatementType)statement);
                    continue;
                }
                if (statement instanceof AttributeStatementType) {
                    this.write((AttributeStatementType)statement);
                    continue;
                }
                if (statement instanceof XACMLAuthzDecisionStatementType) {
                    this.write((XACMLAuthzDecisionStatementType)statement);
                    continue;
                }
                throw logger.writerUnknownTypeError(statement.getClass().getName());
            }
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(StatementAbstractType statement) throws ProcessingException {
        throw logger.notImplementedYet("NYI");
    }

    public void write(AttributeStatementType statement) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.ATTRIBUTE_STATEMENT.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        List<AttributeStatementType.ASTChoiceType> attributes = statement.getAttributes();
        if (attributes != null) {
            for (AttributeStatementType.ASTChoiceType attr : attributes) {
                EncryptedElementType encType;
                AttributeType attributeType = attr.getAttribute();
                if (attributeType != null) {
                    this.write(attributeType);
                }
                if ((encType = attr.getEncryptedAssertion()) == null) continue;
                throw logger.notImplementedYet("EncryptedElementType");
            }
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(AuthnStatementType authnStatement) throws ProcessingException {
        AuthnContextType authnContext;
        String sessionIndex;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.AUTHN_STATEMENT.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        XMLGregorianCalendar authnInstant = authnStatement.getAuthnInstant();
        if (authnInstant != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.AUTHN_INSTANT.get(), (String)authnInstant.toString());
        }
        if ((sessionIndex = authnStatement.getSessionIndex()) != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.SESSION_INDEX.get(), (String)sessionIndex);
        }
        if ((authnContext = authnStatement.getAuthnContext()) != null) {
            this.write(authnContext);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(XACMLAuthzDecisionStatementType xacmlStat) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.STATEMENT.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)XACML_SAML_PREFIX, (String)JBossSAMLURIConstants.XACML_SAML_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)XACML_SAML_PROTO_PREFIX, (String)JBossSAMLURIConstants.XACML_SAML_PROTO_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)XSI_PREFIX, (String)JBossSAMLURIConstants.XSI_NSURI.get());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (QName)new QName(JBossSAMLURIConstants.XSI_NSURI.get(), JBossSAMLConstants.TYPE.get(), XSI_PREFIX), (String)"xacml-saml:XACMLAuthzDecisionStatementType");
        ResponseType responseType = xacmlStat.getResponse();
        if (responseType == null) {
            throw logger.writerNullValueError("XACML response");
        }
        Document doc = SAMLXACMLUtil.getXACMLResponse(responseType);
        StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)doc.getDocumentElement());
        RequestType requestType = xacmlStat.getRequest();
        if (requestType != null) {
            StaxUtil.writeDOMNode((XMLStreamWriter)this.writer, (Node)SAMLXACMLUtil.getXACMLRequest(requestType).getDocumentElement());
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(AuthnContextType authContext) throws ProcessingException {
        Set<URI> authAuthorities;
        Set<URIType> uriTypes;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.AUTHN_CONTEXT.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        AuthnContextType.AuthnContextTypeSequence sequence = authContext.getSequence();
        if (sequence != null) {
            AuthnContextClassRefType authnContextClassRefType = sequence.getClassRef();
            if (authnContextClassRefType != null) {
                StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.AUTHN_CONTEXT_CLASS_REF.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
                StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)authnContextClassRefType.getValue().toASCIIString());
                StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
            }
            if ((uriTypes = sequence.getURIType()) != null) {
                for (URIType uriType : uriTypes) {
                    if (uriType instanceof AuthnContextDeclType) {
                        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
                        StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)uriType.getValue().toASCIIString());
                        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
                    }
                    if (!(uriType instanceof AuthnContextDeclRefType)) continue;
                    StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION_REF.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
                    StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)uriType.getValue().toASCIIString());
                    StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
                }
            }
        }
        if ((authAuthorities = authContext.getAuthenticatingAuthority()) != null) {
            for (URI aa : authAuthorities) {
                StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.AUTHENTICATING_AUTHORITY.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
                StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)aa.toASCIIString());
                StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
            }
        }
        uriTypes = authContext.getURIType();
        for (URIType uriType : uriTypes) {
            if (uriType instanceof AuthnContextClassRefType) {
                StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.AUTHN_CONTEXT_CLASS_REF.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
                StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)uriType.getValue().toString());
                StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
                continue;
            }
            if (uriType instanceof AuthnContextDeclRefType) {
                StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION_REF.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
                StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)uriType.getValue().toString());
                StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
                continue;
            }
            if (!(uriType instanceof AuthnContextDeclType)) continue;
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)uriType.getValue().toString());
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }
}

