/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.model;

import org.picketlink.idm.model.AbstractIdentityType;
import org.picketlink.idm.model.Group;

public class SimpleGroup
extends AbstractIdentityType
implements Group {
    private static final long serialVersionUID = -3553832607918448916L;
    private String name;
    private Group parentGroup;
    private String path;

    public SimpleGroup() {
    }

    public SimpleGroup(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Error creating SimpleGroup - name cannot be null or empty");
        }
        this.name = name;
        this.path = this.getPath(this);
    }

    public SimpleGroup(String name, Group parentGroup) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Error creating SimpleGroup - name cannot be null or empty");
        }
        this.name = name;
        this.parentGroup = parentGroup;
        this.path = this.getPath(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public String getPath(Group group) {
        String name = "/" + group.getName();
        if (group.getParentGroup() != null) {
            name = this.getPath(group.getParentGroup()) + name;
        }
        return name;
    }

    @Override
    public Group getParentGroup() {
        return this.parentGroup;
    }

    @Override
    public void setParentGroup(Group group) {
        this.parentGroup = group;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        return other.getId() != null && this.getId() != null && other.getId().equals(this.getId());
    }
}

