
package org.picketlink.idm;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import javax.annotation.Generated;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Token;
import org.picketlink.idm.credential.encoder.PasswordEncoder;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.RelationshipQuery;


/**
 * Warning this class consists of generated code.
 * 
 */
@Generated(value = "org.jboss.logging.processor.model.MessageBundleImplementor", date = "2015-10-05T18:47:49+0200")
public class IDMInternalMessages_$bundle
    implements Serializable, IDMInternalMessages, IDMMessages
{

    private final static long serialVersionUID = 1L;
    private final static String projectCode = "PLIDM";
    public final static IDMInternalMessages_$bundle INSTANCE = new IDMInternalMessages_$bundle();
    private final static String credentialUnknownUserNameProperty = "Account type [%s] does not provide a property annotated with @StereotypeProperty(IDENTITY_USER_NAME). Without this the account can not be retrieved from the store based on the user name.";
    private final static String partitionCouldNotCreateIdentityManager = "Could not create contextual IdentityManager for Partition [%s]. Partition not found or it was null.";
    private final static String partitionUpdateFailed = "Could not update partition [%s].";
    private final static String credentialValidationFailed = "Credential validation failed [%s].";
    private final static String credentialMultipleAccountsFoundForType = "Multiple Account objects found with same login name [%s] for account type [%s].";
    private final static String configNoConfigurationProvided = "You must provide at least one configuration.";
    private final static String notImplemented = "Not implemented.";
    private final static String configInvalidConfiguration = "Invalid configuration [%s].";
    private final static String configJpaStoreMappedPropertyNotFound = "Mapped attribute [%s.%s] does not map to any field for type [%s].";
    private final static String configNoIdentityConfigurationProvided = "At least one IdentityConfiguration must be provided";
    private final static String configJpaStoreMappedNoAttributeMappingFound = "Attribute support is enabled (ad-hoc). But no entity was found with the necessary mapping to store attributes.";
    private final static String partitionAlreadyExistsWithName = "A Partition [%s] with name [%s] already exists.";
    private final static String unmarshallingError = "Error unmarshalling object.";
    private final static String partitionCouldNotCreatePermissionManager = "Could not create contextual PermissionManager for Partition [%s].";
    private final static String credentialUnsupportedType = "Credentials class [%s] not supported by this handler [%s].";
    private final static String partitionNoConfigurationFound = "No configuration found with the given name [%s].";
    private final static String credentialNoAccountTypeProvided = "No Account type provided. You must provide at least one Account type in order to support credential management.";
    private final static String partitionUnsupportedType = "Partition [%s] does not support type [%s].";
    private final static String configJpaStoreNoEntityClassesProvided = "Error initializing JpaIdentityStore - no entity classes configured.";
    private final static String configStoreMultiplePartitionConfigExists = "Only a single identity store config can support partitions. Found [%s] and [%s].";
    private final static String credentialUpdateFailed = "Credential update failed for account [%s] and type [%s].";
    private final static String queryRelationshipFailed = "Could not query Relationship using query [%s].";
    private final static String permissionRevokeFailed = "Could not revoke permission granted to [%s] for resource [%s], operation [%s].";
    private final static String credentialRetrievalFailed = "Credentials could not be retrieved for account [%s] and storage [%s].";
    private final static String partitionNotFoundWithName = "Partition [%s] not found with the given name [%s].";
    private final static String configUnknownStoreForConfiguration = "Unknown IdentityStore class for configuration [%s].";
    private final static String partitionManagementNoSupported = "Partition management is not supported by the current configuration.";
    private final static String attributedTypeUnsupportedOperation = "No identity store configuration found for requested type operation [%s.%s].";
    private final static String attributedTypeRemoveFailed = "Could not remove AttributedType [%s].";
    private final static String identityTypeAlreadyExists = "IdentityType [%s] already exists with the given identifier [%s] for the given Partition [%s].";
    private final static String attributedTypeNotFoundWithId = "Could not find AttributedType [%s] with the given identifier [%s] for Partition [%s]";
    private final static String credentialNoConsumerForToken = "There is no Token.Consumer that supports this token [%s].";
    private final static String permissionsGrantFailed = "Could not grant Permissions [%s].";
    private final static String partitionWithNoConfigurationName = "No configuration name defined for partition [%s].";
    private final static String storeNotFound = "No store found with type [%s].";
    private final static String storeJpaCouldNotGetEntityManagerFromStoreContext = "Error while trying to determine EntityManager - context parameter not set.";
    private final static String partitionAddFailed = "Could not create partition [%s] using configuration [%s].";
    private final static String instantiationError = "Error creating instance for type [%s].";
    private final static String partitionManagerInitializationFailed = "Could not initialize Partition Manager [%s].";
    private final static String configJpaStoreRequiredMappingAnnotationForAttributedType = "Invalid mapping for type [%s]. No entity found with a field annotated with %s.";
    private final static String configBuildMultipleConfigurationExists = "You have provided more than one configuration. Use the buildAll method instead.";
    private final static String partitionFoundWithSameNameAndType = "More than one partitions have been found with the given name [%s] and type [%s].";
    private final static String queryUnsupportedParameterValue = "Unsupported value for Query Parameter [%s]. Value: %s.";
    private final static String configMultipleConfigurationsFoundWithCredentialSupport = "Multiple configuration with credential support.";
    private final static String credentialInvalidEncodingAlgorithm = "No such algorithm [%s] for encoding passwords. Using PasswordEncoder [%s].";
    private final static String configCouldNotCreateStore = "Error while creating IdentityStore [%s] instance for configuration [%s].";
    private final static String configStoreDuplicatedSupportedType = "Duplicated supported types [%s] found for identity store configuration. Check your identity store configuration for duplicated types, considering their hierarchy.";
    private final static String attributedTypeAddFailed = "Could not add AttributedType [%s].";
    private final static String credentialNoStoreForCredentials = "No IdentityStore found for credential class [%s]";
    private final static String configCouldNotCreateConfiguration = "Could not create configuration.";
    private final static String configStoreNoIdentityStoreConfigProvided = "You must configure at least one identity store.";
    private final static String configJpaStoreNoPermissionEntityClassProvided = "No @Entity class found to store permissions. Check if you have an @Entity class annotated with @PermissionManaged.";
    private final static String queryIdentityTypeFailed = "Could not query IdentityType using query [%s].";
    private final static String credentialDigestInvalidRealm = "Invalid Realm or it was not provided.";
    private final static String credentialInvalidPassword = "Invalid Password or it was not provided.";
    private final static String configJpaStoreMappedNoCredentialStorageMappingFound = "Credential support is enabled. But no entity was found with the necessary mapping to store any CredentialStorage.";
    private final static String permissionGrantFailed = "Could not grant permission to [%s] for resource [%s], operation [%s].";
    private final static String configJpaStoreRequiredMappingAnnotation = "Entity [%s] must have a field annotated with %s.";
    private final static String storeUnexpectedType = "Unexpected IdentityStore type. Expected [%s]. Actual [%s].";
    private final static String unexpectedType = "Unexpected type [%s].";
    private final static String marshallingError = "Error marshalling object.";
    private final static String credentialInvalidAccountType = "The IdentityType returned is not an Account: [%s]";
    private final static String storeLdapCouldNotCreateContext = "Could not create context.";
    private final static String partitionGetFailed = "Could not load partition for type [%s] and name [%s].";
    private final static String partitionRemoveFailed = "Could not remove partition [%s].";
    private final static String credentialHandlerNotFoundForCredentialType = "No suitable CredentialHandler available for validating Credentials of type [%s].";
    private final static String storeLdapCouldNotLoadAttributesForEntry = "Could not load attributes for entry with ID [%s] using baseDN [%s].";
    private final static String credentialCouldNotEncodePassword = "Could not encode password.";
    private final static String partitionReferencesInvalidConfiguration = "Partition [%s] references an invalid or non-existent configuration.";
    private final static String storeLdapEntryNotFoundWithId = "Entry not found with ID [%s] using baseDN [%s].";
    private final static String permissionUnsupportedOperation = "No PermissionStore configuration found for requested permission operation.";
    private final static String configMultipleConfigurationsFoundWithSameName = "Multiple configuration with the same name [%s].";
    private final static String permissionRevokeAllFailed = "Failed to revoke all permissions for resource [%s].";
    private final static String attributedUndefinedPartition = "Undefined partition for identity type [%s].";
    private final static String nullArgument = "Null argument: [%s].";
    private final static String permissionsRevokeFailed = "Could not revoke Permissions [%s].";
    private final static String attributedTypeUpdateFailed = "Could not update AttributedType [%s].";
    private final static String attributedTypeAmbiguosFoundWithId = "Ambiguous AttributedType found with identifier [%s].";

    protected IDMInternalMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    public final org.picketlink.idm.IdentityManagementException credentialUnknownUserNameProperty(final Class arg0) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000208: ")+ credentialUnknownUserNameProperty$str()), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialUnknownUserNameProperty$str() {
        return credentialUnknownUserNameProperty;
    }

    public final org.picketlink.idm.IdentityManagementException partitionCouldNotCreateIdentityManager(final org.picketlink.idm.model.Partition partition, final Throwable t) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000405: ")+ partitionCouldNotCreateIdentityManager$str()), partition), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionCouldNotCreateIdentityManager$str() {
        return partitionCouldNotCreateIdentityManager;
    }

    public final org.picketlink.idm.IdentityManagementException partitionUpdateFailed(final org.picketlink.idm.model.Partition partition, final Exception e) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000402: ")+ partitionUpdateFailed$str()), partition), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionUpdateFailed$str() {
        return partitionUpdateFailed;
    }

    public final org.picketlink.idm.IdentityManagementException credentialValidationFailed(final Credentials arg0, final Throwable arg1) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000200: ")+ credentialValidationFailed$str()), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialValidationFailed$str() {
        return credentialValidationFailed;
    }

    public final org.picketlink.idm.IdentityManagementException credentialMultipleAccountsFoundForType(final String arg0, final Class arg1) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000206: ")+ credentialMultipleAccountsFoundForType$str()), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialMultipleAccountsFoundForType$str() {
        return credentialMultipleAccountsFoundForType;
    }

    public final org.picketlink.idm.config.SecurityConfigurationException configNoConfigurationProvided() {
        org.picketlink.idm.config.SecurityConfigurationException result = new org.picketlink.idm.config.SecurityConfigurationException(String.format(((projectCode +"000702: ")+ configNoConfigurationProvided$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configNoConfigurationProvided$str() {
        return configNoConfigurationProvided;
    }

    public final org.picketlink.common.exceptions.NotImplementedException notImplemented() {
        org.picketlink.common.exceptions.NotImplementedException result = new org.picketlink.common.exceptions.NotImplementedException(String.format(((projectCode +"000007: ")+ notImplemented$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notImplemented$str() {
        return notImplemented;
    }

    public final org.picketlink.idm.config.SecurityConfigurationException configInvalidConfiguration(final String arg0, final Throwable arg1) {
        org.picketlink.idm.config.SecurityConfigurationException result = new org.picketlink.idm.config.SecurityConfigurationException(String.format(((projectCode +"000701: ")+ configInvalidConfiguration$str()), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configInvalidConfiguration$str() {
        return configInvalidConfiguration;
    }

    public final org.picketlink.idm.config.SecurityConfigurationException configJpaStoreMappedPropertyNotFound(final Class arg0, final String arg1, final Class arg2) {
        org.picketlink.idm.config.SecurityConfigurationException result = new org.picketlink.idm.config.SecurityConfigurationException(String.format(configJpaStoreMappedPropertyNotFound$str(), arg0, arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configJpaStoreMappedPropertyNotFound$str() {
        return configJpaStoreMappedPropertyNotFound;
    }

    public final org.picketlink.idm.config.SecurityConfigurationException configNoIdentityConfigurationProvided() {
        org.picketlink.idm.config.SecurityConfigurationException result = new org.picketlink.idm.config.SecurityConfigurationException(String.format(((projectCode +"000704: ")+ configNoIdentityConfigurationProvided$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configNoIdentityConfigurationProvided$str() {
        return configNoIdentityConfigurationProvided;
    }

    public final org.picketlink.idm.config.SecurityConfigurationException configJpaStoreMappedNoAttributeMappingFound() {
        org.picketlink.idm.config.SecurityConfigurationException result = new org.picketlink.idm.config.SecurityConfigurationException(String.format(configJpaStoreMappedNoAttributeMappingFound$str()));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configJpaStoreMappedNoAttributeMappingFound$str() {
        return configJpaStoreMappedNoAttributeMappingFound;
    }

    public final org.picketlink.idm.IdentityManagementException partitionAlreadyExistsWithName(final Class type, final String name) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(partitionAlreadyExistsWithName$str(), type, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionAlreadyExistsWithName$str() {
        return partitionAlreadyExistsWithName;
    }

    public final org.picketlink.idm.IdentityManagementException unmarshallingError(final Throwable arg0) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000003: ")+ unmarshallingError$str())), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unmarshallingError$str() {
        return unmarshallingError;
    }

    public final org.picketlink.idm.IdentityManagementException partitionCouldNotCreatePermissionManager(final org.picketlink.idm.model.Partition partition) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000410: ")+ partitionCouldNotCreatePermissionManager$str()), partition));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionCouldNotCreatePermissionManager$str() {
        return partitionCouldNotCreatePermissionManager;
    }

    public final org.picketlink.idm.IdentityManagementException credentialUnsupportedType(final Class arg0, final CredentialHandler arg1) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000203: ")+ credentialUnsupportedType$str()), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialUnsupportedType$str() {
        return credentialUnsupportedType;
    }

    public final org.picketlink.idm.IdentityManagementException partitionNoConfigurationFound(final String name) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000407: ")+ partitionNoConfigurationFound$str()), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionNoConfigurationFound$str() {
        return partitionNoConfigurationFound;
    }

    public final org.picketlink.idm.IdentityManagementException credentialNoAccountTypeProvided() {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000207: ")+ credentialNoAccountTypeProvided$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialNoAccountTypeProvided$str() {
        return credentialNoAccountTypeProvided;
    }

    public final org.picketlink.idm.IdentityManagementException partitionUnsupportedType(final org.picketlink.idm.model.Partition partition, final Class type) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000411: ")+ partitionUnsupportedType$str()), partition, type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionUnsupportedType$str() {
        return partitionUnsupportedType;
    }

    public final org.picketlink.idm.config.SecurityConfigurationException configJpaStoreNoEntityClassesProvided() {
        org.picketlink.idm.config.SecurityConfigurationException result = new org.picketlink.idm.config.SecurityConfigurationException(String.format(configJpaStoreNoEntityClassesProvided$str()));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configJpaStoreNoEntityClassesProvided$str() {
        return configJpaStoreNoEntityClassesProvided;
    }

    public final org.picketlink.idm.config.SecurityConfigurationException configStoreMultiplePartitionConfigExists(final org.picketlink.idm.config.IdentityStoreConfiguration arg0, final org.picketlink.idm.config.IdentityStoreConfiguration arg1) {
        org.picketlink.idm.config.SecurityConfigurationException result = new org.picketlink.idm.config.SecurityConfigurationException(String.format(configStoreMultiplePartitionConfigExists$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configStoreMultiplePartitionConfigExists$str() {
        return configStoreMultiplePartitionConfigExists;
    }

    public final org.picketlink.idm.IdentityManagementException credentialUpdateFailed(final org.picketlink.idm.model.Account arg0, final Object arg1, final Throwable arg2) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000201: ")+ credentialUpdateFailed$str()), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialUpdateFailed$str() {
        return credentialUpdateFailed;
    }

    public final org.picketlink.idm.IdentityManagementException queryRelationshipFailed(final RelationshipQuery query, final Throwable t) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000500: ")+ queryRelationshipFailed$str()), query), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queryRelationshipFailed$str() {
        return queryRelationshipFailed;
    }

    public final org.picketlink.idm.IdentityManagementException permissionRevokeFailed(final org.picketlink.idm.model.IdentityType arg0, final Object arg1, final String arg2, final Throwable arg3) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(permissionRevokeFailed$str(), arg0, arg1, arg2), arg3);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionRevokeFailed$str() {
        return permissionRevokeFailed;
    }

    public final org.picketlink.idm.IdentityManagementException credentialRetrievalFailed(final org.picketlink.idm.model.Account arg0, final Class arg1, final Throwable arg2) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000204: ")+ credentialRetrievalFailed$str()), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialRetrievalFailed$str() {
        return credentialRetrievalFailed;
    }

    public final org.picketlink.idm.IdentityManagementException partitionNotFoundWithName(final Class type, final String name) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000406: ")+ partitionNotFoundWithName$str()), type, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionNotFoundWithName$str() {
        return partitionNotFoundWithName;
    }

    public final org.picketlink.idm.config.SecurityConfigurationException configUnknownStoreForConfiguration(final org.picketlink.idm.config.IdentityStoreConfiguration arg0) {
        org.picketlink.idm.config.SecurityConfigurationException result = new org.picketlink.idm.config.SecurityConfigurationException(String.format(configUnknownStoreForConfiguration$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configUnknownStoreForConfiguration$str() {
        return configUnknownStoreForConfiguration;
    }

    public final org.picketlink.idm.config.OperationNotSupportedException partitionManagementNoSupported(final Class partitionClass, final org.picketlink.idm.config.IdentityStoreConfiguration.IdentityOperation create) {
        org.picketlink.idm.config.OperationNotSupportedException result = new org.picketlink.idm.config.OperationNotSupportedException(String.format(((projectCode +"000409: ")+ partitionManagementNoSupported$str())), partitionClass, create);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionManagementNoSupported$str() {
        return partitionManagementNoSupported;
    }

    public final org.picketlink.idm.config.OperationNotSupportedException attributedTypeUnsupportedOperation(final Class type, final org.picketlink.idm.config.IdentityStoreConfiguration.IdentityOperation operation, final Class typeToDisplay, final org.picketlink.idm.config.IdentityStoreConfiguration.IdentityOperation operationToDisplay) {
        org.picketlink.idm.config.OperationNotSupportedException result = new org.picketlink.idm.config.OperationNotSupportedException(String.format(((projectCode +"000604: ")+ attributedTypeUnsupportedOperation$str()), typeToDisplay, operationToDisplay), type, operation);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedTypeUnsupportedOperation$str() {
        return attributedTypeUnsupportedOperation;
    }

    public final org.picketlink.idm.IdentityManagementException attributedTypeRemoveFailed(final org.picketlink.idm.model.AttributedType identityType, final Throwable t) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000601: ")+ attributedTypeRemoveFailed$str()), identityType), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedTypeRemoveFailed$str() {
        return attributedTypeRemoveFailed;
    }

    public final org.picketlink.idm.IdentityManagementException identityTypeAlreadyExists(final Class type, final String identifier, final org.picketlink.idm.model.Partition partition) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(identityTypeAlreadyExists$str(), type, identifier, partition));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String identityTypeAlreadyExists$str() {
        return identityTypeAlreadyExists;
    }

    public final org.picketlink.idm.IdentityManagementException attributedTypeNotFoundWithId(final Class type, final String id, final org.picketlink.idm.model.Partition partition) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(attributedTypeNotFoundWithId$str(), type, id, partition));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedTypeNotFoundWithId$str() {
        return attributedTypeNotFoundWithId;
    }

    public final org.picketlink.idm.IdentityManagementException credentialNoConsumerForToken(final Token arg0) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(credentialNoConsumerForToken$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialNoConsumerForToken$str() {
        return credentialNoConsumerForToken;
    }

    public final org.picketlink.idm.IdentityManagementException permissionsGrantFailed(final String arg0, final Throwable arg1) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(permissionsGrantFailed$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionsGrantFailed$str() {
        return permissionsGrantFailed;
    }

    public final org.picketlink.idm.IdentityManagementException partitionWithNoConfigurationName(final org.picketlink.idm.model.Partition partition) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(partitionWithNoConfigurationName$str(), partition));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionWithNoConfigurationName$str() {
        return partitionWithNoConfigurationName;
    }

    public final org.picketlink.idm.IdentityManagementException storeNotFound(final Class partitionStoreClass) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000300: ")+ storeNotFound$str()), partitionStoreClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String storeNotFound$str() {
        return storeNotFound;
    }

    public final org.picketlink.idm.IdentityManagementException storeJpaCouldNotGetEntityManagerFromStoreContext() {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000301: ")+ storeJpaCouldNotGetEntityManagerFromStoreContext$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String storeJpaCouldNotGetEntityManagerFromStoreContext$str() {
        return storeJpaCouldNotGetEntityManagerFromStoreContext;
    }

    public final org.picketlink.idm.IdentityManagementException partitionAddFailed(final org.picketlink.idm.model.Partition partition, final String configurationName, final Exception e) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000401: ")+ partitionAddFailed$str()), partition, configurationName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionAddFailed$str() {
        return partitionAddFailed;
    }

    public final org.picketlink.idm.IdentityManagementException instantiationError(final Class arg0, final Throwable arg1) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000001: ")+ instantiationError$str()), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String instantiationError$str() {
        return instantiationError;
    }

    public final org.picketlink.idm.IdentityManagementException partitionManagerInitializationFailed(final Class arg0, final Throwable arg1) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000006: ")+ partitionManagerInitializationFailed$str()), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionManagerInitializationFailed$str() {
        return partitionManagerInitializationFailed;
    }

    public final org.picketlink.idm.config.SecurityConfigurationException configJpaStoreRequiredMappingAnnotationForAttributedType(final Class arg0, final Class arg1) {
        org.picketlink.idm.config.SecurityConfigurationException result = new org.picketlink.idm.config.SecurityConfigurationException(String.format(configJpaStoreRequiredMappingAnnotationForAttributedType$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configJpaStoreRequiredMappingAnnotationForAttributedType$str() {
        return configJpaStoreRequiredMappingAnnotationForAttributedType;
    }

    public final org.picketlink.idm.config.SecurityConfigurationException configBuildMultipleConfigurationExists() {
        org.picketlink.idm.config.SecurityConfigurationException result = new org.picketlink.idm.config.SecurityConfigurationException(String.format(((projectCode +"000703: ")+ configBuildMultipleConfigurationExists$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configBuildMultipleConfigurationExists$str() {
        return configBuildMultipleConfigurationExists;
    }

    public final org.picketlink.idm.IdentityManagementException partitionFoundWithSameNameAndType(final String name, final Class partitionClass) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000412: ")+ partitionFoundWithSameNameAndType$str()), name, partitionClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionFoundWithSameNameAndType$str() {
        return partitionFoundWithSameNameAndType;
    }

    public final org.picketlink.idm.IdentityManagementException queryUnsupportedParameterValue(final String parameterName, final Object parameterValue) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(queryUnsupportedParameterValue$str(), parameterName, parameterValue));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queryUnsupportedParameterValue$str() {
        return queryUnsupportedParameterValue;
    }

    public final org.picketlink.idm.config.SecurityConfigurationException configMultipleConfigurationsFoundWithCredentialSupport() {
        org.picketlink.idm.config.SecurityConfigurationException result = new org.picketlink.idm.config.SecurityConfigurationException(String.format(((projectCode +"000707: ")+ configMultipleConfigurationsFoundWithCredentialSupport$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configMultipleConfigurationsFoundWithCredentialSupport$str() {
        return configMultipleConfigurationsFoundWithCredentialSupport;
    }

    public final org.picketlink.idm.IdentityManagementException credentialInvalidEncodingAlgorithm(final String arg0, final PasswordEncoder arg1, final Throwable arg2) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(credentialInvalidEncodingAlgorithm$str(), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialInvalidEncodingAlgorithm$str() {
        return credentialInvalidEncodingAlgorithm;
    }

    public final org.picketlink.idm.config.SecurityConfigurationException configCouldNotCreateStore(final Class arg0, final org.picketlink.idm.config.IdentityStoreConfiguration arg1, final Exception arg2) {
        org.picketlink.idm.config.SecurityConfigurationException result = new org.picketlink.idm.config.SecurityConfigurationException(String.format(configCouldNotCreateStore$str(), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configCouldNotCreateStore$str() {
        return configCouldNotCreateStore;
    }

    public final org.picketlink.idm.config.SecurityConfigurationException configStoreDuplicatedSupportedType(final Class arg0) {
        org.picketlink.idm.config.SecurityConfigurationException result = new org.picketlink.idm.config.SecurityConfigurationException(String.format(((projectCode +"000706: ")+ configStoreDuplicatedSupportedType$str()), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configStoreDuplicatedSupportedType$str() {
        return configStoreDuplicatedSupportedType;
    }

    public final org.picketlink.idm.IdentityManagementException attributedTypeAddFailed(final org.picketlink.idm.model.AttributedType identityType, final Throwable t) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000600: ")+ attributedTypeAddFailed$str()), identityType), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedTypeAddFailed$str() {
        return attributedTypeAddFailed;
    }

    public final org.picketlink.idm.IdentityManagementException credentialNoStoreForCredentials(final Class arg0) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000202: ")+ credentialNoStoreForCredentials$str()), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialNoStoreForCredentials$str() {
        return credentialNoStoreForCredentials;
    }

    public final org.picketlink.idm.config.SecurityConfigurationException configCouldNotCreateConfiguration(final Exception arg0) {
        org.picketlink.idm.config.SecurityConfigurationException result = new org.picketlink.idm.config.SecurityConfigurationException(String.format(((projectCode +"000700: ")+ configCouldNotCreateConfiguration$str())), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configCouldNotCreateConfiguration$str() {
        return configCouldNotCreateConfiguration;
    }

    public final org.picketlink.idm.config.SecurityConfigurationException configStoreNoIdentityStoreConfigProvided() {
        org.picketlink.idm.config.SecurityConfigurationException result = new org.picketlink.idm.config.SecurityConfigurationException(String.format(((projectCode +"000705: ")+ configStoreNoIdentityStoreConfigProvided$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configStoreNoIdentityStoreConfigProvided$str() {
        return configStoreNoIdentityStoreConfigProvided;
    }

    public final org.picketlink.idm.IdentityManagementException configJpaStoreNoPermissionEntityClassProvided() {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000801: ")+ configJpaStoreNoPermissionEntityClassProvided$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configJpaStoreNoPermissionEntityClassProvided$str() {
        return configJpaStoreNoPermissionEntityClassProvided;
    }

    public final org.picketlink.idm.IdentityManagementException queryIdentityTypeFailed(final IdentityQuery query, final Throwable t) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000501: ")+ queryIdentityTypeFailed$str()), query), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queryIdentityTypeFailed$str() {
        return queryIdentityTypeFailed;
    }

    public final org.picketlink.idm.IdentityManagementException credentialDigestInvalidRealm() {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(credentialDigestInvalidRealm$str()));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialDigestInvalidRealm$str() {
        return credentialDigestInvalidRealm;
    }

    public final org.picketlink.idm.IdentityManagementException credentialInvalidPassword() {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(credentialInvalidPassword$str()));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialInvalidPassword$str() {
        return credentialInvalidPassword;
    }

    public final org.picketlink.idm.config.SecurityConfigurationException configJpaStoreMappedNoCredentialStorageMappingFound() {
        org.picketlink.idm.config.SecurityConfigurationException result = new org.picketlink.idm.config.SecurityConfigurationException(String.format(configJpaStoreMappedNoCredentialStorageMappingFound$str()));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configJpaStoreMappedNoCredentialStorageMappingFound$str() {
        return configJpaStoreMappedNoCredentialStorageMappingFound;
    }

    public final org.picketlink.idm.IdentityManagementException permissionGrantFailed(final org.picketlink.idm.model.IdentityType arg0, final Object arg1, final String arg2, final Throwable arg3) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(permissionGrantFailed$str(), arg0, arg1, arg2), arg3);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionGrantFailed$str() {
        return permissionGrantFailed;
    }

    public final org.picketlink.idm.config.SecurityConfigurationException configJpaStoreRequiredMappingAnnotation(final Class arg0, final Class arg1) {
        org.picketlink.idm.config.SecurityConfigurationException result = new org.picketlink.idm.config.SecurityConfigurationException(String.format(configJpaStoreRequiredMappingAnnotation$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configJpaStoreRequiredMappingAnnotation$str() {
        return configJpaStoreRequiredMappingAnnotation;
    }

    public final org.picketlink.idm.IdentityManagementException storeUnexpectedType(final Class expectedType, final Class actualType) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(storeUnexpectedType$str(), expectedType, actualType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String storeUnexpectedType$str() {
        return storeUnexpectedType;
    }

    public final org.picketlink.idm.IdentityManagementException unexpectedType(final Class arg0) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000005: ")+ unexpectedType$str()), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedType$str() {
        return unexpectedType;
    }

    public final org.picketlink.idm.IdentityManagementException marshallingError(final Throwable arg0) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000004: ")+ marshallingError$str())), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String marshallingError$str() {
        return marshallingError;
    }

    public final org.picketlink.idm.IdentityManagementException credentialInvalidAccountType(final Class arg0) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000205: ")+ credentialInvalidAccountType$str()), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialInvalidAccountType$str() {
        return credentialInvalidAccountType;
    }

    public final org.picketlink.idm.IdentityManagementException storeLdapCouldNotCreateContext(final Throwable e) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000302: ")+ storeLdapCouldNotCreateContext$str())), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String storeLdapCouldNotCreateContext$str() {
        return storeLdapCouldNotCreateContext;
    }

    public final org.picketlink.idm.IdentityManagementException partitionGetFailed(final Class partitionClass, final String name, final Exception e) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000404: ")+ partitionGetFailed$str()), partitionClass, name), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionGetFailed$str() {
        return partitionGetFailed;
    }

    public final org.picketlink.idm.IdentityManagementException partitionRemoveFailed(final org.picketlink.idm.model.Partition partition, final Exception e) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000403: ")+ partitionRemoveFailed$str()), partition), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionRemoveFailed$str() {
        return partitionRemoveFailed;
    }

    public final org.picketlink.idm.IdentityManagementException credentialHandlerNotFoundForCredentialType(final Class arg0) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(credentialHandlerNotFoundForCredentialType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialHandlerNotFoundForCredentialType$str() {
        return credentialHandlerNotFoundForCredentialType;
    }

    public final org.picketlink.idm.IdentityManagementException storeLdapCouldNotLoadAttributesForEntry(final String entryUUID, final String baseDN) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(storeLdapCouldNotLoadAttributesForEntry$str(), entryUUID, baseDN));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String storeLdapCouldNotLoadAttributesForEntry$str() {
        return storeLdapCouldNotLoadAttributesForEntry;
    }

    public final org.picketlink.idm.IdentityManagementException credentialCouldNotEncodePassword(final UnsupportedEncodingException arg0) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(credentialCouldNotEncodePassword$str()), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialCouldNotEncodePassword$str() {
        return credentialCouldNotEncodePassword;
    }

    public final org.picketlink.idm.IdentityManagementException partitionReferencesInvalidConfiguration(final org.picketlink.idm.model.Partition partition) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000408: ")+ partitionReferencesInvalidConfiguration$str()), partition));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionReferencesInvalidConfiguration$str() {
        return partitionReferencesInvalidConfiguration;
    }

    public final org.picketlink.idm.IdentityManagementException storeLdapEntryNotFoundWithId(final String entryUUID, final String baseDN) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(storeLdapEntryNotFoundWithId$str(), entryUUID, baseDN));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String storeLdapEntryNotFoundWithId$str() {
        return storeLdapEntryNotFoundWithId;
    }

    public final org.picketlink.idm.IdentityManagementException permissionUnsupportedOperation() {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000800: ")+ permissionUnsupportedOperation$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionUnsupportedOperation$str() {
        return permissionUnsupportedOperation;
    }

    public final org.picketlink.idm.config.SecurityConfigurationException configMultipleConfigurationsFoundWithSameName(final String arg0) {
        org.picketlink.idm.config.SecurityConfigurationException result = new org.picketlink.idm.config.SecurityConfigurationException(String.format(configMultipleConfigurationsFoundWithSameName$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configMultipleConfigurationsFoundWithSameName$str() {
        return configMultipleConfigurationsFoundWithSameName;
    }

    public final org.picketlink.idm.IdentityManagementException permissionRevokeAllFailed(final Object arg0, final Throwable arg1) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(permissionRevokeAllFailed$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionRevokeAllFailed$str() {
        return permissionRevokeAllFailed;
    }

    public final org.picketlink.idm.IdentityManagementException attributedUndefinedPartition(final org.picketlink.idm.model.IdentityType identityType) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000605: ")+ attributedUndefinedPartition$str()), identityType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedUndefinedPartition$str() {
        return attributedUndefinedPartition;
    }

    public final org.picketlink.idm.IdentityManagementException nullArgument(final String arg0) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000002: ")+ nullArgument$str()), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullArgument$str() {
        return nullArgument;
    }

    public final org.picketlink.idm.IdentityManagementException permissionsRevokeFailed(final String arg0, final Throwable arg1) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(permissionsRevokeFailed$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionsRevokeFailed$str() {
        return permissionsRevokeFailed;
    }

    public final org.picketlink.idm.IdentityManagementException attributedTypeUpdateFailed(final org.picketlink.idm.model.AttributedType identityType, final Throwable t) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000602: ")+ attributedTypeUpdateFailed$str()), identityType), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedTypeUpdateFailed$str() {
        return attributedTypeUpdateFailed;
    }

    public final org.picketlink.idm.IdentityManagementException attributedTypeAmbiguosFoundWithId(final String id) {
        org.picketlink.idm.IdentityManagementException result = new org.picketlink.idm.IdentityManagementException(String.format(((projectCode +"000603: ")+ attributedTypeAmbiguosFoundWithId$str()), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedTypeAmbiguosFoundWithId$str() {
        return attributedTypeAmbiguosFoundWithId;
    }

}
