/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.picketlink.common.logging.LogFactory;
import org.picketlink.idm.IDMLog;
import org.picketlink.idm.model.AttributedType;

@MessageLogger(projectCode="PLIDM")
public interface IDMInternalLog
extends IDMLog {
    public static final IDMInternalLog FILE_STORE_LOGGER = (IDMInternalLog)LogFactory.getLog(IDMInternalLog.class, (String)(IDMInternalLog.class.getPackage().getName() + ".identity.store.file"));
    public static final IDMInternalLog JPA_STORE_LOGGER = (IDMInternalLog)LogFactory.getLog(IDMInternalLog.class, (String)(IDMInternalLog.class.getPackage().getName() + ".identity.store.jpa"));
    public static final IDMInternalLog LDAP_STORE_LOGGER = (IDMInternalLog)LogFactory.getLog(IDMInternalLog.class, (String)(IDMInternalLog.class.getPackage().getName() + ".identity.store.ldap"));
    public static final IDMInternalLog JDBC_STORE_LOGGER = (IDMInternalLog)LogFactory.getLog(IDMInternalLog.class, (String)(IDMInternalLog.class.getPackage().getName() + ".identity.store.jdbc"));

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1100, value="Using working directory [%s].")
    public void fileConfigUsingWorkingDir(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1101, value="Working directory [%s] is marked to be always created. All your existing data will be lost.")
    public void fileConfigAlwaysCreateWorkingDir(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1102, value="Async write enabled. Using thread pool of size %s")
    public void fileAsyncWriteEnabled(int var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1200, value="LDAP Store is configured for Active Directory.")
    public void ldapActiveDirectoryConfiguration();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1201, value="LDAP Store does not support relationship updates [%s].")
    public void ldapRelationshipUpdateNotSupported(AttributedType var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1300, value="No ContextInitializer provided for the JPA Store. The store maybe be unable to retrieve the EntityManager instance to perform operations.")
    public void jpaContextInitializerNotProvided();
}

