/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.TypedPropertyCriteria;
import org.picketlink.common.reflection.Reflections;
import org.picketlink.common.util.Base64;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.IDMInternalLog;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.handler.DigestCredentialHandler;
import org.picketlink.idm.credential.handler.PasswordCredentialHandler;
import org.picketlink.idm.credential.handler.TOTPCredentialHandler;
import org.picketlink.idm.credential.handler.TokenCredentialHandler;
import org.picketlink.idm.credential.handler.X509CertificateCredentialHandler;
import org.picketlink.idm.credential.handler.annotations.CredentialHandlers;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.internal.AbstractAttributeStore;
import org.picketlink.idm.internal.IdentityTypeReference;
import org.picketlink.idm.internal.RelationshipReference;
import org.picketlink.idm.internal.util.IdentityTypeUtil;
import org.picketlink.idm.internal.util.PermissionUtil;
import org.picketlink.idm.jpa.annotations.AttributeClass;
import org.picketlink.idm.jpa.annotations.AttributeName;
import org.picketlink.idm.jpa.annotations.AttributeValue;
import org.picketlink.idm.jpa.annotations.CredentialClass;
import org.picketlink.idm.jpa.annotations.EffectiveDate;
import org.picketlink.idm.jpa.annotations.ExpiryDate;
import org.picketlink.idm.jpa.annotations.Identifier;
import org.picketlink.idm.jpa.annotations.IdentityClass;
import org.picketlink.idm.jpa.annotations.OwnerReference;
import org.picketlink.idm.jpa.annotations.PartitionClass;
import org.picketlink.idm.jpa.annotations.PermissionOperation;
import org.picketlink.idm.jpa.annotations.PermissionResourceClass;
import org.picketlink.idm.jpa.annotations.PermissionResourceIdentifier;
import org.picketlink.idm.jpa.annotations.RelationshipClass;
import org.picketlink.idm.jpa.annotations.RelationshipDescriptor;
import org.picketlink.idm.jpa.annotations.RelationshipMember;
import org.picketlink.idm.jpa.annotations.entity.ConfigurationName;
import org.picketlink.idm.jpa.annotations.entity.IdentityManaged;
import org.picketlink.idm.jpa.annotations.entity.ManagedCredential;
import org.picketlink.idm.jpa.annotations.entity.PermissionManaged;
import org.picketlink.idm.jpa.internal.mappers.EntityMapper;
import org.picketlink.idm.jpa.internal.mappers.EntityMapping;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.permission.IdentityPermission;
import org.picketlink.idm.permission.Permission;
import org.picketlink.idm.permission.acl.spi.PermissionStore;
import org.picketlink.idm.permission.annotations.AllowedOperation;
import org.picketlink.idm.permission.annotations.AllowedOperations;
import org.picketlink.idm.query.AttributeParameter;
import org.picketlink.idm.query.Condition;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.RelationshipQueryParameter;
import org.picketlink.idm.query.Sort;
import org.picketlink.idm.query.internal.BetweenCondition;
import org.picketlink.idm.query.internal.EqualCondition;
import org.picketlink.idm.query.internal.GreaterThanCondition;
import org.picketlink.idm.query.internal.InCondition;
import org.picketlink.idm.query.internal.LessThanCondition;
import org.picketlink.idm.query.internal.LikeCondition;
import org.picketlink.idm.spi.AttributeStore;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.PartitionStore;

@CredentialHandlers(value={PasswordCredentialHandler.class, X509CertificateCredentialHandler.class, DigestCredentialHandler.class, TOTPCredentialHandler.class, TokenCredentialHandler.class})
public class JPAIdentityStore
extends AbstractAttributeStore<JPAIdentityStoreConfiguration>
implements CredentialStore<JPAIdentityStoreConfiguration>,
PartitionStore<JPAIdentityStoreConfiguration>,
AttributeStore<JPAIdentityStoreConfiguration>,
PermissionStore {
    public static final String INVOCATION_CTX_ENTITY_MANAGER = "CTX_ENTITY_MANAGER";
    private final List<EntityMapper> entityMappers = new ArrayList<EntityMapper>();

    @Override
    public void setup(JPAIdentityStoreConfiguration config) {
        super.setup(config);
        if (config.getContextInitializers().isEmpty()) {
            IDMInternalLog.JPA_STORE_LOGGER.jpaContextInitializerNotProvided();
        }
        for (Class entityType : config.getEntityTypes()) {
            this.configureEntityMapper(entityType);
        }
        this.logEntityMappers();
        this.validateConfiguration();
    }

    @Override
    public void addAttributedType(IdentityContext context, AttributedType attributedType) {
        EntityManager entityManager = this.getEntityManager(context);
        for (EntityMapper entityMapper : this.getMapperFor(attributedType.getClass())) {
            entityMapper.persist(attributedType, entityManager);
            if (!Relationship.class.isInstance(attributedType) || !entityMapper.isRoot()) continue;
            this.storeRelationshipMembers((Relationship)attributedType, entityManager);
        }
    }

    @Override
    public void updateAttributedType(IdentityContext context, AttributedType attributedType) {
        EntityManager entityManager = this.getEntityManager(context);
        for (EntityMapper entityMapper : this.getMapperFor(attributedType.getClass())) {
            entityMapper.updateEntity(attributedType, entityManager);
        }
    }

    @Override
    public void removeAttributedType(IdentityContext context, AttributedType attributedType) {
        EntityManager entityManager = this.getEntityManager(context);
        EntityMapper rootMapper = this.getRootMapper(attributedType.getClass());
        if (Relationship.class.isAssignableFrom(attributedType.getClass())) {
            this.removeChildRelationships(context, (Relationship)attributedType, entityManager);
        }
        this.removeAssociatedEntities(attributedType, entityManager, rootMapper);
        entityManager.remove(this.getRootEntity(attributedType, entityManager));
    }

    @Override
    protected void removeFromRelationships(IdentityContext context, IdentityType identityType) {
        List<?> relationshipsToRemove = this.findIdentityTypeRelationships(context, Relationship.class, identityType);
        for (Object relationship : relationshipsToRemove) {
            this.remove(context, (AttributedType)this.convertToRelationshipType(context, relationship));
        }
    }

    @Override
    protected void removeCredentials(IdentityContext context, Account account) {
        EntityManager entityManager = this.getEntityManager(context);
        ArrayList entities = new ArrayList();
        for (EntityMapper attributeMapper : this.getEntityMappers()) {
            if (!attributeMapper.getEntityType().isAnnotationPresent(ManagedCredential.class)) continue;
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(attributeMapper.getEntityType());
            Root root = criteria.from(attributeMapper.getEntityType());
            Object agentInstance = this.getRootEntity((AttributedType)account, entityManager);
            Property identityTypeProperty = attributeMapper.getProperty(OwnerReference.class).getValue();
            criteria.where((Expression)builder.equal((Expression)root.get(identityTypeProperty.getName()), agentInstance));
            Property effectiveProperty = attributeMapper.getProperty(EffectiveDate.class).getValue();
            criteria.orderBy(new Order[]{builder.desc((Expression)root.get(effectiveProperty.getName()))});
            List result = entityManager.createQuery(criteria).getResultList();
            for (Object storageEntity : result) {
                entities.add(storageEntity);
            }
        }
        for (EntityMapper credentialEntity : entities) {
            entityManager.remove((Object)credentialEntity);
        }
    }

    public void add(IdentityContext identityContext, Partition partition, String configurationName) {
        this.add(identityContext, (AttributedType)partition);
        EntityMapper entityMapper = this.getRootMapper(partition.getClass());
        EntityManager entityManager = this.getEntityManager(identityContext);
        Object partitionEntity = this.getRootEntity((AttributedType)partition, entityManager);
        Property configurationNameProperty = entityMapper.getProperty(partition.getClass(), ConfigurationName.class).getValue();
        configurationNameProperty.setValue(partitionEntity, (Object)configurationName);
        entityManager.merge(partitionEntity);
    }

    public String getConfigurationName(IdentityContext identityContext, Partition partition) {
        EntityMapper entityMapper = this.getRootMapper(partition.getClass());
        EntityManager entityManager = this.getEntityManager(identityContext);
        Object partitionEntity = entityManager.find(entityMapper.getEntityType(), (Object)partition.getId());
        Property configurationNameProperty = entityMapper.getProperty(partition.getClass(), ConfigurationName.class).getValue();
        String configurationName = configurationNameProperty.getValue(partitionEntity).toString();
        if (StringUtil.isNullOrEmpty((String)configurationName)) {
            throw IDMInternalMessages.MESSAGES.partitionWithNoConfigurationName(partition);
        }
        return configurationName;
    }

    public <P extends Partition> P get(IdentityContext identityContext, Class<P> partitionClass, String name) {
        List<P> result = this.getPartitions(identityContext, partitionClass, name);
        if (!result.isEmpty()) {
            if (result.size() > 1) {
                throw IDMInternalMessages.MESSAGES.partitionFoundWithSameNameAndType(name, partitionClass);
            }
            return (P)((Partition)result.get(0));
        }
        return null;
    }

    public <P extends Partition> List<P> get(IdentityContext identityContext, Class<P> partitionClass) {
        return this.getPartitions(identityContext, partitionClass, null);
    }

    public <P extends Partition> List<P> getPartitions(IdentityContext identityContext, Class<P> partitionClass, String name) {
        EntityManager entityManager = this.getEntityManager(identityContext);
        String PARTITION_NAME_PROPERTY_NAME = "name";
        EntityMapper entityMapper = this.getEntityMapperForProperty(partitionClass, PARTITION_NAME_PROPERTY_NAME);
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(entityMapper.getEntityType());
        Root from = cq.from(entityMapper.getEntityType());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (!StringUtil.isNullOrEmpty((String)name)) {
            Property nameProperty = entityMapper.getProperty(partitionClass, PARTITION_NAME_PROPERTY_NAME).getValue();
            predicates.add(cb.equal((Expression)from.get(nameProperty.getName()), (Object)name));
        }
        if (!Partition.class.equals(partitionClass)) {
            Property typeProperty = entityMapper.getProperty(partitionClass, PartitionClass.class).getValue();
            predicates.add(cb.equal((Expression)from.get(typeProperty.getName()), (Object)partitionClass.getName()));
        }
        cq.where(predicates.toArray(new Predicate[predicates.size()]));
        TypedQuery query = entityManager.createQuery(cq);
        ArrayList result = new ArrayList();
        for (Object entity : query.getResultList()) {
            result.add(entityMapper.createType(entity, entityManager));
        }
        return result;
    }

    public <P extends Partition> P lookupById(IdentityContext context, Class<P> partitionClass, String id) {
        EntityManager entityManager = this.getEntityManager(context);
        EntityMapper entityMapper = this.getRootMapper(Partition.class);
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(entityMapper.getEntityType());
        Root from = cq.from(entityMapper.getEntityType());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Property idProperty = entityMapper.getProperty(Partition.class, Identifier.class).getValue();
        predicates.add(cb.equal((Expression)from.get(idProperty.getName()), (Object)id));
        if (!Partition.class.equals(partitionClass)) {
            Property typeProperty = entityMapper.getProperty(partitionClass, PartitionClass.class).getValue();
            predicates.add(cb.equal((Expression)from.get(typeProperty.getName()), (Object)partitionClass.getName()));
        }
        cq.where(predicates.toArray(new Predicate[predicates.size()]));
        TypedQuery query = entityManager.createQuery(cq);
        query.setMaxResults(1);
        List result = query.getResultList();
        if (!result.isEmpty()) {
            return (P)((Partition)entityMapper.createType(result.get(0), entityManager));
        }
        return null;
    }

    public void update(IdentityContext identityContext, Partition partition) {
        this.update(identityContext, (AttributedType)partition);
    }

    public void remove(IdentityContext identityContext, Partition partition) {
        this.remove(identityContext, (AttributedType)partition);
    }

    @Override
    protected Collection<Attribute<? extends Serializable>> getAttributes(IdentityContext identityContext, AttributedType attributedType) {
        EntityMapper attributeMapper = this.getAttributeMapper(attributedType.getClass());
        Class<?> attributeEntityClass = attributeMapper.getEntityType();
        EntityManager entityManager = this.getEntityManager(identityContext);
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(attributeEntityClass);
        Root from = cq.from(attributeEntityClass);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Property attributeNameProperty = attributeMapper.getProperty(Attribute.class, AttributeName.class).getValue();
        Property ownerProperty = attributeMapper.getProperty(Attribute.class, OwnerReference.class).getValue();
        if (((JPAIdentityStoreConfiguration)this.getConfig()).supportsType(attributedType.getClass(), IdentityStoreConfiguration.IdentityOperation.create) && !String.class.equals((Object)ownerProperty.getJavaClass())) {
            predicates.add(cb.equal((Expression)from.get(ownerProperty.getName()), this.getOwnerEntity(attributedType, ownerProperty, entityManager)));
        } else {
            predicates.add(cb.equal((Expression)from.get(ownerProperty.getName()), (Object)attributedType.getId()));
        }
        cq.where(predicates.toArray(new Predicate[predicates.size()]));
        Property attributeValueProperty = attributeMapper.getProperty(Attribute.class, AttributeValue.class).getValue();
        HashMap<String, Attribute> attributes = new HashMap<String, Attribute>();
        for (Object attributeEntity : entityManager.createQuery(cq).getResultList()) {
            String storedName = attributeNameProperty.getValue(attributeEntity).toString();
            Serializable storedValue = (Serializable)Base64.decodeToObject((String)attributeValueProperty.getValue(attributeEntity).toString());
            Attribute attribute = (Attribute)attributes.get(storedName);
            if (attribute == null) {
                attribute = new Attribute(storedName, storedValue);
            } else if (attribute != null) {
                Serializable[] values = null;
                if (attribute.getValue().getClass().isArray()) {
                    values = (Serializable[])attribute.getValue();
                } else {
                    values = (Serializable[])Array.newInstance(attribute.getValue().getClass(), 1);
                    values[0] = attribute.getValue();
                }
                Serializable[] newValues = Arrays.copyOf(values, values.length + 1);
                newValues[newValues.length - 1] = storedValue;
                attribute.setValue((Serializable)newValues);
            }
            attributes.put(attribute.getName(), attribute);
        }
        return attributes.values();
    }

    public void removeAttribute(IdentityContext context, AttributedType attributedType, String attributeName) {
        EntityMapper attributeMapper = this.getAttributeMapper(attributedType.getClass());
        EntityManager entityManager = this.getEntityManager(context);
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(attributeMapper.getEntityType());
        Root from = cq.from(attributeMapper.getEntityType());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Property attributeNameProperty = attributeMapper.getProperty(Attribute.class, AttributeName.class).getValue();
        predicates.add(cb.equal((Expression)from.get(attributeNameProperty.getName()), (Object)attributeName));
        Property ownerProperty = attributeMapper.getProperty(Attribute.class, OwnerReference.class).getValue();
        if (((JPAIdentityStoreConfiguration)this.getConfig()).supportsType(attributedType.getClass(), IdentityStoreConfiguration.IdentityOperation.create) && !String.class.equals((Object)ownerProperty.getJavaClass())) {
            predicates.add(cb.equal((Expression)from.get(ownerProperty.getName()), this.getOwnerEntity(attributedType, ownerProperty, entityManager)));
        } else {
            predicates.add(cb.equal((Expression)from.get(ownerProperty.getName()), (Object)attributedType.getId()));
        }
        cq.where(predicates.toArray(new Predicate[predicates.size()]));
        for (Object entity : entityManager.createQuery(cq).getResultList()) {
            entityManager.remove(entity);
        }
    }

    public <V extends IdentityType> List<V> fetchQueryResults(IdentityContext context, IdentityQuery<V> identityQuery) {
        ArrayList<Object> result = new ArrayList<Object>();
        Class type = identityQuery.getIdentityType();
        for (Condition condition : identityQuery.getConditions()) {
            IdentityType identityType;
            if (!IdentityType.ID.equals(condition.getParameter())) continue;
            if (!EqualCondition.class.isInstance(condition)) {
                throw new IdentityManagementException("Only equality conditions are allowed when queryng based on the identifier.");
            }
            EqualCondition equalCondition = (EqualCondition)condition;
            Object value = equalCondition.getValue();
            if (value != null && (identityType = this.lookupIdentityTypeById(context, type, value.toString())) != null) {
                result.add(identityType);
            }
            return result;
        }
        EntityMapper rootMapper = this.getRootMapper(type);
        EntityManager entityManager = this.getEntityManager(context);
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(rootMapper.getEntityType());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Root rootEntity = cq.from(rootMapper.getEntityType());
        Partition partition = context.getPartition();
        for (Condition condition : identityQuery.getConditions()) {
            if (!IdentityType.PARTITION.equals(condition.getParameter())) continue;
            if (!EqualCondition.class.isInstance(condition)) {
                throw new IdentityManagementException("Only equality conditions are allowed when queryng based on a partition.");
            }
            EqualCondition equalCondition = (EqualCondition)condition;
            Object value = equalCondition.getValue();
            if (value == null) continue;
            partition = (Partition)value;
        }
        Map.Entry<Property, Property> partitionProperty = rootMapper.getProperty(OwnerReference.class);
        if (partitionProperty != null && ((JPAIdentityStoreConfiguration)this.getConfig()).supportsPartition()) {
            Join join = rootEntity.join(partitionProperty.getValue().getName());
            predicates.add(cb.equal((Expression)join, entityManager.find(partitionProperty.getValue().getJavaClass(), (Object)partition.getId())));
        }
        if (!IdentityType.class.equals((Object)type)) {
            Property typeProperty = rootMapper.getProperty(type, IdentityClass.class).getValue();
            predicates.add(cb.equal((Expression)rootEntity.get(typeProperty.getName()), (Object)type.getName()));
        }
        for (Condition condition : identityQuery.getConditions()) {
            QueryParameter queryParameter = condition.getParameter();
            if (IdentityType.PARTITION.equals(queryParameter) || !AttributeParameter.class.isInstance(queryParameter)) continue;
            AttributeParameter attributeParameter = (AttributeParameter)queryParameter;
            EntityMapper parameterEntityMapper = this.getEntityMapperForProperty((Class<? extends AttributedType>)type, attributeParameter.getName());
            if (parameterEntityMapper != null) {
                Property attributeProperty = parameterEntityMapper.getProperty(type, attributeParameter.getName()).getValue();
                Root attributeOwnerEntity = rootEntity;
                if (!parameterEntityMapper.getEntityType().equals(rootMapper.getEntityType())) {
                    attributeOwnerEntity = cq.from(parameterEntityMapper.getEntityType());
                    Property ownerProperty = parameterEntityMapper.getProperty(OwnerReference.class).getValue();
                    if (ownerProperty != null) {
                        if (ownerProperty.getAnnotatedElement().isAnnotationPresent(Identifier.class)) {
                            predicates.add(cb.and(new Predicate[]{cb.equal((Expression)attributeOwnerEntity, (Expression)rootEntity)}));
                        } else {
                            predicates.add(cb.and(new Predicate[]{cb.equal((Expression)attributeOwnerEntity.get(ownerProperty.getName()), (Expression)rootEntity)}));
                        }
                    }
                }
                this.addCondition(entityManager, cb, predicates, condition, attributeProperty, attributeOwnerEntity, false);
                continue;
            }
            if (!((JPAIdentityStoreConfiguration)this.getConfig()).supportsAttribute()) continue;
            this.addAttributeQueryPredicates(type, entityManager, cb, cq, rootEntity, predicates, attributeParameter, condition, null);
        }
        Property idProperty = rootMapper.getProperty(Identifier.class).getValue();
        cq.select((Selection)rootEntity.get(idProperty.getName()));
        cq.where(predicates.toArray(new Predicate[predicates.size()]));
        if (!identityQuery.getSorting().isEmpty()) {
            ArrayList<Order> orders = new ArrayList<Order>();
            for (Sort sort : identityQuery.getSorting()) {
                QueryParameter queryParameter = sort.getParameter();
                if (!AttributeParameter.class.isInstance(queryParameter)) {
                    throw new IdentityManagementException("Sorting parameter is not a [" + AttributeParameter.class + "].");
                }
                AttributeParameter attributeParameter = (AttributeParameter)queryParameter;
                if (sort.isAscending()) {
                    orders.add(cb.asc((Expression)rootEntity.get(attributeParameter.getName())));
                    continue;
                }
                orders.add(cb.desc((Expression)rootEntity.get(attributeParameter.getName())));
            }
            cq.orderBy(orders);
        }
        TypedQuery query = entityManager.createQuery(cq);
        if (identityQuery.getLimit() > 0) {
            query.setMaxResults(identityQuery.getLimit());
            if (identityQuery.getOffset() > 0) {
                query.setFirstResult(identityQuery.getOffset());
            }
        }
        for (Object entity : query.getResultList()) {
            result.add(rootMapper.createType(entityManager.find(rootMapper.getEntityType(), entity), entityManager));
        }
        return result;
    }

    private void addCondition(EntityManager entityManager, CriteriaBuilder cb, List<Predicate> predicates, Condition condition, Property attributeProperty, Root<?> attributeOwnerEntity, boolean convertValueToBase64) {
        if (EqualCondition.class.isInstance(condition)) {
            AttributedType ownerType;
            EqualCondition equalCondition = (EqualCondition)condition;
            Object parameterValue = equalCondition.getValue();
            if (convertValueToBase64) {
                parameterValue = Base64.encodeObject((Serializable)((Serializable)parameterValue));
            }
            if (this.isMappedType(attributeProperty.getJavaClass()) && (ownerType = (AttributedType)parameterValue) != null) {
                parameterValue = entityManager.find(attributeProperty.getJavaClass(), (Object)ownerType.getId());
            }
            predicates.add(cb.equal((Expression)attributeOwnerEntity.get(attributeProperty.getName()), parameterValue));
        } else if (LikeCondition.class.isInstance(condition)) {
            LikeCondition likeCondition = (LikeCondition)condition;
            String parameterValue = (String)likeCondition.getValue();
            if (convertValueToBase64) {
                parameterValue = Base64.encodeObject((Serializable)((Object)parameterValue));
            }
            predicates.add(cb.like((Expression)attributeOwnerEntity.get(attributeProperty.getName()), parameterValue));
        } else if (GreaterThanCondition.class.isInstance(condition)) {
            GreaterThanCondition greaterThanCondition = (GreaterThanCondition)condition;
            Object parameterValue = greaterThanCondition.getValue();
            if (convertValueToBase64) {
                parameterValue = Base64.encodeObject((Serializable)((Serializable)parameterValue));
            }
            if (greaterThanCondition.isOrEqual()) {
                predicates.add(cb.greaterThanOrEqualTo((Expression)attributeOwnerEntity.get(attributeProperty.getName()), (Comparable)parameterValue));
            } else {
                predicates.add(cb.greaterThan((Expression)attributeOwnerEntity.get(attributeProperty.getName()), (Comparable)parameterValue));
            }
        } else if (LessThanCondition.class.isInstance(condition)) {
            LessThanCondition lessThanCondition = (LessThanCondition)condition;
            Object parameterValue = lessThanCondition.getValue();
            if (convertValueToBase64) {
                parameterValue = Base64.encodeObject((Serializable)((Serializable)parameterValue));
            }
            if (lessThanCondition.isOrEqual()) {
                predicates.add(cb.lessThanOrEqualTo((Expression)attributeOwnerEntity.get(attributeProperty.getName()), (Comparable)parameterValue));
            } else {
                predicates.add(cb.lessThan((Expression)attributeOwnerEntity.get(attributeProperty.getName()), (Comparable)parameterValue));
            }
        } else if (BetweenCondition.class.isInstance(condition)) {
            BetweenCondition betweenCondition = (BetweenCondition)condition;
            Object x = betweenCondition.getX();
            Object y = betweenCondition.getY();
            if (convertValueToBase64) {
                x = Base64.encodeObject((Serializable)((Serializable)x));
                y = Base64.encodeObject((Serializable)((Serializable)y));
            }
            predicates.add(cb.between((Expression)attributeOwnerEntity.get(attributeProperty.getName()), (Comparable)x, (Comparable)y));
        } else if (InCondition.class.isInstance(condition)) {
            InCondition inCondition = (InCondition)condition;
            Object[] valuesToSearch = new String[inCondition.getValue().length];
            for (int i = 0; i < inCondition.getValue().length; ++i) {
                valuesToSearch[i] = convertValueToBase64 ? Base64.encodeObject((Serializable)((Serializable)inCondition.getValue()[i])) : inCondition.getValue()[i];
            }
            predicates.add(attributeOwnerEntity.get(attributeProperty.getName()).in(valuesToSearch));
        } else {
            throw new IdentityManagementException("Unsupported query condition [" + condition + "].");
        }
    }

    public <V extends Relationship> List<V> fetchQueryResults(IdentityContext context, RelationshipQuery<V> query) {
        EntityManager entityManager = this.getEntityManager(context);
        List<Object> entities = new ArrayList();
        Object[] identityParameterValues = query.getParameter(Relationship.IDENTITY);
        if (identityParameterValues != null) {
            for (Object parameterValue : identityParameterValues) {
                if (!IdentityType.class.isInstance(parameterValue)) {
                    throw IDMInternalMessages.MESSAGES.queryUnsupportedParameterValue("Relationship.IDENTITY", parameterValue);
                }
                entities = this.findIdentityTypeRelationships(context, query.getRelationshipClass(), (IdentityType)parameterValue);
            }
        } else {
            Class relationshipType = query.getRelationshipClass();
            EntityMapper entityMapper = this.getRootMapper(relationshipType);
            CriteriaBuilder cb = entityManager.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(entityMapper.getEntityType());
            Root root = cq.from(entityMapper.getEntityType());
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            Property typeProperty = entityMapper.getProperty(RelationshipClass.class).getValue();
            if (!Relationship.class.equals((Object)relationshipType)) {
                predicates.add(cb.equal((Expression)root.get(typeProperty.getName()), (Object)relationshipType.getName()));
            }
            Object[] idParameterValues = query.getParameter(Relationship.ID);
            Property idProperty = entityMapper.getProperty(Identifier.class).getValue();
            if (idParameterValues != null && idParameterValues.length > 0) {
                predicates.add(cb.equal((Expression)root.get(idProperty.getName()), idParameterValues[0]));
            } else {
                for (Map.Entry entry : query.getParameters().entrySet()) {
                    QueryParameter queryParameter = (QueryParameter)entry.getKey();
                    Object[] values = (Object[])entry.getValue();
                    if (queryParameter instanceof RelationshipQueryParameter) {
                        RelationshipQueryParameter identityTypeParameter = (RelationshipQueryParameter)entry.getKey();
                        ArrayList<String> identityTypeIdentifiers = new ArrayList<String>();
                        EntityMapper relationshipMemberMapper = this.getEntityMapperForProperty((Class<? extends AttributedType>)relationshipType, RelationshipMember.class);
                        for (Object object : values) {
                            IdentityType identityType = (IdentityType)object;
                            if (identityType == null) {
                                return Collections.emptyList();
                            }
                            Property identityTypeProperty = relationshipMemberMapper.getProperty(RelationshipMember.class).getValue();
                            if (identityTypeProperty.getJavaClass().equals(String.class)) {
                                identityTypeIdentifiers.add(IdentityTypeUtil.formatId(identityType));
                                continue;
                            }
                            identityTypeIdentifiers.add(identityType.getId());
                        }
                        Property relationshipProperty = relationshipMemberMapper.getProperty(OwnerReference.class).getValue();
                        Subquery subQuery = cq.subquery(relationshipMemberMapper.getEntityType());
                        Root fromRelationshipIdentityType = subQuery.from(relationshipMemberMapper.getEntityType());
                        subQuery.select((Expression)fromRelationshipIdentityType.get(relationshipProperty.getName()).get(idProperty.getName()));
                        ArrayList<Predicate> subQueryPredicates = new ArrayList<Predicate>();
                        Property descriptorProperty = relationshipMemberMapper.getProperty(RelationshipDescriptor.class).getValue();
                        subQueryPredicates.add(cb.equal((Expression)fromRelationshipIdentityType.get(descriptorProperty.getName()), (Object)identityTypeParameter.getName()));
                        Property identityProperty = relationshipMemberMapper.getProperty(RelationshipMember.class).getValue();
                        if (identityProperty.getJavaClass().equals(String.class)) {
                            subQueryPredicates.add(fromRelationshipIdentityType.get(identityProperty.getName()).in(identityTypeIdentifiers));
                        } else {
                            Join join = fromRelationshipIdentityType.join(identityProperty.getName());
                            EntityMapper identityTypeMapper = this.getMapperForEntity(identityProperty.getJavaClass());
                            Property identifierProperty = identityTypeMapper.getProperty(Identifier.class).getValue();
                            subQueryPredicates.add(join.get(identifierProperty.getName()).in(identityTypeIdentifiers));
                        }
                        subQuery.where(subQueryPredicates.toArray(new Predicate[subQueryPredicates.size()]));
                        predicates.add((Predicate)cb.in((Expression)root.get(idProperty.getName())).value((Expression)subQuery));
                        continue;
                    }
                    if (!AttributeParameter.class.equals(((QueryParameter)entry.getKey()).getClass())) continue;
                    AttributeParameter attributeParameter = (AttributeParameter)entry.getKey();
                    Object[] parameterValues = (Object[])entry.getValue();
                    EntityMapper parameterEntityMapper = this.getEntityMapperForProperty((Class<? extends AttributedType>)relationshipType, attributeParameter.getName());
                    if (parameterEntityMapper != null) {
                        AttributedType ownerType;
                        Root propertyEntityJoin = root;
                        Property ownerProperty = parameterEntityMapper.getProperty(relationshipType, OwnerReference.class).getValue();
                        if (ownerProperty.getJavaClass().equals(entityMapper.getEntityType())) {
                            propertyEntityJoin = cq.from(parameterEntityMapper.getEntityType());
                            predicates.add(cb.and(new Predicate[]{cb.equal((Expression)propertyEntityJoin.get(ownerProperty.getName()), (Expression)root)}));
                        }
                        Object parameterValue = parameterValues[0];
                        Property mappedProperty = parameterEntityMapper.getProperty(relationshipType, attributeParameter.getName()).getValue();
                        if (this.isMappedType(mappedProperty.getJavaClass()) && (ownerType = (AttributedType)parameterValue) != null) {
                            parameterValue = entityManager.find(mappedProperty.getJavaClass(), (Object)ownerType.getId());
                        }
                        predicates.add(cb.equal((Expression)propertyEntityJoin.get(mappedProperty.getName()), parameterValue));
                        continue;
                    }
                    this.addAttributeQueryPredicates(relationshipType, entityManager, cb, cq, root, predicates, attributeParameter, null, parameterValues);
                }
            }
            cq.select((Selection)root);
            cq.where(predicates.toArray(new Predicate[predicates.size()]));
            entities = entityManager.createQuery(cq).getResultList();
        }
        ArrayList result = new ArrayList();
        for (Object relationshipObject : entities) {
            result.add(this.convertToRelationshipType(context, relationshipObject));
        }
        return result;
    }

    @Override
    public void doSetAttribute(IdentityContext context, AttributedType attributedType, Attribute<? extends Serializable> attribute) {
        this.removeAttribute(context, attributedType, attribute.getName());
        Serializable[] values = attribute.getValue();
        if (!values.getClass().isArray()) {
            values = new Serializable[]{values};
        }
        if (values instanceof byte[]) {
            values = new Serializable[]{values};
        }
        EntityMapper attributeMapper = this.getAttributeMapper(attributedType.getClass());
        Property attributeNameProperty = attributeMapper.getProperty(Attribute.class, AttributeName.class).getValue();
        Property attributeValueProperty = attributeMapper.getProperty(Attribute.class, AttributeValue.class).getValue();
        Property ownerProperty = attributeMapper.getProperty(Attribute.class, OwnerReference.class).getValue();
        EntityManager entityManager = this.getEntityManager(context);
        for (Serializable attributeValue : values) {
            Object attributeEntity = attributeMapper.createEntity();
            attributeNameProperty.setValue(attributeEntity, (Object)attribute.getName());
            attributeValueProperty.setValue(attributeEntity, (Object)Base64.encodeObject((Serializable)attributeValue));
            if (((JPAIdentityStoreConfiguration)this.getConfig()).supportsType(attributedType.getClass(), IdentityStoreConfiguration.IdentityOperation.create) && !String.class.equals((Object)ownerProperty.getJavaClass())) {
                ownerProperty.setValue(attributeEntity, this.getOwnerEntity(attributedType, ownerProperty, entityManager));
            } else {
                ownerProperty.setValue(attributeEntity, (Object)attributedType.getId());
            }
            entityManager.persist(attributeEntity);
            entityManager.flush();
        }
    }

    public void storeCredential(IdentityContext context, Account account, CredentialStorage storage) {
        EntityMapper credentialMapper = this.getCredentialAttributeMapper(storage.getClass());
        Object newCredential = credentialMapper.createEntity();
        EntityManager entityManager = this.getEntityManager(context);
        for (EntityMapping entityMapping : credentialMapper.getEntityMappings()) {
            for (Property property : entityMapping.getProperties().keySet()) {
                Property mappedProperty = entityMapping.getProperties().get(property);
                if (mappedProperty.getAnnotatedElement().isAnnotationPresent(OwnerReference.class)) {
                    mappedProperty.setValue(newCredential, this.getOwnerEntity((AttributedType)account, mappedProperty, entityManager));
                    continue;
                }
                mappedProperty.setValue(newCredential, property.getValue((Object)storage));
            }
        }
        entityManager.persist(newCredential);
        entityManager.flush();
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(IdentityContext context, Account account, Class<T> storageClass) {
        List<T> credentials = this.retrieveCredentials(context, account, storageClass);
        if (!credentials.isEmpty()) {
            return (T)((CredentialStorage)credentials.get(0));
        }
        return null;
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(IdentityContext context, Account account, Class<T> storageClass) {
        ArrayList<T> storages = new ArrayList<T>();
        for (Object object : this.findCredentials(context, account, storageClass)) {
            storages.add(this.convertToCredentialStorage(object, storageClass));
        }
        return storages;
    }

    public void removeCredential(IdentityContext context, Account account, Class<? extends CredentialStorage> storageClass) {
        List<?> credentials = this.findCredentials(context, account, storageClass);
        EntityManager entityManager = this.getEntityManager(context);
        for (Object credential : credentials) {
            entityManager.remove(credential);
        }
        entityManager.flush();
    }

    public Object getOwnerEntity(AttributedType attributedType, Property ownerProperty, EntityManager entityManager) {
        EntityMapper attributedTypeMapper = this.getRootMapper(attributedType.getClass());
        Object entity = null;
        if (ownerProperty.getJavaClass().isAssignableFrom(attributedTypeMapper.getEntityType())) {
            entity = this.getRootEntity(attributedType, entityManager);
        } else {
            EntityMapper ownerMapper = this.getMapperForEntity(ownerProperty.getJavaClass());
            List associatedEntities = attributedTypeMapper.getAssociatedEntities(attributedType, ownerMapper, entityManager);
            if (!associatedEntities.isEmpty()) {
                entity = associatedEntities.get(0);
            }
        }
        return entity;
    }

    public List<EntityMapper> getMapperFor(Class<? extends AttributedType> attributedType) {
        ArrayList<EntityMapper> mappers = new ArrayList<EntityMapper>();
        for (EntityMapper entityMapper : this.entityMappers) {
            if (!entityMapper.getEntityType().isAnnotationPresent(IdentityManaged.class)) continue;
            for (EntityMapping entityMapping : entityMapper.getEntityMappings()) {
                if ((entityMapping.getSupportedType().equals(attributedType) || entityMapping.getSupportedType().isAssignableFrom(attributedType)) && entityMapper.isRoot()) {
                    mappers.add(0, entityMapper);
                    continue;
                }
                if (entityMapping.getSupportedType().isAssignableFrom(attributedType)) {
                    mappers.add(entityMapper);
                    continue;
                }
                if (!Partition.class.equals(attributedType) && !IdentityType.class.equals(attributedType) && !Relationship.class.equals(attributedType) || !attributedType.isAssignableFrom(entityMapping.getSupportedType())) continue;
                mappers.add(entityMapper);
            }
        }
        if (mappers.isEmpty()) {
            throw new IdentityManagementException("No entity mapper found for type [" + attributedType + "].");
        }
        return mappers;
    }

    public EntityMapper getRootMapperForEntity(Class<?> entityClass) {
        for (EntityMapper entityMapper : this.entityMappers) {
            if (!entityMapper.isRoot() || !entityMapper.getEntityType().equals(entityClass)) continue;
            return entityMapper;
        }
        throw new IdentityManagementException("No mapper for entity type [" + entityClass + "].");
    }

    public EntityMapper getMapperForEntity(Class<?> entityClass) {
        for (EntityMapper entityMapper : this.entityMappers) {
            if (!entityMapper.getEntityType().equals(entityClass)) continue;
            return entityMapper;
        }
        throw new IdentityManagementException("No mapper for entity type [" + entityClass + "].");
    }

    public List<EntityMapper> getEntityMappers() {
        return this.entityMappers;
    }

    public boolean isMappedType(Class mappedClass) {
        for (EntityMapper entityMapper : this.getEntityMappers()) {
            if (!entityMapper.getEntityType().equals(mappedClass)) continue;
            return true;
        }
        return false;
    }

    public Object getRootEntity(AttributedType attributedType, EntityManager entityManager) {
        return entityManager.find(this.getRootMapper(attributedType.getClass()).getEntityType(), (Object)attributedType.getId());
    }

    private <V extends IdentityType> IdentityType lookupIdentityTypeById(IdentityContext context, Class<V> type, String identifier) {
        EntityManager entityManager = this.getEntityManager(context);
        if (IdentityType.class.equals(type)) {
            for (EntityMapper entityMapper : this.getEntityMappers()) {
                Object entity;
                IdentityType identityType;
                if (entityMapper.getMappingsFor(type) == null || !entityMapper.isRoot() || (identityType = (IdentityType)entityMapper.createType(entity = entityManager.find(entityMapper.getEntityType(), (Object)identifier), entityManager)) == null) continue;
                return identityType;
            }
        } else {
            Object entity = entityManager.find(this.getRootMapper(type).getEntityType(), (Object)identifier);
            if (entity != null) {
                return (IdentityType)this.getRootMapperForEntity(entity.getClass()).createType(entity, entityManager);
            }
        }
        return null;
    }

    private EntityMapper getEntityMapperForProperty(Class<? extends AttributedType> attributedType, String propertyName) {
        for (EntityMapper entityMapper : this.getMapperFor(attributedType)) {
            Map.Entry<Property, Property> property = entityMapper.getProperty(attributedType, propertyName);
            if (property == null) continue;
            return entityMapper;
        }
        return null;
    }

    private EntityMapper getEntityMapperForProperty(Class<? extends AttributedType> attributedType, Class<? extends Annotation> annotation) {
        for (EntityMapper entityMapper : this.entityMappers) {
            Map.Entry<Property, Property> property = entityMapper.getProperty(attributedType, annotation);
            if (property == null) continue;
            return entityMapper;
        }
        return null;
    }

    private List<?> findIdentityTypeRelationships(IdentityContext context, Class<? extends Relationship> relationshipType, IdentityType identityType) {
        ArrayList<Object> relationships = new ArrayList<Object>();
        for (EntityMapper relationshipMemberMapper : this.getEntityMappers()) {
            Map.Entry<Property, Property> property = relationshipMemberMapper.getProperty(RelationshipMember.class);
            if (property == null) continue;
            EntityManager em = this.getEntityManager(context);
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(relationshipMemberMapper.getEntityType());
            Root root = criteria.from(relationshipMemberMapper.getEntityType());
            Property identityTypeProperty = relationshipMemberMapper.getProperty(RelationshipMember.class).getValue();
            if (identityTypeProperty.getJavaClass().equals(String.class)) {
                criteria.where((Expression)builder.equal((Expression)root.get(identityTypeProperty.getName()), (Object)IdentityTypeUtil.formatId(identityType)));
            } else {
                criteria.where((Expression)builder.equal((Expression)root.get(identityTypeProperty.getName()), em.find(identityTypeProperty.getJavaClass(), (Object)identityType.getId())));
            }
            List result = em.createQuery(criteria).getResultList();
            Property ownerProperty = relationshipMemberMapper.getProperty(OwnerReference.class).getValue();
            for (Object object : result) {
                relationships.add(ownerProperty.getValue(object));
            }
        }
        return relationships;
    }

    private <T extends Relationship> T convertToRelationshipType(IdentityContext context, Object relationshipObject) {
        Class relationshipType;
        EntityMapper relationshipTypeMapper = this.getMapperForEntity(relationshipObject.getClass());
        Property typeProperty = relationshipTypeMapper.getTypeProperty();
        Object relationshipTypeName = typeProperty.getValue(relationshipObject);
        try {
            relationshipType = Reflections.classForName((String)relationshipTypeName.toString(), (ClassLoader[])new ClassLoader[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IdentityManagementException("Could not get type name from entity [" + relationshipObject + "].", (Throwable)e);
        }
        EntityMapper relationshipMemberMapper = this.getEntityMapperForProperty((Class<? extends AttributedType>)relationshipType, RelationshipMember.class);
        Property identityProperty = relationshipMemberMapper.getProperty(relationshipType, RelationshipMember.class).getValue();
        Property descriptorProperty = relationshipMemberMapper.getProperty(relationshipType, RelationshipDescriptor.class).getValue();
        EntityManager entityManager = this.getEntityManager(context);
        EntityMapper relMapper = this.getRootMapper(relationshipType);
        Relationship relationshipInstance = (Relationship)relMapper.createType(relationshipObject, entityManager);
        boolean isReference = !identityProperty.getJavaClass().equals(String.class);
        RelationshipReference reference = null;
        if (!isReference) {
            reference = new RelationshipReference(relationshipInstance);
        }
        for (Object object : this.findChildRelationships(context, relationshipInstance)) {
            String descriptor = ((String)descriptorProperty.getValue(object)).toString();
            Property identityTypeProperty = PropertyQueries.createQuery(relationshipInstance.getClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{descriptor})).getSingleResult();
            IdentityType identityType = null;
            Object identityTypeEntity = identityProperty.getValue(object);
            if (!isReference) {
                reference.addIdentityTypeReference(descriptor, identityTypeEntity.toString());
            } else {
                EntityMapper entityMapper = this.getRootMapperForEntity(identityTypeEntity.getClass());
                identityType = (IdentityType)entityMapper.createType(identityTypeEntity, entityManager);
            }
            identityTypeProperty.setValue((Object)relationshipInstance, identityType);
        }
        if (reference != null) {
            return (T)((Object)reference);
        }
        return (T)relationshipInstance;
    }

    private List<?> findChildRelationships(IdentityContext context, Relationship relationship) {
        EntityManager em = this.getEntityManager(context);
        EntityMapper relationshipMemberMapper = this.getEntityMapperForProperty(relationship.getClass(), RelationshipMember.class);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(relationshipMemberMapper.getEntityType());
        Root root = criteria.from(relationshipMemberMapper.getEntityType());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Property ownerProperty = relationshipMemberMapper.getProperty(OwnerReference.class).getValue();
        Join join = root.join(ownerProperty.getName());
        EntityMapper relationshipMapper = this.getRootMapper(relationship.getClass());
        Property identifierProperty = relationshipMapper.getProperty(Identifier.class).getValue();
        predicates.add(builder.equal((Expression)join.get(identifierProperty.getName()), (Object)relationship.getId()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    private <T extends CredentialStorage> List<?> findCredentials(IdentityContext context, Account account, Class<T> storageClass) {
        EntityMapper attributeMapper = this.getCredentialAttributeMapper(storageClass);
        EntityManager entityManager = this.getEntityManager(context);
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(attributeMapper.getEntityType());
        Root root = criteria.from(attributeMapper.getEntityType());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Object agentInstance = this.getRootEntity((AttributedType)account, entityManager);
        Property identityTypeProperty = attributeMapper.getProperty(storageClass, OwnerReference.class).getValue();
        predicates.add(builder.equal((Expression)root.get(identityTypeProperty.getName()), agentInstance));
        Property typeProperty = attributeMapper.getProperty(storageClass, CredentialClass.class).getValue();
        Property effectiveProperty = attributeMapper.getProperty(storageClass, EffectiveDate.class).getValue();
        predicates.add(builder.equal((Expression)root.get(typeProperty.getName()), (Object)storageClass.getName()));
        predicates.add(builder.lessThanOrEqualTo((Expression)root.get(effectiveProperty.getName()), (Comparable)new Date()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        criteria.orderBy(new Order[]{builder.desc((Expression)root.get(effectiveProperty.getName()))});
        return entityManager.createQuery(criteria).getResultList();
    }

    private <T extends CredentialStorage> T convertToCredentialStorage(Object entity, Class<T> storageType) {
        CredentialStorage storage = null;
        if (entity != null) {
            EntityMapper credentialMapper = this.getCredentialAttributeMapper(storageType);
            try {
                storage = (CredentialStorage)Reflections.newInstance(storageType);
            }
            catch (Exception e) {
                throw IDMInternalMessages.MESSAGES.instantiationError(storageType, e);
            }
            for (EntityMapping entityMapping : credentialMapper.getEntityMappings()) {
                for (Property property : entityMapping.getProperties().keySet()) {
                    Property mappedProperty = entityMapping.getProperties().get(property);
                    if (mappedProperty.getAnnotatedElement().isAnnotationPresent(OwnerReference.class)) continue;
                    property.setValue((Object)storage, mappedProperty.getValue(entity));
                }
            }
        }
        return (T)storage;
    }

    private EntityMapper getCredentialAttributeMapper(Class<? extends CredentialStorage> credentialStorageClass) {
        for (EntityMapper entityMapper : this.entityMappers) {
            ManagedCredential managedCredential = entityMapper.getEntityType().getAnnotation(ManagedCredential.class);
            if (managedCredential == null) continue;
            if (managedCredential.value().length > 0) {
                for (Class supportedType : managedCredential.value()) {
                    if (!supportedType.equals(credentialStorageClass)) continue;
                    return entityMapper;
                }
                for (Class supportedType : managedCredential.value()) {
                    if (!supportedType.isAssignableFrom(credentialStorageClass)) continue;
                    return entityMapper;
                }
                continue;
            }
            return entityMapper;
        }
        throw new IdentityManagementException("No mapper for for credential storage type [" + credentialStorageClass + "].");
    }

    private void removeChildRelationships(IdentityContext context, Relationship attributedType, EntityManager entityManager) {
        for (Object child : this.findChildRelationships(context, attributedType)) {
            entityManager.remove(child);
        }
    }

    private void removeAssociatedEntities(AttributedType attributedType, EntityManager entityManager, EntityMapper rootMapper) {
        for (EntityMapper childMapper : this.getMapperFor(attributedType.getClass())) {
            if (childMapper.isRoot()) continue;
            for (Object child : rootMapper.getAssociatedEntities(attributedType, childMapper, entityManager)) {
                entityManager.remove(child);
            }
        }
    }

    private EntityMapper getRootMapper(Class<? extends AttributedType> aClass) {
        return this.getMapperFor(aClass).get(0);
    }

    private void addAttributeQueryPredicates(Class<? extends AttributedType> attributedType, EntityManager entityManager, CriteriaBuilder cb, CriteriaQuery<?> cq, Root from, List<Predicate> predicates, AttributeParameter attributeParameter, Condition condition, Object[] parameterValues) {
        int valuesLength = 1;
        if (condition != null) {
            if (InCondition.class.isInstance(condition)) {
                InCondition inCondition = (InCondition)condition;
                valuesLength = inCondition.getValue().length;
            }
        } else {
            valuesLength = parameterValues.length;
        }
        EntityMapper attributeMapper = this.getAttributeMapper(attributedType);
        Subquery subQueryOwnerAttributesByValue = cq.subquery(attributeMapper.getEntityType());
        Root fromAttributeType = subQueryOwnerAttributesByValue.from(attributeMapper.getEntityType());
        Property ownerProperty = attributeMapper.getProperty(Attribute.class, OwnerReference.class).getValue();
        String ownerIdentifierPropertyName = this.getRootMapper(attributedType).getProperty(Identifier.class).getValue().getName();
        Path selection = String.class.equals((Object)ownerProperty.getJavaClass()) ? fromAttributeType.get(ownerProperty.getName()) : fromAttributeType.get(ownerProperty.getName()).get(ownerIdentifierPropertyName);
        subQueryOwnerAttributesByValue.select((Expression)selection);
        ArrayList<Predicate> conjunction = new ArrayList<Predicate>();
        Property attributeNameProperty = attributeMapper.getProperty(Attribute.class, AttributeName.class).getValue();
        conjunction.add(cb.equal((Expression)fromAttributeType.get(attributeNameProperty.getName()), (Object)attributeParameter.getName()));
        Property attributeValueProperty = attributeMapper.getProperty(Attribute.class, AttributeValue.class).getValue();
        if (condition == null) {
            String[] valuesToSearch = new String[parameterValues.length];
            for (int i = 0; i < parameterValues.length; ++i) {
                valuesToSearch[i] = Base64.encodeObject((Serializable)((Serializable)parameterValues[i]));
            }
            conjunction.add(fromAttributeType.get(attributeValueProperty.getName()).in((Object[])valuesToSearch));
        } else {
            this.addCondition(entityManager, cb, conjunction, condition, attributeValueProperty, fromAttributeType, true);
        }
        subQueryOwnerAttributesByValue.where(conjunction.toArray(new Predicate[conjunction.size()]));
        subQueryOwnerAttributesByValue.groupBy(new Expression[]{selection}).having((Expression)cb.equal(cb.count((Expression)selection), (Object)valuesLength));
        predicates.add((Predicate)cb.in((Expression)from.get(ownerIdentifierPropertyName)).value((Expression)subQueryOwnerAttributesByValue));
    }

    private EntityMapper getAttributeMapper(Class<? extends AttributedType> attributedType) {
        List<EntityMapper> attributeMappers = this.getAttributeMappers();
        if (!attributeMappers.isEmpty()) {
            boolean supportsType = ((JPAIdentityStoreConfiguration)this.getConfig()).supportsType(attributedType, IdentityStoreConfiguration.IdentityOperation.create);
            if (supportsType) {
                EntityMapper secondaryMapper = null;
                for (EntityMapper entityMapper : this.getMapperFor(attributedType)) {
                    for (EntityMapper mapper : attributeMappers) {
                        Class<?> entityType = entityMapper.getEntityType();
                        EntityMapping mappings = mapper.getMappingsFor(Attribute.class);
                        if (mappings.getOwnerType().equals(entityType)) {
                            return mapper;
                        }
                        if (!mappings.getOwnerType().isAssignableFrom(entityType)) continue;
                        secondaryMapper = mapper;
                    }
                }
                if (secondaryMapper != null) {
                    return secondaryMapper;
                }
            }
            for (EntityMapper mapper : attributeMappers) {
                EntityMapping mappings = mapper.getMappingsFor(Attribute.class);
                if (!String.class.equals(mappings.getOwnerType())) continue;
                return mapper;
            }
            if (!supportsType) {
                throw new IdentityManagementException("The store does not support type [" + attributedType + "]. The attribute mapping must provide a String-based field to reference instances of this type.");
            }
        }
        throw new IdentityManagementException("Could not find attribute mapper for type [" + attributedType + "].");
    }

    private List<EntityMapper> getAttributeMappers() {
        ArrayList<EntityMapper> attributeMappers = new ArrayList<EntityMapper>();
        for (EntityMapper entityMapper : this.entityMappers) {
            if (entityMapper.getProperty(AttributeClass.class) == null) continue;
            attributeMappers.add(entityMapper);
        }
        return attributeMappers;
    }

    private void storeRelationshipMembers(Relationship relationship, EntityManager entityManager) {
        Object ownerEntity = this.getRootEntity((AttributedType)relationship, entityManager);
        List props = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(IdentityType.class, TypedPropertyCriteria.MatchOption.SUB_TYPE)).getResultList();
        EntityMapper relationshipMemberMapper = this.getEntityMapperForProperty(relationship.getClass(), RelationshipMember.class);
        for (Property prop : props) {
            Object relationshipIdentity = relationshipMemberMapper.createEntity();
            IdentityType identityType = (IdentityType)prop.getValue((Object)relationship);
            if (identityType != null) {
                Property identityTypeProperty = relationshipMemberMapper.getProperty(RelationshipMember.class).getValue();
                if (identityTypeProperty.getJavaClass().equals(String.class)) {
                    identityTypeProperty.setValue(relationshipIdentity, (Object)IdentityTypeUtil.formatId(identityType));
                } else {
                    identityTypeProperty.setValue(relationshipIdentity, this.getRootEntity((AttributedType)identityType, entityManager));
                }
                Property descriptorProperty = relationshipMemberMapper.getProperty(RelationshipDescriptor.class).getValue();
                Property ownerProperty = relationshipMemberMapper.getProperty(OwnerReference.class).getValue();
                descriptorProperty.setValue(relationshipIdentity, (Object)prop.getName());
                ownerProperty.setValue(relationshipIdentity, ownerEntity);
            }
            entityManager.persist(relationshipIdentity);
        }
    }

    private void configureEntityMapper(Class<?> entityType) {
        Class ownerClass;
        EntityMapper entityMapper = new EntityMapper(entityType, this);
        Map.Entry<Property, Property> ownerProperty = entityMapper.getProperty(OwnerReference.class);
        if (ownerProperty != null && !String.class.equals((Object)(ownerClass = ownerProperty.getValue().getJavaClass())) && ((JPAIdentityStoreConfiguration)this.getConfig()).getEntityTypes().contains(ownerClass)) {
            this.configureEntityMapper(ownerClass);
        }
        if (entityType.getSuperclass().isAnnotationPresent(IdentityManaged.class)) {
            this.configureEntityMapper(entityType.getSuperclass());
        }
        if (!this.entityMappers.contains(entityMapper)) {
            this.entityMappers.add(entityMapper);
        }
    }

    private EntityManager getEntityManager(IdentityContext context) {
        EntityManager entityManager = (EntityManager)context.getParameter(INVOCATION_CTX_ENTITY_MANAGER);
        if (entityManager == null) {
            throw IDMInternalMessages.MESSAGES.storeJpaCouldNotGetEntityManagerFromStoreContext();
        }
        return entityManager;
    }

    private void logEntityMappers() {
        if (IDMInternalLog.JPA_STORE_LOGGER.isDebugEnabled()) {
            IDMInternalLog.JPA_STORE_LOGGER.debug("Supported EntityMappers: [");
            for (EntityMapper entityMapper : this.entityMappers) {
                IDMInternalLog.JPA_STORE_LOGGER.debugf(" %s: [", entityMapper.getEntityType());
                IDMInternalLog.JPA_STORE_LOGGER.debugf("  Is root: %s", entityMapper.isRoot());
                IDMInternalLog.JPA_STORE_LOGGER.debugf("  Mappings: [", new Object[0]);
                for (EntityMapping entityMapping : entityMapper.getEntityMappings()) {
                    IDMInternalLog.JPA_STORE_LOGGER.debugf("   %s: ", entityMapping.getSupportedType());
                    IDMInternalLog.JPA_STORE_LOGGER.debugf("    Owner Type: %s", entityMapping.getOwnerType());
                    if (entityMapping.getTypeProperty() != null) {
                        IDMInternalLog.JPA_STORE_LOGGER.debugf("    Has type property: %s", entityMapping.getTypeProperty().getName());
                    }
                    for (Property property : entityMapping.getProperties().keySet()) {
                        IDMInternalLog.JPA_STORE_LOGGER.debugf("     Property: %s, %s", property.getName(), property.getJavaClass());
                        Property mappedProperty = entityMapping.getProperties().get(property);
                        if (mappedProperty == null) continue;
                        StringBuffer propertyAnnotations = new StringBuffer();
                        for (Annotation annotation : mappedProperty.getAnnotatedElement().getAnnotations()) {
                            if (propertyAnnotations.length() != 0) {
                                propertyAnnotations.append(",");
                            }
                            propertyAnnotations.append(annotation.annotationType());
                        }
                        IDMInternalLog.JPA_STORE_LOGGER.debugf("      Mapped Property: %s, %s, annotations [%s]", mappedProperty.getName(), mappedProperty.getJavaClass(), propertyAnnotations);
                    }
                }
                IDMInternalLog.JPA_STORE_LOGGER.debugf("   ]", new Object[0]);
                IDMInternalLog.JPA_STORE_LOGGER.debugf("  ]", new Object[0]);
                IDMInternalLog.JPA_STORE_LOGGER.debug(" ]");
            }
            IDMInternalLog.JPA_STORE_LOGGER.debug("]");
        }
    }

    private EntityMapper getPermissionMapperForResource(Class resourceClass) {
        int score = -1;
        EntityMapper mapper = null;
        for (EntityMapper entityMapper : this.getEntityMappers()) {
            Class supportedType;
            EntityMapping mapping;
            if (!entityMapper.getEntityType().isAnnotationPresent(PermissionManaged.class) || (mapping = entityMapper.getMappingsFor(resourceClass)) == null || !(supportedType = mapping.getSupportedType()).isAssignableFrom(resourceClass)) continue;
            int currentScore = 0;
            Class currentClass = resourceClass;
            while (!currentClass.equals(supportedType) && !Object.class.equals((Object)currentClass)) {
                ++currentScore;
                currentClass = currentClass.getSuperclass();
            }
            if (mapper != null && score != -1 && currentScore >= score) continue;
            score = currentScore;
            mapper = entityMapper;
        }
        if (mapper == null) {
            throw IDMInternalMessages.MESSAGES.configJpaStoreNoPermissionEntityClassProvided();
        }
        return mapper;
    }

    private List<EntityMapper> getPermissionMappers() {
        ArrayList<EntityMapper> mappers = new ArrayList<EntityMapper>();
        for (EntityMapper entityMapper : this.getEntityMappers()) {
            if (!entityMapper.getEntityType().isAnnotationPresent(PermissionManaged.class)) continue;
            mappers.add(entityMapper);
        }
        if (mappers == null) {
            throw IDMInternalMessages.MESSAGES.configJpaStoreNoPermissionEntityClassProvided();
        }
        return mappers;
    }

    public List<Permission> listPermissions(IdentityContext ctx, Object resource) {
        return this.listPermissions(ctx, resource, null);
    }

    public List<Permission> listPermissions(IdentityContext ctx, IdentityType identityType) {
        return this.listPermissions(ctx, new IdentityPermission(null, identityType, null));
    }

    public List<Permission> listPermissions(IdentityContext ctx, Object resource, String operation) {
        return this.listPermissions(ctx, new IdentityPermission(resource, null, operation));
    }

    public List<Permission> listPermissions(IdentityContext ctx, Set<Object> resources, String operation) {
        ArrayList<Permission> perms = new ArrayList<Permission>();
        for (Object resource : resources) {
            perms.addAll(this.listPermissions(ctx, resource, operation));
        }
        return perms;
    }

    public List<Permission> listPermissions(IdentityContext ctx, Class<?> resourceClass, Serializable identifier) {
        return this.listPermissions(ctx, resourceClass, identifier, null);
    }

    public List<Permission> listPermissions(IdentityContext ctx, Class<?> resourceClass, Serializable identifier, String operation) {
        return this.listPermissions(ctx, new IdentityPermission(resourceClass, identifier, null, operation));
    }

    public List<Permission> listPermissions(IdentityContext ctx, IdentityPermission query) {
        EntityManager em = this.getEntityManager(ctx);
        ArrayList<EntityMapper> mappers = new ArrayList<EntityMapper>();
        Object resource = query.getResource();
        Class resourceClass = query.getResourceClass();
        Serializable resourceIdentifier = query.getResourceIdentifier();
        if (resource != null) {
            resourceClass = ctx.getPermissionHandlerPolicy().getResourceClass(resource);
            resourceIdentifier = ctx.getPermissionHandlerPolicy().getIdentifier(resource);
        }
        if (resourceClass != null) {
            mappers.add(this.getPermissionMapperForResource(resourceClass));
        } else {
            mappers.addAll(this.getPermissionMappers());
        }
        ArrayList<Permission> perms = new ArrayList<Permission>();
        for (EntityMapper mapper : mappers) {
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(mapper.getEntityType());
            Root from = cq.from(mapper.getEntityType());
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            Property resourceClassProperty = mapper.getProperty(PermissionResourceClass.class).getValue();
            Property resourceIdentifierProperty = mapper.getProperty(PermissionResourceIdentifier.class).getValue();
            Property ownerProperty = mapper.getProperty(OwnerReference.class).getValue();
            if (resourceClass != null) {
                predicates.add(cb.equal((Expression)from.get(resourceClassProperty.getName()), (Object)resourceClass.getName()));
            }
            if (resourceIdentifier != null) {
                predicates.add(cb.equal((Expression)from.get(resourceIdentifierProperty.getName()), (Object)resourceIdentifier.toString()));
            }
            if (query.getAssignee() != null) {
                IdentityType assignee = query.getAssignee();
                if (String.class.equals((Object)ownerProperty.getBaseType())) {
                    predicates.add(from.get(ownerProperty.getName()).in(new Object[]{assignee.getId(), IdentityTypeUtil.formatId(assignee)}));
                } else {
                    predicates.add(cb.equal((Expression)from.get(ownerProperty.getName()), this.getOwnerEntity((AttributedType)assignee, ownerProperty, em)));
                }
            }
            cq.where(predicates.toArray(new Predicate[predicates.size()]));
            List results = em.createQuery(cq).getResultList();
            for (Object result : results) {
                Object ownerIdentityType;
                Object owner;
                block19: {
                    block18: {
                        owner = ownerProperty.getValue(result);
                        ownerIdentityType = null;
                        if (!String.class.equals(owner.getClass())) break block18;
                        ownerIdentityType = this.lookupIdentityTypeById(ctx, IdentityType.class, (String)owner);
                        if (ownerIdentityType != null) break block19;
                        ownerIdentityType = new IdentityTypeReference((String)owner);
                        break block19;
                    }
                    for (EntityMapper entityMapper : this.getEntityMappers()) {
                        IdentityType identityType;
                        if (entityMapper.getMappingsFor(IdentityType.class) == null || !entityMapper.isRoot() || (identityType = (IdentityType)entityMapper.createType(owner, em)) == null) continue;
                        ownerIdentityType = identityType;
                        break;
                    }
                }
                if (ownerIdentityType == null) {
                    throw new IdentityManagementException(String.format("Could not determine permission assignee [%s] for resource class [%s] with resourceIdentifier [%s]", owner, resourceClass, resourceIdentifier));
                }
                Class actualResourceClass = resourceClass;
                if (actualResourceClass == null) {
                    try {
                        actualResourceClass = Reflections.classForName((String)((String)resourceClassProperty.getValue(result)), (ClassLoader[])new ClassLoader[0]);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IdentityManagementException("Could not load type.", (Throwable)e);
                    }
                }
                PermissionOperationSet opSet = new PermissionOperationSet(result, actualResourceClass, mapper);
                String operation = query.getOperation();
                Set<String> operationsToreturn = operation != null ? PermissionUtil.asOperationList(operation) : opSet.getOperations();
                for (String op : operationsToreturn) {
                    for (String operationPermission : opSet.getOperations()) {
                        if (!op.equals(operationPermission)) continue;
                        if (resource != null) {
                            perms.add((Permission)new IdentityPermission(resource, ownerIdentityType, op));
                            continue;
                        }
                        perms.add((Permission)new IdentityPermission(actualResourceClass, (Serializable)resourceIdentifierProperty.getValue(result), ownerIdentityType, op));
                    }
                }
            }
        }
        return perms;
    }

    private Object lookupPermissionEntity(IdentityContext ctx, EntityMapper mapper, IdentityType assignee, Class<?> resourceClass, Serializable identifier) {
        EntityManager em = this.getEntityManager(ctx);
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(mapper.getEntityType());
        Root from = cq.from(mapper.getEntityType());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Property resourceClassProperty = mapper.getProperty(PermissionResourceClass.class).getValue();
        Property resourceIdentifierProperty = mapper.getProperty(PermissionResourceIdentifier.class).getValue();
        Property ownerProperty = mapper.getProperty(OwnerReference.class).getValue();
        if (String.class.equals((Object)ownerProperty.getBaseType())) {
            predicates.add(from.get(ownerProperty.getName()).in(new Object[]{assignee.getId(), IdentityTypeUtil.formatId(assignee)}));
        } else {
            predicates.add(cb.equal((Expression)from.get(ownerProperty.getName()), this.getOwnerEntity((AttributedType)assignee, ownerProperty, em)));
        }
        predicates.add(cb.equal((Expression)from.get(resourceClassProperty.getName()), (Object)resourceClass.getName()));
        if (identifier != null && !identifier.equals(resourceClass.getName())) {
            predicates.add(cb.equal((Expression)from.get(resourceIdentifierProperty.getName()), (Object)identifier.toString()));
        }
        cq.where(predicates.toArray(new Predicate[predicates.size()]));
        TypedQuery query = em.createQuery(cq);
        query.setMaxResults(1);
        try {
            return query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public boolean grantPermission(IdentityContext context, IdentityType assignee, Object resource, String operation) {
        EntityManager em = this.getEntityManager(context);
        Class resourceClass = context.getPermissionHandlerPolicy().getResourceClass(resource);
        Serializable resourceIdentifier = context.getPermissionHandlerPolicy().getIdentifier(resource);
        if (resourceIdentifier == null) {
            throw new IdentityManagementException(String.format("No identifier value could be generated for resource [%s]", resource));
        }
        EntityMapper mapper = this.getPermissionMapperForResource(resourceClass);
        Object entity = this.lookupPermissionEntity(context, mapper, assignee, resourceClass, resourceIdentifier);
        if (entity == null) {
            Property resourceClassProperty = mapper.getProperty(PermissionResourceClass.class).getValue();
            Property resourceIdentifierProperty = mapper.getProperty(PermissionResourceIdentifier.class).getValue();
            Property ownerProperty = mapper.getProperty(OwnerReference.class).getValue();
            try {
                entity = mapper.getEntityType().newInstance();
                if (String.class.equals((Object)ownerProperty.getBaseType())) {
                    ownerProperty.setValue(entity, (Object)IdentityTypeUtil.formatId(assignee));
                } else {
                    Object identityEntity = this.getOwnerEntity((AttributedType)assignee, ownerProperty, em);
                    ownerProperty.setValue(entity, identityEntity);
                }
                resourceClassProperty.setValue(entity, (Object)context.getPermissionHandlerPolicy().getResourceClass(resource).getName());
                resourceIdentifierProperty.setValue(entity, (Object)resourceIdentifier.toString());
                PermissionOperationSet operationSet = new PermissionOperationSet(entity, resourceClass, mapper);
                operationSet.appendOperation(operation);
                em.persist(entity);
                return true;
            }
            catch (Exception ex) {
                throw new IdentityManagementException("Error persisting permission", (Throwable)ex);
            }
        }
        PermissionOperationSet operationSet = new PermissionOperationSet(entity, resourceClass, mapper);
        operationSet.appendOperation(operation);
        em.merge(entity);
        return true;
    }

    public boolean revokePermission(IdentityContext context, IdentityType assignee, Object resource, String operation) {
        EntityManager em = this.getEntityManager(context);
        ArrayList<EntityMapper> mappers = new ArrayList<EntityMapper>();
        Class resourceClass = context.getPermissionHandlerPolicy().getResourceClass(resource);
        Serializable resourceIdentifier = context.getPermissionHandlerPolicy().getIdentifier(resource);
        if (resourceClass != null) {
            mappers.add(this.getPermissionMapperForResource(resourceClass));
        } else {
            mappers.addAll(this.getPermissionMappers());
        }
        for (EntityMapper mapper : mappers) {
            Object entity = this.lookupPermissionEntity(context, mapper, assignee, resourceClass, resourceIdentifier);
            if (entity == null) continue;
            PermissionOperationSet operationSet = new PermissionOperationSet(entity, resourceClass, mapper);
            operationSet.removeOperation(operation);
            Set<String> operations = operationSet.getOperations();
            if (operations.isEmpty()) {
                em.remove(entity);
            } else {
                em.merge(entity);
            }
            return true;
        }
        return false;
    }

    public void revokeAllPermissions(IdentityContext ctx, Object resource) {
        EntityManager em = this.getEntityManager(ctx);
        EntityMapper mapper = this.getPermissionMapperForResource(resource.getClass());
        Property resourceClassProperty = mapper.getProperty(PermissionResourceClass.class).getValue();
        Property resourceIdentifierProperty = mapper.getProperty(PermissionResourceIdentifier.class).getValue();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(mapper.getEntityType());
        Root from = cq.from(mapper.getEntityType());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(cb.equal((Expression)from.get(resourceClassProperty.getName()), (Object)ctx.getPermissionHandlerPolicy().getResourceClass(resource).getName()));
        predicates.add(cb.equal((Expression)from.get(resourceIdentifierProperty.getName()), (Object)ctx.getPermissionHandlerPolicy().getIdentifier(resource).toString()));
        cq.where(predicates.toArray(new Predicate[predicates.size()]));
        List results = em.createQuery(cq).getResultList();
        for (Object result : results) {
            em.remove(result);
        }
    }

    private void validateConfiguration() {
        Set<Class<? extends AttributedType>> supportedTypes = ((JPAIdentityStoreConfiguration)this.getConfig()).getSupportedTypes().keySet();
        this.validateTypeMapping(supportedTypes);
        this.validateAttributeMapping();
        this.validateCredentialMapping();
    }

    private void validateCredentialMapping() {
        if (((JPAIdentityStoreConfiguration)this.getConfig()).supportsCredential()) {
            for (EntityMapper entityMapper : this.getEntityMappers()) {
                ManagedCredential managedCredential = entityMapper.getEntityType().getAnnotation(ManagedCredential.class);
                if (managedCredential == null) continue;
                this.checkIfAnnotationIsDefinedForCredential(entityMapper, CredentialClass.class);
                this.checkIfAnnotationIsDefinedForCredential(entityMapper, EffectiveDate.class);
                this.checkIfAnnotationIsDefinedForCredential(entityMapper, ExpiryDate.class);
                return;
            }
            throw IDMInternalMessages.MESSAGES.configJpaStoreMappedNoCredentialStorageMappingFound();
        }
    }

    private void validateAttributeMapping() {
        if (((JPAIdentityStoreConfiguration)this.getConfig()).supportsAttribute()) {
            for (EntityMapper entityMapper : this.getEntityMappers()) {
                if (entityMapper.getProperty(AttributeClass.class) == null) continue;
                this.checkIfAnnotationIsDefinedForAttribute(entityMapper, AttributeName.class);
                this.checkIfAnnotationIsDefinedForAttribute(entityMapper, AttributeValue.class);
                this.checkIfAnnotationIsDefinedForAttribute(entityMapper, OwnerReference.class);
                return;
            }
            throw IDMInternalMessages.MESSAGES.configJpaStoreMappedNoAttributeMappingFound();
        }
    }

    private void validateTypeMapping(Set<Class<? extends AttributedType>> supportedTypes) {
        for (Class<? extends AttributedType> supportedType : supportedTypes) {
            if (Relationship.class.equals(supportedType) || Partition.class.equals(supportedType) || IdentityType.class.equals(supportedType) || Account.class.equals(supportedType)) continue;
            this.checkIfAnnotationIsDefined(supportedType, Identifier.class);
            if (Partition.class.isAssignableFrom(supportedType)) {
                this.checkIfAnnotationIsDefined(supportedType, PartitionClass.class);
            }
            if (IdentityType.class.isAssignableFrom(supportedType)) {
                this.checkIfAnnotationIsDefined(supportedType, IdentityClass.class);
                if (((JPAIdentityStoreConfiguration)this.getConfig()).supportsPartition()) {
                    this.checkIfAnnotationIsDefined(supportedType, OwnerReference.class);
                }
            }
            if (!Relationship.class.isAssignableFrom(supportedType)) continue;
            this.checkIfAnnotationIsDefined(supportedType, RelationshipClass.class);
            this.checkIfAnnotationIsDefined(supportedType, RelationshipDescriptor.class);
            this.checkIfAnnotationIsDefined(supportedType, RelationshipMember.class);
            this.checkIfAnnotationIsDefined(supportedType, OwnerReference.class);
        }
    }

    private void checkIfAnnotationIsDefined(Class<? extends AttributedType> attributedType, Class<? extends Annotation> annotation) throws SecurityConfigurationException {
        if (this.getEntityMapperForProperty(attributedType, annotation) == null) {
            throw IDMInternalMessages.MESSAGES.configJpaStoreRequiredMappingAnnotationForAttributedType(attributedType, annotation);
        }
    }

    private void checkIfAnnotationIsDefinedForAttribute(EntityMapper mapper, Class<? extends Annotation> annotation) throws SecurityConfigurationException {
        if (mapper.getProperty(annotation) == null) {
            throw IDMInternalMessages.MESSAGES.configJpaStoreRequiredMappingAnnotation(mapper.getEntityType(), annotation);
        }
    }

    private void checkIfAnnotationIsDefinedForCredential(EntityMapper mapper, Class<? extends Annotation> annotation) throws SecurityConfigurationException {
        if (mapper.getProperty(annotation) == null) {
            throw IDMInternalMessages.MESSAGES.configJpaStoreRequiredMappingAnnotation(mapper.getEntityType(), annotation);
        }
    }

    protected class PermissionOperationSet {
        private EntityMapper mapper;
        private AllowedOperations perms;
        private Object entity;
        private Class resourceClass;

        public PermissionOperationSet(Object entity, Class resourceClass, EntityMapper mapper) {
            this.entity = entity;
            this.mapper = mapper;
            this.resourceClass = resourceClass;
            this.perms = resourceClass.getAnnotation(AllowedOperations.class);
        }

        public void appendOperation(String operation) {
            this.adjustOperation(operation, true);
        }

        public void removeOperation(String operation) {
            this.adjustOperation(operation, false);
        }

        private String adjustCSVOperation(String operations, String operation, boolean mode) {
            String operationsCSV = mode ? PermissionUtil.addOperation(operations, operation) : PermissionUtil.removeOperation(operations, operation);
            return operationsCSV;
        }

        public Set<String> getOperations() {
            Object opValue = this.mapper.getProperty(PermissionOperation.class).getValue().getValue(this.entity);
            HashSet<String> operations = new HashSet<String>();
            if (this.perms != null) {
                try {
                    long ops = opValue != null ? Long.valueOf(opValue.toString()) : 0L;
                    for (AllowedOperation o : this.perms.value()) {
                        if (o.mask() <= 0L || (o.mask() & ops) == 0L) continue;
                        operations.add(o.value());
                    }
                    return operations;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            for (String op : ((String)opValue).split(",")) {
                if (StringUtil.isNullOrEmpty((String)op)) continue;
                operations.add(op);
            }
            return operations;
        }

        private void adjustOperation(String operation, boolean mode) {
            Object operations = this.mapper.getProperty(PermissionOperation.class).getValue().getValue(this.entity);
            if (operations == null) {
                operations = "";
            }
            Object newOperations = operation;
            if (this.perms != null && this.perms.value().length > 0) {
                AllowedOperation perm = null;
                long ops = operations == null || StringUtil.isNullOrEmpty((String)operations.toString()) ? 0L : Long.valueOf(operations.toString());
                for (String op : PermissionUtil.asOperationList(operation)) {
                    for (AllowedOperation o : this.perms.value()) {
                        if (!o.value().equals(op)) continue;
                        perm = o;
                        break;
                    }
                    if (perm == null) {
                        throw new IllegalArgumentException(String.format("Attempted to set illegal permission operation [%s] for resource [%s]", op, this.resourceClass));
                    }
                    if (perm != null && perm.mask() > 0L) {
                        ops = mode ? (ops |= perm.mask()) : (ops ^= perm.mask());
                    }
                    newOperations = ops;
                }
            } else {
                newOperations = this.adjustCSVOperation(operations.toString(), newOperations.toString(), mode);
            }
            this.mapper.getProperty(PermissionOperation.class).getValue().setValue(this.entity, (Object)newOperations.toString());
        }
    }
}

