/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config.internal.resolver;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import org.picketlink.common.reflection.Reflections;
import org.picketlink.config.idm.ObjectType;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.internal.XMLBasedIdentityManagerProvider;
import org.picketlink.idm.config.internal.resolver.BasePropertyResolver;

public abstract class PrimitivePropertyResolver<V>
extends BasePropertyResolver<V> {
    @Override
    protected V resolvePropertyFromObjectType(ObjectType objectType) {
        throw new SecurityConfigurationException("Not implemented");
    }

    public static class PropertyEditorDelegateResolver
    extends PrimitivePropertyResolver<Object> {
        @Override
        protected Object resolvePropertyFromString(String propertyValue, Class<Object> propertyClass) {
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(propertyClass);
            propertyEditor.setAsText(propertyValue);
            return propertyClass.cast(propertyEditor.getValue());
        }
    }

    public static class ClassResolver
    extends PrimitivePropertyResolver<Class> {
        @Override
        protected Class resolvePropertyFromString(String propertyValue, Class<Class> propertyClass) {
            try {
                return Reflections.classForName((String)propertyValue, (ClassLoader[])new ClassLoader[]{XMLBasedIdentityManagerProvider.IDM_CLASSLOADER});
            }
            catch (ClassNotFoundException cnfe) {
                throw new SecurityConfigurationException((Throwable)cnfe);
            }
        }
    }

    public static class StringResolver
    extends PrimitivePropertyResolver<String> {
        @Override
        protected String resolvePropertyFromString(String propertyValue, Class<String> propertyClass) {
            return propertyValue;
        }
    }
}

