/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.file.internal.FileBasedIdentityStore;
import org.picketlink.idm.file.internal.FileDataSource;
import org.picketlink.idm.file.internal.FileIdentityStoreConfiguration;
import org.picketlink.idm.file.internal.FilePartition;
import org.picketlink.idm.file.internal.FileUtils;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.PartitionStore;

public class FilePartitionStore
implements PartitionStore {
    private FileBasedIdentityStore identityStore;

    public FilePartitionStore(FileBasedIdentityStore identityStore) {
        this.identityStore = identityStore;
        if (this.getRealm("default") == null) {
            this.createDefaultRealm();
        }
    }

    public void createPartition(Partition partition) {
        if (Realm.class.isInstance(partition) && this.getRealm(partition.getName()) != null) {
            throw new IdentityManagementException("A Realm with name [" + partition.getName() + "] already exists.");
        }
        if (Tier.class.isInstance(partition) && this.getTier(partition.getName()) != null) {
            throw new IdentityManagementException("A Tier with name [" + partition.getName() + "] already exists.");
        }
        partition.setId(this.getContext().getIdGenerator().generate());
        FilePartition filePartition = new FilePartition(partition);
        this.getDataSource().getPartitions().put(filePartition.getId(), filePartition);
        this.getDataSource().initPartition(partition.getId());
        this.getPartitions().put(partition.getId(), filePartition);
        this.getDataSource().flushPartitions();
    }

    public void removePartition(Partition partition) {
        String id = partition.getId();
        if (this.getPartitions().containsKey(partition.getId())) {
            FilePartition filePartition = this.getDataSource().getPartition(partition.getId());
            if (!(filePartition.getAgents().isEmpty() && filePartition.getRoles().isEmpty() && filePartition.getGroups().isEmpty())) {
                throw new IdentityManagementException("Realm could not be removed. There IdentityTypes associated with it. Remove them first.");
            }
        } else {
            throw new IdentityManagementException("No Partition found with the given id [" + id + "].");
        }
        FileUtils.delete(new File(this.getDataSource().getWorkingDir() + File.separator + partition.getId()));
        this.getPartitions().remove(partition.getId());
        this.getDataSource().flushPartitions();
    }

    public Realm getRealm(String name) {
        Collection<FilePartition> partitions = this.getPartitions().values();
        Realm realm = null;
        for (FilePartition partition : partitions) {
            if (!Realm.class.isInstance(partition.getPartition()) || !partition.getPartition().getName().equals(name)) continue;
            realm = (Realm)partition.getPartition();
            break;
        }
        return realm;
    }

    private void createDefaultRealm() {
        this.createPartition((Partition)new Realm("default"));
    }

    public Tier getTier(String name) {
        Collection<FilePartition> partitions = this.getPartitions().values();
        for (FilePartition partition : partitions) {
            Tier tier;
            if (!Tier.class.isInstance(partition.getPartition()) || !(tier = (Tier)partition.getPartition()).getName().equals(name)) continue;
            if (tier.getParent() != null) {
                tier.setParent(this.getTier(tier.getParent().getName()));
            }
            return tier;
        }
        return null;
    }

    private FileIdentityStoreConfiguration getConfig() {
        return this.identityStore.getConfig();
    }

    private IdentityStoreInvocationContext getContext() {
        return this.identityStore.getContext();
    }

    private FileDataSource getDataSource() {
        return this.getConfig().getDataSource();
    }

    private Map<String, FilePartition> getPartitions() {
        return this.getDataSource().getPartitions();
    }

    public Partition lookupById(String id) {
        return this.getPartitions().get(id).getPartition();
    }
}

