/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.internal.DigestCredentialHandler;
import org.picketlink.idm.credential.internal.PasswordCredentialHandler;
import org.picketlink.idm.credential.internal.X509CertificateCredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.CredentialHandlers;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.jpa.annotations.IDMAttribute;
import org.picketlink.idm.jpa.annotations.PropertyType;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.JPACredentialStore;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStoreConfiguration;
import org.picketlink.idm.jpa.internal.JPAPartitionStore;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.model.User;
import org.picketlink.idm.model.annotation.RelationshipAttribute;
import org.picketlink.idm.model.annotation.RelationshipIdentity;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.RelationshipQueryParameter;
import org.picketlink.idm.query.internal.DefaultIdentityQuery;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.PartitionStore;

@CredentialHandlers(value={PasswordCredentialHandler.class, X509CertificateCredentialHandler.class, DigestCredentialHandler.class})
public class JPAIdentityStore
implements IdentityStore<JPAIdentityStoreConfiguration>,
CredentialStore,
PartitionStore {
    public static final String INVOCATION_CTX_ENTITY_MANAGER = "CTX_ENTITY_MANAGER";
    public static final String EVENT_CONTEXT_USER_ENTITY = "USER_ENTITY";
    public static final String EVENT_CONTEXT_GROUP_ENTITY = "GROUP_ENTITY";
    public static final String EVENT_CONTEXT_ROLE_ENTITY = "ROLE_ENTITY";
    private JPAIdentityStoreConfiguration config;
    private IdentityStoreInvocationContext context;
    private JPAPartitionStore partitionStore;
    private JPACredentialStore credentialStore;

    public void setup(JPAIdentityStoreConfiguration config, IdentityStoreInvocationContext context) {
        this.config = config;
        this.context = context;
        this.partitionStore = new JPAPartitionStore(this);
        this.credentialStore = new JPACredentialStore(this);
        if (this.context.getRealm() == null) {
            this.context.setRealm(this.getRealm("default"));
        }
    }

    public JPAIdentityStoreConfiguration getConfig() {
        return this.config;
    }

    public IdentityStoreInvocationContext getContext() {
        return this.context;
    }

    public void add(AttributedType value) {
        if (value == null) {
            throw new IllegalArgumentException("value passed to IdentityStore.add() may not be null");
        }
        if (value instanceof IdentityType) {
            IdentityType identityType = (IdentityType)value;
            try {
                IdentityTypeHandler<IdentityType> handler = this.getConfig().getHandler(identityType.getClass());
                handler.validate(identityType, this);
                Object entity = handler.createEntity(identityType, this);
                EntityManager em = this.getEntityManager();
                em.persist(entity);
                em.flush();
                this.updateIdentityTypeAttributes(identityType, entity);
                AbstractBaseEvent event = handler.raiseCreatedEvent(identityType);
                event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, entity);
                this.getContext().getEventBridge().raiseEvent((Object)event);
            }
            catch (Exception ex) {
                throw new IdentityManagementException("Exception while creating IdentityType [" + identityType + "].", (Throwable)ex);
            }
        }
        if (value instanceof Relationship) {
            if (this.getConfig().getRelationshipClass() == null) {
                throw new IdentityManagementException("No Relationship Entity class was provided. Relationships can not be stored.");
            }
            Relationship relationship = (Relationship)value;
            try {
                this.addRelationship(relationship);
                if (GroupRole.class.isInstance(relationship)) {
                    GroupRole groupRole = (GroupRole)relationship;
                    this.addRelationship((Relationship)new Grant(groupRole.getMember(), groupRole.getRole()));
                    this.addRelationship((Relationship)new GroupMembership(groupRole.getMember(), groupRole.getGroup()));
                }
            }
            catch (Exception ex) {
                throw new IdentityManagementException("Exception while creating Relationship [" + relationship + "].", (Throwable)ex);
            }
        }
    }

    private void addRelationship(Relationship relationship) {
        relationship.setId(this.getContext().getIdGenerator().generate());
        Object entity = null;
        try {
            entity = this.getConfig().getRelationshipClass().newInstance();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error instantiating relationship class [" + this.getConfig().getRelationshipClass().getName() + "]", (Throwable)e);
        }
        this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ID).setValue(entity, (Object)relationship.getId());
        this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_CLASS).setValue(entity, (Object)relationship.getClass().getName());
        List props = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(RelationshipIdentity.class)).getResultList();
        EntityManager em = this.getEntityManager();
        em.persist(entity);
        for (Property prop : props) {
            Object relationshipIdentity = null;
            try {
                relationshipIdentity = this.getConfig().getRelationshipIdentityClass().newInstance();
            }
            catch (Exception e) {
                throw new IdentityManagementException("Error instantiating relationship identity class [" + this.getConfig().getRelationshipIdentityClass().getName() + "]", (Throwable)e);
            }
            IdentityType identityType = (IdentityType)prop.getValue((Object)relationship);
            this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY).setValue(relationshipIdentity, this.lookupIdentityObjectById(identityType.getId()));
            this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_DESCRIPTOR).setValue(relationshipIdentity, (Object)prop.getName());
            this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP).setValue(relationshipIdentity, entity);
            em.persist(relationshipIdentity);
        }
        this.updateRelationshipAttributes(relationship, entity);
    }

    public void createPartition(Partition partition) {
        this.partitionStore.createPartition(partition);
    }

    public Realm getRealm(String realmName) {
        return this.partitionStore.getRealm(realmName);
    }

    public Tier getTier(String tierName) {
        return this.partitionStore.getTier(tierName);
    }

    public void removePartition(Partition partition) {
        this.partitionStore.removePartition(partition);
    }

    public void update(AttributedType value) {
        if (value == null) {
            throw new IllegalArgumentException("value passed to IdentityStore.update() may not be null");
        }
        if (value instanceof IdentityType) {
            IdentityType identityType = (IdentityType)value;
            Object entity = this.lookupIdentityObjectById(identityType.getId());
            if (entity == null) {
                throw new IdentityManagementException("The specified identity object [" + identityType.getId() + "] does not exist.");
            }
            IdentityTypeHandler<IdentityType> handler = this.getConfig().getHandler(identityType.getClass());
            handler.populateEntity(entity, identityType, this);
            this.updateIdentityTypeAttributes(identityType, entity);
            EntityManager em = this.getEntityManager();
            em.merge(entity);
            em.flush();
            AbstractBaseEvent event = handler.raiseUpdatedEvent(identityType);
            event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, entity);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else if (value instanceof Relationship) {
            Relationship relationship = (Relationship)value;
            Object entity = this.lookupRelationshipObjectById(relationship.getId());
            if (entity == null) {
                throw new IdentityManagementException("The specified relationship object [" + relationship.getId() + "] does not exist.");
            }
            this.updateRelationshipAttributes(relationship, entity);
            EntityManager em = this.getEntityManager();
            em.merge(entity);
            em.flush();
        }
    }

    public void remove(AttributedType value) {
        if (value instanceof IdentityType) {
            IdentityType identityType = (IdentityType)value;
            Object entity = this.lookupIdentityObjectById(identityType.getId());
            if (entity == null) {
                throw new IdentityManagementException("The specified identity object [" + identityType.getId() + "] does not exist.");
            }
            EntityManager em = this.getEntityManager();
            IdentityTypeHandler<IdentityType> handler = this.getConfig().getHandler(identityType.getClass());
            handler.remove(entity, identityType, this);
            this.credentialStore.removeCredentials(entity);
            this.removeIdentityTypeAttributes(entity);
            this.removeIdentityTypeRelationships(entity);
            em.remove(entity);
            em.flush();
            AbstractBaseEvent event = handler.raiseDeletedEvent(identityType);
            event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, entity);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else if (value instanceof Relationship) {
            Object[] attributes;
            Relationship relationship = (Relationship)value;
            Object entity = this.lookupRelationshipObjectById(relationship.getId());
            if (entity == null) {
                throw new IdentityManagementException("The specified relationship object [" + relationship.getId() + "] does not exist.");
            }
            List<?> childRelationships = this.findChildRelationships(relationship);
            EntityManager em = this.getEntityManager();
            for (Object object : childRelationships) {
                em.remove(object);
            }
            for (Object object : attributes = relationship.getAttributes().toArray()) {
                Attribute attribute = (Attribute)object;
                relationship.removeAttribute(attribute.getName());
            }
            this.removeAttributes(relationship, entity);
            em.remove(entity);
            em.flush();
        }
    }

    private List<?> findChildRelationships(Relationship relationship) {
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getRelationshipIdentityClass());
        Root root = criteria.from(this.getConfig().getRelationshipIdentityClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Join join = root.join(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP).getName());
        predicates.add(builder.equal((Expression)join.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ID).getName()), (Object)relationship.getId()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    public User getUser(String loginName) {
        if (loginName == null) {
            return null;
        }
        User user = this.getContext().getCache().lookupUser(this.context.getRealm(), loginName);
        if (user == null) {
            DefaultIdentityQuery<User> defaultIdentityQuery = new DefaultIdentityQuery<User>(User.class, this);
            defaultIdentityQuery.setParameter(User.LOGIN_NAME, loginName);
            List<User> resultList = defaultIdentityQuery.getResultList();
            if (!resultList.isEmpty()) {
                user = resultList.get(0);
            }
            this.getContext().getCache().putUser(this.context.getRealm(), user);
        }
        return user;
    }

    public Group getGroup(String groupPath) {
        if (groupPath == null) {
            return null;
        }
        if (groupPath.indexOf(47) == -1) {
            groupPath = "/" + groupPath;
        }
        Realm partition = this.context.getRealm();
        Group group = this.getContext().getCache().lookupGroup((Partition)partition, groupPath);
        if (group == null) {
            DefaultIdentityQuery<Group> defaultIdentityQuery = new DefaultIdentityQuery<Group>(Group.class, this);
            defaultIdentityQuery.setParameter(Group.PATH, groupPath);
            List<Group> resultList = defaultIdentityQuery.getResultList();
            if (!resultList.isEmpty()) {
                group = resultList.get(0);
            }
            this.getContext().getCache().putGroup((Partition)partition, group);
        }
        return group;
    }

    public Group getGroup(String name, Group parent) {
        if (name == null || parent == null) {
            return null;
        }
        String path = "/" + name;
        if (parent != null) {
            if (parent.getId() == null) {
                throw new IdentityManagementException("No identifier specified for the parent group.");
            }
            Object storedParent = this.lookupIdentityObjectById(parent.getId());
            if (storedParent == null || !this.getConfig().getModelProperty(PropertyType.IDENTITY_DISCRIMINATOR).getValue(storedParent).equals(this.getConfig().getIdentityTypeGroup())) {
                throw new IdentityManagementException("No parent group found with the given identifier [" + parent.getId() + "]");
            }
            path = this.getConfig().getModelProperty(PropertyType.GROUP_PATH).getValue(storedParent) + path;
        }
        return this.getGroup(path);
    }

    public Role getRole(String name) {
        if (name == null) {
            return null;
        }
        Realm partition = this.context.getRealm();
        Role role = this.getContext().getCache().lookupRole((Partition)partition, name);
        if (role == null) {
            DefaultIdentityQuery<Role> defaultIdentityQuery = new DefaultIdentityQuery<Role>(Role.class, this);
            defaultIdentityQuery.setParameter(Role.NAME, name);
            List<Role> resultList = defaultIdentityQuery.getResultList();
            if (!resultList.isEmpty()) {
                role = resultList.get(0);
            }
            this.getContext().getCache().putRole((Partition)partition, role);
        }
        return role;
    }

    public Agent getAgent(String loginName) {
        if (loginName == null) {
            return null;
        }
        Realm partition = this.context.getRealm();
        Object agent = this.getContext().getCache().lookupAgent(partition, loginName);
        if (agent == null) {
            DefaultIdentityQuery<Agent> defaultIdentityQuery = new DefaultIdentityQuery<Agent>(Agent.class, this);
            defaultIdentityQuery.setParameter(Agent.LOGIN_NAME, loginName);
            List<Agent> resultList = defaultIdentityQuery.getResultList();
            agent = !resultList.isEmpty() ? resultList.get(0) : this.getUser(loginName);
            this.getContext().getCache().putAgent(partition, agent);
        }
        return agent;
    }

    public <T extends Relationship> List<T> fetchQueryResults(RelationshipQuery<T> query) {
        ArrayList<T> result = new ArrayList<T>();
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getRelationshipClass());
        Root root = criteria.from(this.getConfig().getRelationshipClass());
        ArrayList<Object> predicates = new ArrayList<Object>();
        predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_CLASS).getName()), (Object)query.getRelationshipType().getName()));
        Property<Object> identityProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY);
        Property<Object> descriptorProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_DESCRIPTOR);
        Property<Object> relationshipProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP);
        Set parameters = query.getParameters().entrySet();
        for (Map.Entry entry : parameters) {
            QueryParameter queryParameter = (QueryParameter)entry.getKey();
            Object[] values = (Object[])entry.getValue();
            if (entry.getKey() instanceof RelationshipQueryParameter) {
                RelationshipQueryParameter identityTypeParameter = (RelationshipQueryParameter)entry.getKey();
                for (Object object : values) {
                    IdentityType identityType = (IdentityType)object;
                    if (identityType == null) continue;
                    Object identityObject = this.lookupIdentityObjectById(identityType.getId());
                    Subquery subquery = criteria.subquery(this.getConfig().getRelationshipIdentityClass());
                    Root fromProject = subquery.from(this.getConfig().getRelationshipIdentityClass());
                    subquery.select((Expression)fromProject.get(relationshipProperty.getName()));
                    Predicate conjunction = builder.conjunction();
                    conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(descriptorProperty.getName()), (Object)identityTypeParameter.getName()));
                    conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(identityProperty.getName()), identityObject));
                    subquery.where((Expression)conjunction);
                    predicates.add(builder.in((Expression)root).value((Expression)subquery));
                }
            }
            if (!(queryParameter instanceof AttributedType.AttributeParameter)) continue;
            AttributedType.AttributeParameter customParameter = (AttributedType.AttributeParameter)queryParameter;
            Subquery subquery = criteria.subquery(this.getConfig().getRelationshipAttributeClass());
            Root fromProject = subquery.from(this.getConfig().getRelationshipAttributeClass());
            subquery.select((Expression)fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_RELATIONSHIP).getName()));
            Predicate conjunction = builder.conjunction();
            conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_NAME).getName()), (Object)customParameter.getName()));
            conjunction.getExpressions().add(fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_VALUE).getName()).in(values));
            subquery.where((Expression)conjunction);
            subquery.groupBy(new Expression[]{subquery.getSelection()}).having((Expression)builder.equal(builder.count(subquery.getSelection()), (Object)values.length));
            predicates.add(builder.in((Expression)root).value((Expression)subquery));
        }
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List queryResult = em.createQuery(criteria).getResultList();
        for (Object relationshipObject : queryResult) {
            result.add(this.convertToRelationshipType(relationshipObject));
        }
        return result;
    }

    public <T extends IdentityType> List<T> fetchQueryResults(IdentityQuery<T> identityQuery) {
        ArrayList<T> result = new ArrayList<T>();
        try {
            EntityManager em = this.getEntityManager();
            JPACriteriaQueryBuilder criteriaBuilder = new JPACriteriaQueryBuilder(this, identityQuery);
            List<Predicate> predicates = criteriaBuilder.getPredicates();
            CriteriaQuery<?> criteria = criteriaBuilder.getCriteria();
            List<Order> orders = criteriaBuilder.getOrders();
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            criteria.orderBy(orders);
            TypedQuery query = em.createQuery(criteria);
            if (identityQuery.getLimit() > 0) {
                query.setMaxResults(identityQuery.getLimit());
                if (identityQuery.getOffset() > 0) {
                    query.setFirstResult(identityQuery.getOffset());
                }
            }
            List queryResult = query.getResultList();
            for (Object identity : queryResult) {
                result.add(this.convertToIdentityType(identity));
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error executing query.", (Throwable)e);
        }
        return result;
    }

    public <T extends IdentityType> int countQueryResults(IdentityQuery<T> identityQuery) {
        int limit = identityQuery.getLimit();
        int offset = identityQuery.getOffset();
        identityQuery.setLimit(0);
        identityQuery.setOffset(0);
        int resultCount = identityQuery.getResultList().size();
        identityQuery.setLimit(limit);
        identityQuery.setOffset(offset);
        return resultCount;
    }

    public void setAttribute(IdentityType identity, Attribute<? extends Serializable> providedAttrib) {
        throw new UnsupportedOperationException();
    }

    public void removeAttribute(IdentityType identity, String name) {
        throw new UnsupportedOperationException();
    }

    public <T extends Serializable> Attribute<T> getAttribute(IdentityType identityType, String attributeName) {
        throw new UnsupportedOperationException();
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(Agent agent, Class<T> storageClass) {
        return this.credentialStore.retrieveCredentials(agent, storageClass);
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(Agent agent, Class<T> storageClass) {
        return this.credentialStore.retrieveCurrentCredential(agent, storageClass);
    }

    public void storeCredential(Agent agent, CredentialStorage storage) {
        this.credentialStore.storeCredential(agent, storage);
    }

    public void updateCredential(Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        this.credentialStore.updateCredential(agent, credential, effectiveDate, expiryDate);
    }

    public void validateCredentials(Credentials credentials) {
        this.credentialStore.validateCredentials(credentials);
    }

    private <T extends Relationship> T convertToRelationshipType(Object relationshipObject) {
        Property<Object> identityProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY);
        Property<Object> idProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ID);
        Property<Object> descriptorProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_DESCRIPTOR);
        Property<Object> typeProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_CLASS);
        String typeName = typeProperty.getValue(relationshipObject).toString();
        Relationship relationshipType = null;
        Class<?> relationshipClass = null;
        try {
            relationshipClass = Class.forName(typeName);
            relationshipType = (Relationship)relationshipClass.newInstance();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error creating Relationship instance for type [" + typeName + "]");
        }
        List identityTypeIdProperty = PropertyQueries.createQuery(relationshipClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{"id"})).getResultList();
        ((Property)identityTypeIdProperty.get(0)).setValue((Object)relationshipType, idProperty.getValue(relationshipObject));
        List<?> identities = this.findChildRelationships(relationshipType);
        for (Object object : identities) {
            String descriptor = descriptorProperty.getValue(object).toString();
            List identityTypeProperty = PropertyQueries.createQuery(relationshipClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{descriptor})).getResultList();
            T identityType = this.convertToIdentityType(identityProperty.getValue(object));
            ((Property)identityTypeProperty.get(0)).setValue((Object)relationshipType, identityType);
        }
        this.populateRelationshipAttributes(relationshipType, relationshipObject);
        return (T)relationshipType;
    }

    private <T extends IdentityType> T convertToIdentityType(Object entity) {
        String discriminator = this.getConfig().getModelProperty(PropertyType.IDENTITY_DISCRIMINATOR).getValue(entity).toString();
        IdentityTypeHandler<? extends IdentityType> identityTypeManager = this.getConfig().getIdentityTypeStores().get(discriminator);
        IdentityType identityType = identityTypeManager.createIdentityType(entity, this);
        this.populateIdentityTypeAttributes(identityType, entity);
        return (T)identityType;
    }

    private void storeIdentityTypeAttribute(Object entity, Attribute<? extends Serializable> attribute) {
        Serializable value = attribute.getValue();
        if (value == null) {
            return;
        }
        Object[] values = null;
        values = value.getClass().isArray() ? (Object[])value : new Object[]{value};
        Property<Object> attributeNameProperty = this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_NAME);
        Property<Object> attributeIdentityProperty = this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_IDENTITY);
        Property<Object> attributeValueProperty = this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_VALUE);
        try {
            for (Object attribValue : values) {
                Object newInstance = this.getConfig().getAttributeClass().newInstance();
                attributeNameProperty.setValue(newInstance, (Object)attribute.getName());
                attributeValueProperty.setValue(newInstance, attribValue);
                attributeIdentityProperty.setValue(newInstance, entity);
                this.getEntityManager().persist(newInstance);
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error creating attributes.", (Throwable)e);
        }
    }

    private void storeRelationshipAttribute(Object identity, Attribute<? extends Serializable> userAttribute) {
        Serializable value = userAttribute.getValue();
        Object[] values = null;
        values = value.getClass().isArray() ? (Object[])value : new Object[]{value};
        Property<Object> attributeNameProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_NAME);
        Property<Object> attributeIdentityProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_RELATIONSHIP);
        Property<Object> attributeValueProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_VALUE);
        try {
            for (Object attribValue : values) {
                Object newInstance = this.getConfig().getRelationshipAttributeClass().newInstance();
                attributeNameProperty.setValue(newInstance, (Object)userAttribute.getName());
                attributeValueProperty.setValue(newInstance, attribValue);
                attributeIdentityProperty.setValue(newInstance, identity);
                this.getEntityManager().persist(newInstance);
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error creating attributes.", (Throwable)e);
        }
    }

    private void removeAttributes(Relationship relationship, Object identity) {
        List<?> storedAttributes = this.findRelationshipAttributes(identity);
        for (Object attribute : storedAttributes) {
            String attributeName = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_NAME).getValue(attribute).toString();
            if (relationship.getAttribute(attributeName) != null) continue;
            this.getEntityManager().remove(attribute);
        }
    }

    private void removeAttributes(IdentityType identityType, Object identity) {
        List<?> storedAttributes = this.findAllIdentityTypeAttributes(identity);
        for (Object attribute : storedAttributes) {
            String attributeName = this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_NAME).getValue(attribute).toString();
            if (identityType.getAttribute(attributeName) != null) continue;
            this.getEntityManager().remove(attribute);
        }
    }

    private List<?> findIdentityTypeAttributes(IdentityType identityType, Attribute<? extends Serializable> attribute) {
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getAttributeClass());
        Root root = criteria.from(this.getConfig().getAttributeClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Property<Object> attributeIdentityProperty = this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_IDENTITY);
        Join join = root.join(attributeIdentityProperty.getName());
        predicates.add(builder.equal((Expression)join.get(this.getConfig().getModelProperty(PropertyType.IDENTITY_ID).getName()), (Object)identityType.getId()));
        predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_NAME).getName()), (Object)attribute.getName()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    private List<?> findRelationshipAttributes(Relationship relationship, Attribute<? extends Serializable> attribute) {
        Property<Object> attributeIdentityProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP);
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getRelationshipAttributeClass());
        Root root = criteria.from(this.getConfig().getRelationshipAttributeClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Join join = root.join(attributeIdentityProperty.getName());
        predicates.add(builder.equal((Expression)join.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ID).getName()), (Object)relationship.getId()));
        predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_NAME).getName()), (Object)attribute.getName()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    private List<?> findAllIdentityTypeAttributes(Object object) {
        Class<?> attributeClass = this.getConfig().getAttributeClass();
        String identityProperty = this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_IDENTITY).getName();
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(attributeClass);
        Root root = criteria.from(attributeClass);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(identityProperty), object));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    private List<?> findRelationshipAttributes(Object object) {
        Class<?> attributeClass = this.getConfig().getRelationshipAttributeClass();
        String identityProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_RELATIONSHIP).getName();
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(attributeClass);
        Root root = criteria.from(attributeClass);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(identityProperty), object));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    protected Object lookupIdentityObjectById(String id) {
        if (id == null) {
            return null;
        }
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getIdentityClass());
        Root root = criteria.from(this.getConfig().getIdentityClass());
        ArrayList<Object> predicates = new ArrayList<Object>();
        Join join = root.join(this.getConfig().getModelProperty(PropertyType.IDENTITY_PARTITION).getName());
        predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.IDENTITY_ID).getName()), (Object)id));
        ArrayList<String> partitionIds = new ArrayList<String>();
        partitionIds.add(this.getCurrentRealm().getId());
        partitionIds.add(this.getCurrentPartition().getId());
        predicates.add(builder.in((Expression)join.get(this.getConfig().getModelProperty(PropertyType.PARTITION_ID).getName())).value(partitionIds));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List results = em.createQuery(criteria).getResultList();
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    private Object lookupRelationshipObjectById(String id) {
        if (id == null) {
            return null;
        }
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getRelationshipClass());
        Root root = criteria.from(this.getConfig().getRelationshipClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ID).getName()), (Object)id));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List results = em.createQuery(criteria).getResultList();
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    private void removeIdentityTypeRelationships(Object entity) {
        if (this.getConfig().getRelationshipClass() != null) {
            List<?> results = this.findIdentityTypeRelationships(entity);
            HashSet<Object> relationshipsToRemove = new HashSet<Object>();
            for (Object result : results) {
                relationshipsToRemove.add(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP).getValue(result));
            }
            for (Object relationship : relationshipsToRemove) {
                this.remove((AttributedType)this.convertToRelationshipType(relationship));
            }
        }
    }

    private List<?> findIdentityTypeRelationships(Object identityTypeEntity) {
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getRelationshipIdentityClass());
        Root root = criteria.from(this.getConfig().getRelationshipIdentityClass());
        criteria.where((Expression)builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY).getName()), identityTypeEntity));
        return em.createQuery(criteria).getResultList();
    }

    private void removeIdentityTypeAttributes(Object object) {
        EntityManager em = this.getEntityManager();
        if (this.getConfig().getAttributeClass() != null) {
            List<?> results = this.findAllIdentityTypeAttributes(object);
            for (Object result : results) {
                em.remove(result);
            }
        }
    }

    private void updateIdentityTypeAttributes(IdentityType identityType, Object entity) {
        Collection attributes = identityType.getAttributes();
        if (attributes != null && !attributes.isEmpty()) {
            EntityManager em = this.getEntityManager();
            for (Attribute attribute : attributes) {
                try {
                    JPAIdentityStoreConfiguration.MappedAttribute mappedAttribute = this.getConfig().getAttributeProperties().get(attribute.getName());
                    if (mappedAttribute != null) {
                        for (String attribName : this.getConfig().getAttributeProperties().keySet()) {
                            JPAIdentityStoreConfiguration.MappedAttribute attrib = this.getConfig().getAttributeProperties().get(attribName);
                            if (!attribute.getName().equals(attribName)) continue;
                            attrib.getAttributeProperty().setValue(entity, (Object)attribute.getValue());
                        }
                        continue;
                    }
                    List<?> results = this.findIdentityTypeAttributes(identityType, (Attribute<? extends Serializable>)attribute);
                    for (Object object : results) {
                        em.remove(object);
                    }
                    this.storeIdentityTypeAttribute(entity, (Attribute<? extends Serializable>)attribute);
                }
                catch (Exception e) {
                    throw new IdentityManagementException("Error setting attribute [" + attribute + "] for [" + entity + "]", (Throwable)e);
                }
            }
            this.removeAttributes(identityType, entity);
        } else {
            this.removeAttributes(identityType, entity);
        }
    }

    private void updateRelationshipAttributes(Relationship relationship, Object identity) {
        List attributeProperties = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(RelationshipAttribute.class)).getResultList();
        for (Property attributeProperty : attributeProperties) {
            relationship.setAttribute(new Attribute(attributeProperty.getName(), (Serializable)attributeProperty.getValue((Object)relationship)));
        }
        Collection attributes = relationship.getAttributes();
        if (attributes != null && !attributes.isEmpty()) {
            EntityManager em = this.getEntityManager();
            for (Attribute attribute : attributes) {
                try {
                    List<?> results = this.findRelationshipAttributes(relationship, (Attribute<? extends Serializable>)attribute);
                    for (Object object : results) {
                        em.remove(object);
                    }
                    this.storeRelationshipAttribute(identity, (Attribute<? extends Serializable>)attribute);
                }
                catch (Exception e) {
                    throw new IdentityManagementException("Error setting attribute [" + attribute + "] for [" + identity + "]", (Throwable)e);
                }
            }
            this.removeAttributes(relationship, identity);
        }
    }

    private void populateIdentityTypeAttributes(IdentityType identityType, Object entity) {
        try {
            List<?> results;
            for (JPAIdentityStoreConfiguration.MappedAttribute attrib : this.getConfig().getAttributeProperties().values()) {
                if (attrib.getIdentityProperty() != null && attrib.getIdentityProperty().getValue(entity) == null) continue;
                Member member = attrib.getAttributeProperty().getMember();
                String mappedName = null;
                Object value = null;
                if (member instanceof Field) {
                    Field field = (Field)member;
                    IDMAttribute annotation = field.getAnnotation(IDMAttribute.class);
                    field.setAccessible(true);
                    mappedName = annotation.name();
                    value = field.get(entity);
                }
                identityType.setAttribute(new Attribute(mappedName, (Serializable)value));
            }
            if (this.getConfig().getAttributeClass() != null && !(results = this.findAllIdentityTypeAttributes(entity)).isEmpty()) {
                for (Object object : results) {
                    Property<Object> attributeNameProperty = this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_NAME);
                    Property<Object> attributeValueProperty = this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_VALUE);
                    String attribName = (String)attributeNameProperty.getValue(object);
                    Serializable attribValue = (Serializable)attributeValueProperty.getValue(object);
                    Attribute identityTypeAttribute = identityType.getAttribute(attribName);
                    if (identityTypeAttribute == null) {
                        identityTypeAttribute = new Attribute(attribName, attribValue);
                        identityType.setAttribute(identityTypeAttribute);
                        continue;
                    }
                    if (identityTypeAttribute.getValue() == null) continue;
                    String[] values = null;
                    values = identityTypeAttribute.getValue().getClass().isArray() ? (String[])identityTypeAttribute.getValue() : new String[]{identityTypeAttribute.getValue().toString()};
                    String[] newValues = Arrays.copyOf(values, values.length + 1);
                    newValues[newValues.length - 1] = attribValue.toString();
                    identityTypeAttribute.setValue((Serializable)newValues);
                    identityType.setAttribute(identityTypeAttribute);
                }
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error setting attribute.", (Throwable)e);
        }
    }

    private void populateRelationshipAttributes(Relationship relationshipType, Object relationship) {
        try {
            List<?> results;
            if (this.getConfig().getRelationshipAttributeClass() != null && !(results = this.findRelationshipAttributes(relationship)).isEmpty()) {
                for (Object object : results) {
                    Property<Object> attributeNameProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_NAME);
                    Property<Object> attributeValueProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_VALUE);
                    String attribName = (String)attributeNameProperty.getValue(object);
                    Serializable attribValue = (Serializable)attributeValueProperty.getValue(object);
                    List attributeProperties = PropertyQueries.createQuery(relationshipType.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(RelationshipAttribute.class)).getResultList();
                    Property relationshipAttributeProperty = null;
                    for (Property attributeProperty : attributeProperties) {
                        String propertyName = attributeProperty.getName();
                        if (!propertyName.equals(attribName)) continue;
                        relationshipAttributeProperty = attributeProperty;
                        break;
                    }
                    if (relationshipAttributeProperty != null) {
                        relationshipAttributeProperty.setValue((Object)relationshipType, (Object)attribValue);
                        continue;
                    }
                    Attribute identityTypeAttribute = relationshipType.getAttribute(attribName);
                    if (identityTypeAttribute == null) {
                        identityTypeAttribute = new Attribute(attribName, attribValue);
                        relationshipType.setAttribute(identityTypeAttribute);
                        continue;
                    }
                    if (identityTypeAttribute.getValue() == null) continue;
                    String[] values = null;
                    values = identityTypeAttribute.getValue().getClass().isArray() ? (String[])identityTypeAttribute.getValue() : new String[]{identityTypeAttribute.getValue().toString()};
                    String[] newValues = Arrays.copyOf(values, values.length + 1);
                    newValues[newValues.length - 1] = attribValue.toString();
                    identityTypeAttribute.setValue((Serializable)newValues);
                    relationshipType.setAttribute(identityTypeAttribute);
                }
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error setting attribute.", (Throwable)e);
        }
    }

    public <T extends Relationship> int countQueryResults(RelationshipQuery<T> query) {
        throw new UnsupportedOperationException();
    }

    protected Partition convertPartitionEntityToPartition(Object partitionObject) {
        return this.partitionStore.convertPartitionEntityToPartition(partitionObject);
    }

    protected Object lookupPartitionObject(Partition partition) {
        return this.partitionStore.lookupPartitionObject(partition);
    }

    protected Realm getCurrentRealm() {
        return this.getContext().getRealm();
    }

    protected Partition getCurrentPartition() {
        return this.getContext().getPartition();
    }

    protected EntityManager getEntityManager() {
        if (!this.getContext().isParameterSet(INVOCATION_CTX_ENTITY_MANAGER)) {
            throw new IllegalStateException("Error while trying to determine EntityManager - context parameter not set.");
        }
        return (EntityManager)this.getContext().getParameter(INVOCATION_CTX_ENTITY_MANAGER);
    }
}

