/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.internal.util.IDMUtil;
import org.picketlink.idm.ldap.internal.LDAPAgent;
import org.picketlink.idm.ldap.internal.LDAPEntry;
import org.picketlink.idm.ldap.internal.LDAPGroup;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.ldap.internal.LDAPOperationManager;
import org.picketlink.idm.ldap.internal.LDAPQueryParameter;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;

public class LDAPQuery {
    private List<LDAPQueryParameter> managedParameters = new ArrayList<LDAPQueryParameter>();
    private Boolean hasCustomAttributes = null;
    private IdentityQuery<?> identityQuery;
    private LDAPIdentityStore identityStore;
    private boolean hasRelationshipParameters;

    public LDAPQuery(IdentityQuery<?> identityQuery, LDAPIdentityStore identityStore) {
        this.identityQuery = identityQuery;
        this.identityStore = identityStore;
        for (Map.Entry entry : identityQuery.getParameters().entrySet()) {
            Object[] values;
            QueryParameter queryParameter = (QueryParameter)entry.getKey();
            LDAPQueryParameter parameter = new LDAPQueryParameter(queryParameter, values = (Object[])entry.getValue());
            if (parameter.isMappedToManagedAttribute()) {
                this.managedParameters.add(parameter);
                continue;
            }
            if (parameter.isMembershipParameter()) {
                this.hasRelationshipParameters = true;
                continue;
            }
            this.hasCustomAttributes = true;
        }
    }

    public StringBuffer createManagedAttributesFilter() {
        if (this.getManagedParameters().isEmpty()) {
            return null;
        }
        StringBuffer filter = new StringBuffer("(&(objectClass=*)");
        for (LDAPQueryParameter ldapQueryParameter : this.getManagedParameters()) {
            filter.append(ldapQueryParameter.createFilter());
        }
        filter.append(")");
        return filter;
    }

    public String createRelationshipFilter() {
        StringBuffer relationshipFilter = new StringBuffer();
        if (IDMUtil.isAgentType(this.identityQuery.getIdentityType())) {
            relationshipFilter.append(this.createHasRoleFilter());
            relationshipFilter.append(this.createMemberOfFilter());
            relationshipFilter.append(this.createGroupRoleFilter());
        } else if (IDMUtil.isRoleType(this.identityQuery.getIdentityType())) {
            relationshipFilter.append(this.createRoleOfFilter());
        } else if (IDMUtil.isGroupType(this.identityQuery.getIdentityType())) {
            relationshipFilter.append(this.createHasMemberFilter());
            relationshipFilter.append(this.createChildGroupsFilter());
        }
        return relationshipFilter.toString();
    }

    public boolean hasCustomAttributes() {
        return this.hasCustomAttributes != null && this.hasCustomAttributes != false;
    }

    public List<LDAPQueryParameter> getManagedParameters() {
        return this.managedParameters;
    }

    private String createHasMemberFilter() {
        if (this.identityQuery.getParameters().containsKey(Group.HAS_MEMBER)) {
            Object[] values = (Object[])this.identityQuery.getParameters().get(Group.HAS_MEMBER);
            Agent[] agents = new Agent[values.length];
            for (int j = 0; j < values.length; ++j) {
                Object value = values[j];
                agents[j] = (Agent)value;
            }
            return this.createMembersFilter(agents, this.getConfig().getGroupDNSuffix());
        }
        return "";
    }

    private String createRoleOfFilter() {
        if (this.identityQuery.getParameters().containsKey(User.ROLE_OF)) {
            Object[] values = (Object[])this.identityQuery.getParameters().get(Role.ROLE_OF);
            Agent[] agents = new Agent[values.length];
            for (int j = 0; j < values.length; ++j) {
                Object value = values[j];
                agents[j] = (Agent)value;
            }
            return this.createMembersFilter(agents, this.getConfig().getRoleDNSuffix());
        }
        return "";
    }

    private String createGroupRoleFilter() {
        if (this.identityQuery.getParameters().containsKey(IdentityType.HAS_GROUP_ROLE)) {
            StringBuffer groupRoleFilter = new StringBuffer();
            NamingEnumeration<SearchResult> search = null;
            try {
                Object[] groupRoles;
                for (Object group : groupRoles = (Object[])this.identityQuery.getParameters().get(User.HAS_GROUP_ROLE)) {
                    GroupRole groupRole = (GroupRole)group;
                    Agent agent = (Agent)groupRole.getMember();
                    String agentDNSuffix = this.getConfig().getAgentDNSuffix();
                    if (User.class.isInstance(agent)) {
                        agentDNSuffix = this.getConfig().getUserDNSuffix();
                    }
                    if (!(search = this.getLDAPManager().search(agentDNSuffix, "(cn=" + groupRole.getGroup().getName() + ")")).hasMoreElements()) continue;
                    while (search.hasMoreElements()) {
                        SearchResult searchResult = search.next();
                        String[] nameInNamespace = searchResult.getNameInNamespace().split(",");
                        String userId = nameInNamespace[1];
                        Attribute member = searchResult.getAttributes().get("member");
                        if (!member.contains("cn=" + groupRole.getRole().getName() + "," + this.getConfig().getRoleDNSuffix())) continue;
                        groupRoleFilter.append("(").append(userId).append(")");
                    }
                }
            }
            catch (Exception e) {
                throw new IdentityManagementException((Throwable)e);
            }
            finally {
                if (search != null) {
                    try {
                        search.close();
                    }
                    catch (NamingException e) {}
                }
            }
            return groupRoleFilter.toString();
        }
        return "";
    }

    private String createHasRoleFilter() {
        if (this.identityQuery.getParameters().containsKey(User.HAS_ROLE)) {
            Object[] roleNames = (Object[])this.identityQuery.getParameters().get(User.HAS_ROLE);
            LDAPEntry[] roles = new LDAPEntry[roleNames.length];
            for (int i = 0; i < roleNames.length; ++i) {
                String name = (String)roleNames[i];
                if (name == null) continue;
                roles[i] = this.identityStore.lookupRole(name);
            }
            return this.createParentMembersFilter(roles);
        }
        return "";
    }

    private String createMemberOfFilter() {
        if (this.identityQuery.getParameters().containsKey(User.MEMBER_OF)) {
            Object[] groupNames = (Object[])this.identityQuery.getParameters().get(User.MEMBER_OF);
            LDAPEntry[] groups = new LDAPEntry[groupNames.length];
            for (int i = 0; i < groupNames.length; ++i) {
                String name = (String)groupNames[i];
                if (name == null) continue;
                groups[i] = this.identityStore.lookupGroup(name);
            }
            return this.createParentMembersFilter(groups);
        }
        return "";
    }

    private String createMembersFilter(Agent[] members, String baseDN) {
        String membersFilter = "";
        for (Agent agent : members) {
            LDAPAgent ldapAgent;
            if (agent == null || !Agent.class.isInstance(agent) || (ldapAgent = this.identityStore.lookupAgent(agent)) == null) continue;
            membersFilter = membersFilter + "(member=" + ldapAgent.getDN() + ")";
        }
        StringBuffer parentEntriesFilter = new StringBuffer();
        if (membersFilter.length() > 0) {
            NamingEnumeration<SearchResult> search = null;
            try {
                search = this.getLDAPManager().search(baseDN, membersFilter.toString());
                while (search.hasMoreElements()) {
                    SearchResult searchResult = search.next();
                    String entryCN = searchResult.getAttributes().get("cn").get().toString();
                    parentEntriesFilter.append("(").append("cn").append("=").append(entryCN).append(")");
                }
            }
            catch (Exception e) {
                throw new IdentityManagementException((Throwable)e);
            }
            finally {
                if (search != null) {
                    try {
                        search.close();
                    }
                    catch (NamingException e) {}
                }
            }
        }
        if (parentEntriesFilter.length() > 0) {
            parentEntriesFilter.insert(0, "(|");
            parentEntriesFilter.append(")");
        }
        return parentEntriesFilter.toString();
    }

    private String createParentMembersFilter(LDAPEntry[] parents) {
        StringBuffer additionalFilter = new StringBuffer();
        HashMap<String, Integer> userCount = new HashMap<String, Integer>();
        for (LDAPEntry ldapEntry : parents) {
            Attribute memberAttribute = null;
            if (ldapEntry == null) continue;
            memberAttribute = ldapEntry.getLDAPAttributes().get("member");
            NamingEnumeration<?> members = null;
            try {
                members = memberAttribute.getAll();
                while (members.hasMoreElements()) {
                    String memberDN = (String)members.nextElement();
                    if (memberDN.trim().isEmpty()) continue;
                    String userId = memberDN.split(",")[0];
                    if (!userCount.containsKey(userId)) {
                        userCount.put(userId, 1);
                    } else {
                        Integer count = (Integer)userCount.get(userId);
                        userCount.put(userId, count + 1);
                    }
                    additionalFilter.append("(").append(userId).append(")");
                }
            }
            catch (NamingException e) {
                throw new IdentityManagementException((Throwable)e);
            }
            finally {
                if (members != null) {
                    try {
                        members.close();
                    }
                    catch (NamingException e) {}
                }
            }
        }
        Set entrySet = userCount.entrySet();
        for (Map.Entry entry : entrySet) {
            if (((Integer)entry.getValue()).equals(parents.length)) continue;
            String filterTmp = additionalFilter.toString();
            filterTmp = filterTmp.replaceAll("\\(" + (String)entry.getKey() + "\\)", "");
            additionalFilter = new StringBuffer(filterTmp);
        }
        if (additionalFilter.length() > 0) {
            additionalFilter.insert(0, "(|");
            additionalFilter.append(")");
        }
        return additionalFilter.toString();
    }

    private String createChildGroupsFilter() {
        if (this.identityQuery.getParameters().containsKey(Group.PARENT)) {
            String parentName = ((Object[])this.identityQuery.getParameters().get(Group.PARENT))[0].toString();
            LDAPGroup parentGroup = this.identityStore.lookupGroup(parentName);
            NamingEnumeration<?> members = null;
            StringBuffer childGroupsFilter = new StringBuffer();
            try {
                members = parentGroup.getLDAPAttributes().get("member").getAll();
                while (members.hasMoreElements()) {
                    String groupDN = (String)members.nextElement();
                    if (groupDN.toString().trim().isEmpty()) continue;
                    String groupName = groupDN.split(",")[0];
                    childGroupsFilter.append("(").append(groupName).append(")");
                }
            }
            catch (NamingException e) {
                throw new IdentityManagementException((Throwable)e);
            }
            finally {
                if (members != null) {
                    try {
                        members.close();
                    }
                    catch (NamingException e) {}
                }
            }
            return childGroupsFilter.toString();
        }
        return "";
    }

    private LDAPIdentityStoreConfiguration getConfig() {
        return this.identityStore.getConfig();
    }

    private LDAPOperationManager getLDAPManager() {
        return this.getConfig().getLdapManager();
    }

    public boolean hasRelationshipParameters() {
        return this.hasRelationshipParameters;
    }
}

