/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.util.HashMap;
import java.util.Map;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.QueryParameter;

public class LDAPQueryAttributeMapper {
    private static final Map<QueryParameter, String> customAttributeMap = new HashMap<QueryParameter, String>();
    private static final Map<QueryParameter, String> ldapAttributeMap = new HashMap<QueryParameter, String>();

    public static Attribute map(QueryParameter parameter) {
        String attribute = ldapAttributeMap.get(parameter);
        if (attribute == null) {
            return null;
        }
        return new BasicAttribute(attribute);
    }

    public static Attribute mapCustom(QueryParameter queryParameter) {
        if (customAttributeMap.get(queryParameter) == null) {
            return null;
        }
        return new BasicAttribute(customAttributeMap.get(queryParameter));
    }

    static {
        ldapAttributeMap.put(User.ID, "entryUUID");
        ldapAttributeMap.put(User.LOGIN_NAME, "uid");
        ldapAttributeMap.put(User.EMAIL, "mail");
        ldapAttributeMap.put(User.FIRST_NAME, "givenname");
        ldapAttributeMap.put(User.LAST_NAME, "sn");
        ldapAttributeMap.put(User.MEMBER_OF, "memberOf");
        ldapAttributeMap.put(Role.NAME, "cn");
        ldapAttributeMap.put(Group.NAME, "cn");
        ldapAttributeMap.put(User.CREATED_DATE, "createTimeStamp");
        ldapAttributeMap.put(User.CREATED_BEFORE, "createTimeStamp");
        ldapAttributeMap.put(User.CREATED_AFTER, "createTimeStamp");
        customAttributeMap.put(User.EXPIRY_DATE, "expiryDate");
        customAttributeMap.put(User.EXPIRY_BEFORE, "expiryDate");
        customAttributeMap.put(User.EXPIRY_AFTER, "expiryDate");
        customAttributeMap.put(IdentityType.ENABLED, "enabled");
    }
}

