/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.picketlink.idm.ldap.internal.LDAPAgent;
import org.picketlink.idm.model.User;

public class LDAPUser
extends LDAPAgent
implements User {
    private static final long serialVersionUID = 1L;

    public LDAPUser(String dnSuffix) {
        super(dnSuffix);
    }

    public LDAPUser(String loginName, String userDNSuffix) {
        super(loginName, userDNSuffix);
    }

    public String getFirstName() {
        Attribute theAttribute = this.getLDAPAttributes().get("givenname");
        return this.getAttributeValue(theAttribute);
    }

    private String getAttributeValue(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        Object value = null;
        try {
            value = attribute.get();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        if (value != null) {
            if (value.getClass().isArray()) {
                return ((Object[])value)[0].toString();
            }
            return value.toString();
        }
        return null;
    }

    public void setFirstName(String firstName) {
        if (firstName == null) {
            firstName = " ";
        }
        this.getLDAPAttributes().put("givenname", firstName);
    }

    public String getLastName() {
        Attribute theAttribute = this.getLDAPAttributes().get("sn");
        return this.getAttributeValue(theAttribute);
    }

    public void setLastName(String lastName) {
        if (lastName == null) {
            lastName = " ";
        }
        this.getLDAPAttributes().put("sn", lastName);
    }

    public void setFullName(String fullName) {
        this.getLDAPAttributes().put("cn", fullName);
    }

    public String getEmail() {
        try {
            Attribute theAttribute = this.getLDAPAttributes().get("mail");
            if (theAttribute != null) {
                return (String)theAttribute.get();
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public void setEmail(String email) {
        if (email == null) {
            email = " ";
        }
        this.getLDAPAttributes().put("mail", email);
    }

    public String getUserCN() {
        String fullName = this.getFirstName();
        if (this.getLastName() != null) {
            fullName = fullName + " " + this.getLastName();
        }
        return fullName;
    }
}

