/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.persistence.Entity;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.internal.EEJPAContextInitializer;

@ApplicationScoped
public class IdentityStoreAutoConfiguration
implements Extension {
    private static final String DEFAULT_CONFIGURATION_NAME = "default";
    private static final String JPA_ANNOTATION_PACKAGE = "org.picketlink.idm.jpa.annotations";
    private Set<Class<?>> entities = new HashSet();
    private BeanManager beanManager;

    public void configure(IdentityConfigurationBuilder builder) {
        if (this.isJPAStoreConfiguration()) {
            Class[] entities = new Class[this.getEntities().size()];
            this.getEntities().toArray(entities);
            builder.named(DEFAULT_CONFIGURATION_NAME).stores().jpa().mappedEntity(entities).addContextInitializer((ContextInitializer)this.getJPAContextInitializer()).supportAllFeatures();
        } else {
            builder.named(DEFAULT_CONFIGURATION_NAME).stores().file().supportAllFeatures();
        }
    }

    public <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event, BeanManager beanManager) {
        AnnotatedType type;
        Class entityType;
        this.beanManager = beanManager;
        if (event.getAnnotatedType().isAnnotationPresent(Entity.class) && !Modifier.isAbstract((entityType = (type = event.getAnnotatedType()).getJavaClass()).getModifiers()) && this.isIdentityEntity(entityType)) {
            this.entities.add(entityType);
        }
    }

    private boolean isIdentityEntity(Class<?> cls) {
        while (!cls.equals(Object.class)) {
            for (Annotation a : cls.getAnnotations()) {
                if (!a.annotationType().getName().startsWith(JPA_ANNOTATION_PACKAGE)) continue;
                return true;
            }
            for (Field f : cls.getDeclaredFields()) {
                for (Annotation a : f.getAnnotations()) {
                    if (!a.annotationType().getName().startsWith(JPA_ANNOTATION_PACKAGE)) continue;
                    return true;
                }
            }
            cls = cls.getSuperclass();
        }
        return false;
    }

    public Set<Class<?>> getEntities() {
        return Collections.unmodifiableSet(this.entities);
    }

    private boolean isJPAStoreConfiguration() {
        return !this.getEntities().isEmpty();
    }

    private EEJPAContextInitializer getJPAContextInitializer() {
        Set beans = this.beanManager.getBeans(EEJPAContextInitializer.class, new Annotation[0]);
        if (beans.isEmpty()) {
            throw new SecurityException("Could not find JPA Context Initializer. Expected type [" + EEJPAContextInitializer.class + "].");
        }
        if (beans.size() > 1) {
            throw new SecurityException("Multiple references found for JPA Context Initializer. Expected type [" + EEJPAContextInitializer.class + "].");
        }
        Bean bean = (Bean)beans.iterator().next();
        return (EEJPAContextInitializer)this.beanManager.getReference(bean, EEJPAContextInitializer.class, this.beanManager.createCreationalContext((Contextual)bean));
    }
}

