/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.standalone.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.HttpResponseException;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.picketlink.social.standalone.google.GoogleAccessTokenContext;
import org.picketlink.social.standalone.google.GoogleProcessor;
import org.picketlink.social.standalone.oauth.SocialException;

abstract class GoogleRequest<T> {
    protected static Logger log = Logger.getLogger(GoogleRequest.class);

    GoogleRequest() {
    }

    protected abstract T invokeRequest(GoogleAccessTokenContext var1) throws IOException;

    protected abstract SocialException createException(IOException var1);

    public T executeRequest(GoogleAccessTokenContext accessTokenContext, GoogleProcessor googleProcessor) {
        GoogleTokenResponse tokenData = accessTokenContext.getTokenData();
        try {
            return this.invokeRequest(accessTokenContext);
        }
        catch (IOException ioe) {
            HttpResponseException googleException;
            if (ioe instanceof HttpResponseException && (googleException = (HttpResponseException)ioe).getStatusCode() == 400 && tokenData.getRefreshToken() != null) {
                try {
                    googleProcessor.refreshToken(accessTokenContext);
                    return this.invokeRequest(accessTokenContext);
                }
                catch (SocialException refreshException) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Refreshing token failed", (Throwable)((Object)refreshException));
                    }
                }
                catch (IOException ioe2) {
                    ioe = ioe2;
                }
            }
            log.warn((Object)("Error when calling Google operation. Details: " + ioe.getMessage()));
            throw this.createException(ioe);
        }
    }
}

