/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.standalone.openid.web;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.DirectError;
import org.openid4java.message.Message;
import org.openid4java.message.ParameterList;
import org.openid4java.server.InMemoryServerAssociationStore;
import org.openid4java.server.ServerAssociationStore;
import org.openid4java.server.ServerManager;

public class HTTPOpenIDProvider {
    public String process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String responseText;
        String mode;
        HttpSession session = request.getSession();
        ServerManager manager = new ServerManager();
        manager.setSharedAssociations((ServerAssociationStore)new InMemoryServerAssociationStore());
        manager.setPrivateAssociations((ServerAssociationStore)new InMemoryServerAssociationStore());
        manager.setOPEndpointUrl(request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + "/simple-openid/provider.jsp");
        ParameterList requestp = "complete".equals(request.getParameter("_action")) ? (ParameterList)session.getAttribute("parameterlist") : new ParameterList(request.getParameterMap());
        String string = mode = requestp.hasParameter("openid.mode") ? requestp.getParameterValue("openid.mode") : null;
        if ("associate".equals(mode)) {
            Message responsem = manager.associationResponse(requestp);
            responseText = responsem.keyValueFormEncoding();
        } else if ("checkid_setup".equals(mode) || "checkid_immediate".equals(mode)) {
            String userSelectedId = null;
            String userSelectedClaimedId = null;
            Boolean authenticatedAndApproved = Boolean.FALSE;
            if (session.getAttribute("authenticatedAndApproved") == null || (Boolean)session.getAttribute("authenticatedAndApproved") == Boolean.FALSE) {
                session.setAttribute("parameterlist", (Object)requestp);
                response.sendRedirect("provider_authorization.jsp");
            } else {
                userSelectedId = (String)session.getAttribute("openid.claimed_id");
                userSelectedClaimedId = (String)session.getAttribute("openid.identity");
                authenticatedAndApproved = (Boolean)session.getAttribute("authenticatedAndApproved");
                session.removeAttribute("parameterlist");
                session.setAttribute("authenticatedAndApproved", (Object)Boolean.FALSE);
            }
            Message responsem = manager.authResponse(requestp, userSelectedId, userSelectedClaimedId, authenticatedAndApproved.booleanValue());
            if (responsem instanceof AuthSuccess) {
                response.sendRedirect(((AuthSuccess)responsem).getDestinationUrl(true));
                return "";
            }
            responseText = "<pre>" + responsem.keyValueFormEncoding() + "</pre>";
        } else if ("check_authentication".equals(mode)) {
            Message responsem = manager.verify(requestp);
            responseText = responsem.keyValueFormEncoding();
        } else {
            DirectError responsem = DirectError.createDirectError((String)"Unknown request");
            responseText = responsem.keyValueFormEncoding();
        }
        return responseText != null ? responseText.trim() : null;
    }
}

