/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.web;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.adapters.AbstractAdapter;
import org.picocontainer.lifecycle.DefaultLifecycleState;
import org.picocontainer.lifecycle.LifecycleState;
import org.picocontainer.web.PicoContainerWebException;
import org.picocontainer.web.ScopedContainers;
import org.picocontainer.web.SessionStoreHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PicoServletContainerFilter
implements Filter,
Serializable {
    private boolean exposeServletInfrastructure;
    private boolean isStateless;
    private boolean printSessionSize;
    private boolean debug = false;
    private static ThreadLocal<HttpSession> currentSession = new ThreadLocal();
    private static ThreadLocal<ServletRequest> currentRequest = new ThreadLocal();
    private static ThreadLocal<ServletResponse> currentResponse = new ThreadLocal();

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext context = filterConfig.getServletContext();
        ScopedContainers scopedContainers = this.getScopedContainers(context);
        this.setAppContainer(scopedContainers.getApplicationContainer());
        this.isStateless = Boolean.parseBoolean(context.getInitParameter("stateless-webapp"));
        this.printSessionSize = Boolean.parseBoolean(context.getInitParameter("print-session-size"));
        String exposeServletInfrastructureString = filterConfig.getInitParameter("exposeServletInfrastructure");
        if (exposeServletInfrastructureString == null || Boolean.parseBoolean(exposeServletInfrastructureString)) {
            this.exposeServletInfrastructure = true;
        }
        scopedContainers.getRequestContainer().as(new Properties[]{Characteristics.NO_CACHE}).addAdapter((ComponentAdapter)new HttpSessionInjector());
        scopedContainers.getRequestContainer().as(new Properties[]{Characteristics.NO_CACHE}).addAdapter((ComponentAdapter)new HttpServletRequestInjector());
        scopedContainers.getRequestContainer().as(new Properties[]{Characteristics.NO_CACHE}).addAdapter((ComponentAdapter)new HttpServletResponseInjector());
        this.initAdditionalScopedComponents(scopedContainers.getSessionContainer(), scopedContainers.getRequestContainer());
    }

    public void destroy() {
    }

    private ScopedContainers getScopedContainers(ServletContext context) {
        return (ScopedContainers)context.getAttribute(ScopedContainers.class.getName());
    }

    protected void initAdditionalScopedComponents(MutablePicoContainer sessionContainer, MutablePicoContainer reqContainer) {
    }

    public static Object getRequestComponentForThread(Class<?> type) {
        MutablePicoContainer requestContainer = (MutablePicoContainer)ServletFilter.currentRequestContainer.get();
        DefaultPicoContainer container = new DefaultPicoContainer((PicoContainer)requestContainer);
        container.addComponent(type);
        return container.getComponent(type);
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)req;
        HttpSession sess = servletRequest.getSession();
        if (this.exposeServletInfrastructure) {
            currentSession.set(sess);
            currentRequest.set(req);
            currentResponse.set(resp);
        }
        ScopedContainers scopedContainers = this.getScopedContainers(sess.getServletContext());
        SessionStoreHolder ssh = null;
        if (!this.isStateless) {
            ssh = (SessionStoreHolder)sess.getAttribute(SessionStoreHolder.class.getName());
            if (ssh == null) {
                if (scopedContainers.getSessionContainer().getComponentAdapters().size() > 0) {
                    throw new PicoContainerWebException("Session not setup correctly.  There are components registered at the session level, but no working container to host them");
                }
                ssh = new SessionStoreHolder(scopedContainers.getSessionStoring().getCacheForThread(), (LifecycleState)new DefaultLifecycleState());
            }
            scopedContainers.getSessionStoring().putCacheForThread(ssh.getStoreWrapper());
            scopedContainers.getSessionState().putLifecycleStateModelForThread(ssh.getLifecycleState());
        }
        scopedContainers.getRequestStoring().resetCacheForThread();
        scopedContainers.getRequestState().resetStateModelForThread();
        scopedContainers.getRequestContainer().start();
        this.setAppContainer(scopedContainers.getApplicationContainer());
        if (!this.isStateless) {
            this.setSessionContainer(scopedContainers.getSessionContainer());
        }
        this.setRequestContainer(scopedContainers.getRequestContainer());
        this.containersSetupForRequest(scopedContainers.getApplicationContainer(), scopedContainers.getSessionContainer(), scopedContainers.getRequestContainer(), req, resp);
        filterChain.doFilter(req, resp);
        this.setAppContainer(null);
        if (!this.isStateless) {
            this.setSessionContainer(null);
        }
        this.setRequestContainer(null);
        scopedContainers.getRequestContainer().stop();
        scopedContainers.getRequestContainer().dispose();
        if (!this.isStateless) {
            if (this.printSessionSize) {
                this.printSessionSizeDetailsForDebugging(ssh);
            }
            sess.setAttribute(SessionStoreHolder.class.getName(), (Object)ssh);
        }
        scopedContainers.getRequestStoring().invalidateCacheForThread();
        scopedContainers.getRequestState().invalidateStateModelForThread();
        if (!this.isStateless) {
            scopedContainers.getSessionStoring().invalidateCacheForThread();
            scopedContainers.getSessionState().invalidateStateModelForThread();
        }
        if (this.exposeServletInfrastructure) {
            currentSession.set(null);
            currentRequest.set(null);
            currentResponse.set(null);
        }
    }

    private void printSessionSizeDetailsForDebugging(SessionStoreHolder ssh) throws IOException {
        if (this.debug) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(ssh);
            oos.close();
            baos.close();
            String xml = new XStream((ReflectionProvider)new PureJavaReflectionProvider()).toXML((Object)ssh);
            int bytes = baos.toByteArray().length;
            System.out.println("** Session written (" + bytes + " bytes), xml representation= " + xml);
        }
    }

    protected void containersSetupForRequest(MutablePicoContainer appcontainer, MutablePicoContainer sessionContainer, MutablePicoContainer requestContainer, ServletRequest req, ServletResponse resp) {
    }

    protected abstract void setAppContainer(MutablePicoContainer var1);

    protected abstract void setSessionContainer(MutablePicoContainer var1);

    protected abstract void setRequestContainer(MutablePicoContainer var1);

    public static class HttpServletResponseInjector
    extends AbstractAdapter {
        public HttpServletResponseInjector() {
            super(HttpServletResponse.class, HttpServletResponse.class);
        }

        public Object getComponentInstance(PicoContainer picoContainer, Type type) throws PicoCompositionException {
            return currentResponse.get();
        }

        public void verify(PicoContainer picoContainer) throws PicoCompositionException {
        }

        public String getDescriptor() {
            return "HttpServletResponseInjector";
        }
    }

    public static class HttpServletRequestInjector
    extends AbstractAdapter {
        public HttpServletRequestInjector() {
            super(HttpServletRequest.class, HttpServletRequest.class);
        }

        public Object getComponentInstance(PicoContainer picoContainer, Type type) throws PicoCompositionException {
            return currentRequest.get();
        }

        public void verify(PicoContainer picoContainer) throws PicoCompositionException {
        }

        public String getDescriptor() {
            return "HttpServletRequestInjector";
        }
    }

    public static class HttpSessionInjector
    extends AbstractAdapter {
        public HttpSessionInjector() {
            super(HttpSession.class, HttpSession.class);
        }

        public Object getComponentInstance(PicoContainer picoContainer, Type type) throws PicoCompositionException {
            return currentSession.get();
        }

        public void verify(PicoContainer picoContainer) throws PicoCompositionException {
        }

        public String getDescriptor() {
            return "HttpSessionInjector";
        }
    }

    public static class ServletFilter
    extends PicoServletContainerFilter {
        private static ThreadLocal<MutablePicoContainer> currentAppContainer = new ThreadLocal();
        private static ThreadLocal<MutablePicoContainer> currentSessionContainer = new ThreadLocal();
        private static ThreadLocal<MutablePicoContainer> currentRequestContainer = new ThreadLocal();

        protected void setAppContainer(MutablePicoContainer container) {
            if (currentRequestContainer == null) {
                currentRequestContainer = new ThreadLocal();
            }
            currentAppContainer.set(container);
        }

        protected void setRequestContainer(MutablePicoContainer container) {
            if (currentRequestContainer == null) {
                currentRequestContainer = new ThreadLocal();
            }
            currentRequestContainer.set(container);
        }

        protected void setSessionContainer(MutablePicoContainer container) {
            if (currentSessionContainer == null) {
                currentSessionContainer = new ThreadLocal();
            }
            currentSessionContainer.set(container);
        }
    }
}

