/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.web;

import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.picocontainer.BehaviorFactory;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.Caching;
import org.picocontainer.behaviors.Guarding;
import org.picocontainer.behaviors.Storing;
import org.picocontainer.containers.EmptyPicoContainer;
import org.picocontainer.lifecycle.LifecycleState;
import org.picocontainer.lifecycle.StartableLifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;
import org.picocontainer.web.ScopedContainers;
import org.picocontainer.web.SessionStoreHolder;
import org.picocontainer.web.ThreadLocalLifecycleState;
import org.picocontainer.web.WebappComposer;

public class PicoServletContainerListener
implements ServletContextListener,
HttpSessionListener,
Serializable {
    public static final String WEBAPP_COMPOSER_CLASS = "webapp-composer-class";
    public static final String STATELESS_WEBAPP = "stateless-webapp";
    public static final String PRINT_SESSION_SIZE = "print-session-size";
    private boolean isStateless;

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        this.isStateless = Boolean.parseBoolean(context.getInitParameter(STATELESS_WEBAPP));
        ScopedContainers scopedContainers = this.makeScopedContainers(this.isStateless);
        scopedContainers.getApplicationContainer().setName("application");
        if (!this.isStateless) {
            scopedContainers.getSessionContainer().setName("session");
        }
        scopedContainers.getRequestContainer().setName("request");
        this.compose(this.loadComposer(context), context, scopedContainers);
        this.start(scopedContainers.getApplicationContainer());
        context.setAttribute(ScopedContainers.class.getName(), (Object)scopedContainers);
    }

    @Deprecated
    protected ScopedContainers makeScopedContainers() {
        return this.makeScopedContainers(false);
    }

    protected ScopedContainers makeScopedContainers(boolean stateless) {
        DefaultPicoContainer parentOfRequestContainer;
        DefaultPicoContainer sessCtnr;
        Storing sessStoring;
        ThreadLocalLifecycleState sessionState;
        DefaultPicoContainer appCtnr = new DefaultPicoContainer(new Guarding().wrap((ComponentFactory)new Caching()), this.makeLifecycleStrategy(), this.makeParentContainer(), this.makeAppComponentMonitor());
        if (stateless) {
            sessionState = null;
            sessStoring = null;
            sessCtnr = null;
            parentOfRequestContainer = appCtnr;
        } else {
            sessionState = new ThreadLocalLifecycleState();
            sessStoring = new Storing();
            sessCtnr = new DefaultPicoContainer(new Guarding().wrap((ComponentFactory)sessStoring), this.makeLifecycleStrategy(), (PicoContainer)appCtnr, this.makeSessionComponentMonitor());
            sessCtnr.setLifecycleState((LifecycleState)sessionState);
            parentOfRequestContainer = sessCtnr;
        }
        Storing reqStoring = new Storing();
        DefaultPicoContainer reqCtnr = new DefaultPicoContainer(new Guarding().wrap((ComponentFactory)this.addRequestBehaviors((BehaviorFactory)reqStoring)), this.makeLifecycleStrategy(), (PicoContainer)parentOfRequestContainer, this.makeRequestComponentMonitor());
        ThreadLocalLifecycleState requestState = new ThreadLocalLifecycleState();
        reqCtnr.setLifecycleState((LifecycleState)requestState);
        return new ScopedContainers((MutablePicoContainer)appCtnr, (MutablePicoContainer)sessCtnr, (MutablePicoContainer)reqCtnr, sessStoring, reqStoring, sessionState, requestState);
    }

    protected PicoContainer makeParentContainer() {
        return new EmptyPicoContainer();
    }

    protected LifecycleStrategy makeLifecycleStrategy() {
        return new StartableLifecycleStrategy(this.makeRequestComponentMonitor());
    }

    protected ComponentMonitor makeAppComponentMonitor() {
        return new NullComponentMonitor();
    }

    protected ComponentMonitor makeSessionComponentMonitor() {
        return new NullComponentMonitor();
    }

    protected ComponentMonitor makeRequestComponentMonitor() {
        return new NullComponentMonitor();
    }

    protected BehaviorFactory addRequestBehaviors(BehaviorFactory beforeThisBehaviorFactory) {
        return beforeThisBehaviorFactory;
    }

    protected WebappComposer loadComposer(ServletContext context) {
        String composerClassName = context.getInitParameter(WEBAPP_COMPOSER_CLASS);
        try {
            return (WebappComposer)Thread.currentThread().getContextClassLoader().loadClass(composerClassName).newInstance();
        }
        catch (Exception e) {
            throw new PicoCompositionException("Failed to load webapp composer class " + composerClassName + ": ensure the context-param '" + WEBAPP_COMPOSER_CLASS + "' is configured in the web.xml.", (Throwable)e);
        }
    }

    protected void compose(WebappComposer composer, ServletContext context, ScopedContainers scopedContainers) {
        composer.composeApplication(scopedContainers.getApplicationContainer(), context);
        if (!this.isStateless) {
            composer.composeSession(scopedContainers.getSessionContainer());
        }
        composer.composeRequest(scopedContainers.getRequestContainer());
    }

    public void contextDestroyed(ServletContextEvent event) {
        ScopedContainers scopedContainers = this.getScopedContainers(event.getServletContext());
        this.stop(scopedContainers.getApplicationContainer());
        this.dispose(scopedContainers.getApplicationContainer());
    }

    private void start(MutablePicoContainer container) {
        container.start();
    }

    private void dispose(MutablePicoContainer container) {
        container.dispose();
    }

    private void stop(MutablePicoContainer container) {
        container.stop();
    }

    private ScopedContainers getScopedContainers(ServletContext context) {
        return (ScopedContainers)context.getAttribute(ScopedContainers.class.getName());
    }

    public void sessionCreated(HttpSessionEvent event) {
        if (!this.isStateless) {
            HttpSession session = event.getSession();
            ScopedContainers scopedContainers = this.getScopedContainers(session.getServletContext());
            SessionStoreHolder ssh = new SessionStoreHolder(scopedContainers.getSessionStoring().resetCacheForThread(), scopedContainers.getSessionState().resetStateModelForThread());
            this.start(scopedContainers.getSessionContainer());
            session.setAttribute(SessionStoreHolder.class.getName(), (Object)ssh);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (!this.isStateless) {
            HttpSession session = event.getSession();
            ScopedContainers scopedContainers = this.getScopedContainers(session.getServletContext());
            MutablePicoContainer sessionCtr = scopedContainers.getSessionContainer();
            SessionStoreHolder ssh = (SessionStoreHolder)session.getAttribute(SessionStoreHolder.class.getName());
            scopedContainers.getSessionStoring().putCacheForThread(ssh.getStoreWrapper());
            scopedContainers.getSessionState().putLifecycleStateModelForThread(ssh.getLifecycleState());
            this.stop(sessionCtr);
            this.dispose(sessionCtr);
            scopedContainers.getSessionStoring().invalidateCacheForThread();
            scopedContainers.getSessionState().invalidateStateModelForThread();
            session.setAttribute(SessionStoreHolder.class.getName(), null);
        }
    }
}

