/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.web;

import java.io.Serializable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.picocontainer.injectors.ProviderAdapter;
import org.picocontainer.web.PicoContainerWebException;

public class StringFromCookie
extends ProviderAdapter
implements Serializable {
    private final String name;

    public StringFromCookie(String name) {
        this.name = name;
    }

    public Class getComponentImplementation() {
        return String.class;
    }

    public Object getComponentKey() {
        return this.name;
    }

    public String provide(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(this.name)) continue;
                return cookie.getValue();
            }
        }
        throw new CookieNotFound(this.name);
    }

    public static class CookieNotFound
    extends PicoContainerWebException {
        private CookieNotFound(String name) {
            super("'" + name + "' not found in cookies");
        }
    }
}

