/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.web;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.picocontainer.injectors.ProviderAdapter;
import org.picocontainer.web.PicoContainerWebException;

public class StringFromHeader
extends ProviderAdapter
implements Serializable {
    private final String headerKey;
    private final String headerName;

    public StringFromHeader(String headername) {
        this.headerName = headername;
        if (headername == null) {
            throw new NullPointerException("headername");
        }
        this.headerKey = headername.replaceAll("\\-", "_");
    }

    public Class getComponentImplementation() {
        return String.class;
    }

    public Object getComponentKey() {
        return this.headerKey;
    }

    public String provide(HttpServletRequest request) {
        String result = request.getHeader(this.headerName);
        if (result == null) {
            throw new HeaderNotFound(this.headerName);
        }
        return result;
    }

    public String toString() {
        return "String from header.  Component Key " + this.headerKey + " Servlet Request Header Name: " + this.headerName;
    }

    public static class HeaderNotFound
    extends PicoContainerWebException {
        private HeaderNotFound(String name) {
            super("'" + name + "' not found in header");
        }
    }
}

