/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.web.chain;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.ServletContext;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.classname.ClassName;
import org.picocontainer.classname.DefaultClassLoadingPicoContainer;
import org.picocontainer.parameters.ConstantParameter;
import org.picocontainer.script.ContainerBuilder;

public final class ServletChainBuilder {
    private final ServletContext context;
    private final String containerBuilderClassName;
    private final String containerScriptName;
    private final String emptyContainerScript;

    public ServletChainBuilder(ServletContext context, String containerBuilderClassName, String containerScriptName, String emptyContainerScript) {
        this.context = context;
        this.containerBuilderClassName = containerBuilderClassName;
        this.containerScriptName = containerScriptName;
        this.emptyContainerScript = emptyContainerScript;
    }

    private void populateContainer(String resourcePath, MutablePicoContainer container) {
        PicoContainer buildContainer = this.buildContainer(resourcePath, container.getParent());
        for (ComponentAdapter adapter : buildContainer.getComponentAdapters()) {
            container.addAdapter(adapter);
        }
    }

    private PicoContainer buildContainer(String resourcePath, PicoContainer parent) {
        ContainerBuilder builder = this.createContainerBuilder(this.obtainReader(resourcePath));
        return builder.buildContainer(parent, null, false);
    }

    private ContainerBuilder createContainerBuilder(Reader reader) {
        DefaultClassLoadingPicoContainer scripted = new DefaultClassLoadingPicoContainer(this.getClassLoader());
        Parameter[] parameters = new Parameter[]{new ConstantParameter((Object)reader), new ConstantParameter((Object)this.getClassLoader())};
        scripted.addComponent((Object)this.containerBuilderClassName, (Object)new ClassName(this.containerBuilderClassName), parameters);
        return (ContainerBuilder)scripted.getComponent(ContainerBuilder.class);
    }

    private Reader obtainReader(String path) {
        InputStream is = this.context.getResourceAsStream(path + this.containerScriptName);
        if (is != null) {
            return new InputStreamReader(is);
        }
        return new StringReader(this.emptyContainerScript);
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

