/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.web.script;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.servlet.ServletContext;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.classname.ClassName;
import org.picocontainer.classname.DefaultClassLoadingPicoContainer;
import org.picocontainer.parameters.ConstantParameter;
import org.picocontainer.script.ContainerBuilder;
import org.picocontainer.web.WebappComposer;

public class ScriptedWebappComposer
implements WebappComposer {
    public static final String DEFAULT_CONTAINER_BUILDER = "org.picocontainer.script.xml.XMLContainerBuilder";
    public static final String DEFAULT_APPLICATION_SCRIPT = "pico-application.xml";
    public static final String DEFAULT_SESSION_SCRIPT = "pico-session.xml";
    public static final String DEFAULT_REQUEST_SCRIPT = "pico-request.xml";
    private String containerBuilderClassName;
    private String applicationScript;
    private String sessionScript;
    private String requestScript;

    public ScriptedWebappComposer() {
        this(DEFAULT_CONTAINER_BUILDER, DEFAULT_APPLICATION_SCRIPT, DEFAULT_SESSION_SCRIPT, DEFAULT_REQUEST_SCRIPT);
    }

    public ScriptedWebappComposer(String containerBuilderClassName, String applicationScript, String sessionScript, String requestScript) {
        this.containerBuilderClassName = containerBuilderClassName;
        this.applicationScript = applicationScript;
        this.sessionScript = sessionScript;
        this.requestScript = requestScript;
    }

    public void composeApplication(MutablePicoContainer container, ServletContext context) {
        this.populateContainer(this.applicationScript, container);
    }

    public void composeSession(MutablePicoContainer container) {
        this.populateContainer(this.sessionScript, container);
    }

    public void composeRequest(MutablePicoContainer container) {
        this.populateContainer(this.requestScript, container);
    }

    private void populateContainer(String resourcePath, MutablePicoContainer container) {
        PicoContainer buildContainer = this.buildContainer(resourcePath, container.getParent());
        for (ComponentAdapter adapter : buildContainer.getComponentAdapters()) {
            container.addAdapter(adapter);
        }
    }

    private PicoContainer buildContainer(String resourcePath, PicoContainer parent) {
        ContainerBuilder builder = this.createContainerBuilder(this.getResource(resourcePath));
        return builder.buildContainer(parent, null, false);
    }

    private ContainerBuilder createContainerBuilder(Reader reader) {
        DefaultClassLoadingPicoContainer scripted = new DefaultClassLoadingPicoContainer(this.getClassLoader());
        Parameter[] parameters = new Parameter[]{new ConstantParameter((Object)reader), new ConstantParameter((Object)this.getClassLoader())};
        scripted.addComponent((Object)this.containerBuilderClassName, (Object)new ClassName(this.containerBuilderClassName), parameters);
        return (ContainerBuilder)scripted.getComponent(ContainerBuilder.class);
    }

    private Reader getResource(String resource) {
        ClassLoader classLoader = this.getClassLoader();
        InputStream stream = classLoader.getResourceAsStream(resource);
        if (stream == null) {
            throw new PicoCompositionException("Resource " + resource + " not found in classloader " + classLoader);
        }
        return new InputStreamReader(stream);
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

