/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.equivalent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.bytecode.analysis.OpcodeMatchers;
import org.pitest.mutationtest.build.intercept.Region;
import org.pitest.mutationtest.build.intercept.RegionInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.Result;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.SequenceQuery;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotWrite;

class EmptyReturnsFilter
extends RegionInterceptor {
    private static final Slot<AbstractInsnNode> AVOID = Slot.create(AbstractInsnNode.class);
    private static final Slot<Integer> LOCAL_VAR = Slot.create(Integer.class);
    private final SequenceQuery<AbstractInsnNode> matches;
    private final Set<String> mutatorIds;
    private final SequenceMatcher<AbstractInsnNode> zeroValues;
    private final Match<AbstractInsnNode> returnMatch;

    EmptyReturnsFilter(SequenceQuery<AbstractInsnNode> matches, Match<AbstractInsnNode> returnMatch, MethodMutatorFactory ... mutators) {
        this.matches = matches;
        this.returnMatch = returnMatch;
        this.mutatorIds = Arrays.stream(mutators).map(m -> m.getGloballyUniqueId()).collect(Collectors.toSet());
        this.zeroValues = this.directValues().or(this.inDirectValues()).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction().or(InstructionMatchers.isA(LabelNode.class))));
    }

    private SequenceQuery<AbstractInsnNode> directValues() {
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(this.matches).then(this.returnMatch.and(EmptyReturnsFilter.store(AVOID.write()))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private SequenceQuery<AbstractInsnNode> inDirectValues() {
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(this.matches).then(EmptyReturnsFilter.aStoreTo(LOCAL_VAR)).zeroOrMore(QueryStart.match(OpcodeMatchers.ASTORE.and(InstructionMatchers.variableMatches(LOCAL_VAR.read())).negate())).then(OpcodeMatchers.ALOAD.and(InstructionMatchers.variableMatches(LOCAL_VAR.read()))).then(this.returnMatch.and(EmptyReturnsFilter.store(AVOID.write()))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static Match<AbstractInsnNode> store(SlotWrite<AbstractInsnNode> slot) {
        return (c, n) -> Result.result(true, c.store(slot, n));
    }

    @Override
    protected List<Region> computeRegions(MethodTree method) {
        Context context = Context.start();
        return this.zeroValues.contextMatches(method.instructions(), context).stream().map(c -> new Region(c.retrieve(AVOID.read()).get(), c.retrieve(AVOID.read()).get())).collect(Collectors.toList());
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater unused) {
        List<MutationDetails> targets = mutations.stream().filter(m -> this.mutatorIds.contains(m.getMutator())).collect(Collectors.toList());
        if (targets.isEmpty()) {
            return mutations;
        }
        ArrayList<MutationDetails> toReturn = new ArrayList<MutationDetails>(mutations);
        toReturn.removeAll(targets);
        toReturn.addAll(super.intercept(targets, unused));
        return toReturn;
    }

    private static Match<AbstractInsnNode> aStoreTo(Slot<Integer> variable) {
        return OpcodeMatchers.ASTORE.and(InstructionMatchers.aVariableAccess(variable.write()));
    }
}

