/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.execute;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.pitest.mutationtest.MutationStatusMap;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.execute.MinionArguments;
import org.pitest.mutationtest.execute.MutationTestMinion;
import org.pitest.mutationtest.execute.Receive;
import org.pitest.mutationtest.execute.SendData;
import org.pitest.process.ProcessArgs;
import org.pitest.process.WrappingProcess;
import org.pitest.util.CommunicationThread;
import org.pitest.util.ExitCode;

public class MutationTestProcess {
    private final WrappingProcess process;
    private final CommunicationThread thread;
    private final Map<MutationIdentifier, MutationStatusTestPair> idMap;

    public MutationTestProcess(ServerSocket socket, ProcessArgs processArgs, MinionArguments arguments) {
        this.process = WrappingProcess.create(socket.getLocalPort(), processArgs, MutationTestMinion.class);
        this.idMap = new ConcurrentHashMap<MutationIdentifier, MutationStatusTestPair>();
        this.thread = new CommunicationThread(socket, new SendData(arguments), new Receive(this.idMap));
    }

    public void start() throws IOException, InterruptedException {
        this.thread.start();
        this.process.start();
    }

    public void results(MutationStatusMap allmutations) throws IOException {
        for (MutationDetails each : allmutations.allMutations()) {
            MutationStatusTestPair status = this.idMap.get(each.getId());
            if (status == null) continue;
            allmutations.setStatusForMutation(each, status);
        }
    }

    public ExitCode waitToDie() {
        try {
            Optional<ExitCode> maybeExit = this.thread.waitToFinish(5);
            while (maybeExit.isEmpty() && this.process.isAlive()) {
                maybeExit = this.thread.waitToFinish(10);
            }
            maybeExit = this.thread.waitToFinish(10);
            ExitCode exitCode = maybeExit.orElse(ExitCode.MINION_DIED);
            return exitCode;
        }
        finally {
            this.process.destroy();
        }
    }
}

