/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.process;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.process.JavaAgent;
import org.pitest.process.JavaProcess;
import org.pitest.process.ProcessArgs;
import org.pitest.process.WrappingProcess;

public class Java9Process
implements WrappingProcess {
    private static final Map<Optional<String>, Path> CACHE = new ConcurrentHashMap<Optional<String>, Path>();
    private final int port;
    private final ProcessArgs processArgs;
    private final Class<?> minionClass;
    private JavaProcess process;

    public Java9Process(int port, ProcessArgs args, Class<?> minionClass) {
        this.port = port;
        this.processArgs = args;
        this.minionClass = minionClass;
    }

    @Override
    public void start() throws IOException {
        String args = "" + this.port;
        ProcessBuilder processBuilder = this.createProcessBuilder(this.processArgs.getJavaExecutable(), this.processArgs.getJvmArgs(), this.minionClass, args, this.processArgs.getJavaAgentFinder(), this.processArgs.getLaunchClassPath());
        this.configureProcessBuilder(processBuilder, this.processArgs.getWorkingDir(), this.processArgs.getEnvironmentVariables());
        Process process = processBuilder.start();
        this.process = new JavaProcess(process, this.processArgs.getStdout(), this.processArgs.getStdErr());
    }

    @Override
    public boolean isAlive() {
        return this.process.isAlive();
    }

    private void configureProcessBuilder(ProcessBuilder processBuilder, File workingDirectory, Map<String, String> environmentVariables) {
        processBuilder.directory(workingDirectory);
        Map<String, String> environment = processBuilder.environment();
        environment.putAll(environmentVariables);
    }

    @Override
    public void destroy() {
        this.process.destroy();
    }

    @Override
    public JavaProcess getProcess() {
        return this.process;
    }

    private ProcessBuilder createProcessBuilder(String javaProc, List<String> unsanitisedArgs, Class<?> mainClass, String programArgs, JavaAgent javaAgent, String classPath) {
        List<String> fileArgs = this.createLaunchArgs(javaAgent, unsanitisedArgs, classPath);
        this.removeJacocoAgent(fileArgs);
        Path argsFile = CACHE.computeIfAbsent(javaAgent.getJarLocation(), j -> this.createArgsFile(fileArgs));
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(javaProc);
        Java9Process.addLaunchJavaAgentsAndEnvironmentVariables(cmd);
        cmd.add("@" + argsFile.toFile().getAbsolutePath());
        cmd.add(mainClass.getName());
        cmd.add(programArgs);
        return new ProcessBuilder(cmd);
    }

    private List<String> removeArgFiles(List<String> args) {
        return args.stream().map(String::trim).filter(a -> !a.startsWith("@")).collect(Collectors.toList());
    }

    private void removeJacocoAgent(List<String> cmd) {
        Java9Process.removeFromClassPath(cmd, line -> line.startsWith("-javaagent") && line.contains("jacoco"));
    }

    private static void removeFromClassPath(List<String> cmd, Predicate<String> match) {
        for (int i = cmd.size() - 1; i >= 0; --i) {
            if (!match.test(cmd.get(i))) continue;
            cmd.remove(i);
        }
    }

    private List<String> createLaunchArgs(JavaAgent agentJarLocator, List<String> args, String classPath) {
        List<String> argsWithoutArgFiles = this.removeArgFiles(args);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("-classpath");
        cmd.add(classPath.replace(" ", "\" \""));
        Java9Process.addPITJavaAgent(agentJarLocator, cmd);
        cmd.addAll(argsWithoutArgFiles);
        List existing = this.findArgsFiles(args).stream().flatMap(f -> Java9Process.readFile(f).stream()).filter(l -> !l.trim().startsWith("--add-modules")).collect(Collectors.toList());
        cmd.addAll(existing);
        return cmd;
    }

    private static List<String> readFile(String f) {
        try {
            return Files.readAllLines(Path.of(f, new String[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path createArgsFile(List<String> cmd) {
        try {
            String name = "pitest-args-";
            Path args = Files.createTempFile(name, ".args", new FileAttribute[0]);
            args.toFile().deleteOnExit();
            Files.write(args, cmd, new OpenOption[0]);
            return args;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addPITJavaAgent(JavaAgent agentJarLocator, List<String> cmd) {
        Optional<String> jarLocation = agentJarLocator.getJarLocation();
        jarLocation.ifPresent(l -> cmd.add("-javaagent:" + l));
    }

    private static void addLaunchJavaAgentsAndEnvironmentVariables(List<String> cmd) {
        RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
        List agents = rt.getInputArguments().stream().filter(Java9Process.isJavaAgentParam().or(Java9Process.isEnvironmentSetting())).collect(Collectors.toList());
        cmd.addAll(agents);
    }

    private static Predicate<String> isEnvironmentSetting() {
        return a -> a.startsWith("-D");
    }

    private static Predicate<String> isJavaAgentParam() {
        return a -> a.toLowerCase().startsWith("-javaagent");
    }

    private List<String> findArgsFiles(List<String> args) {
        return args.stream().map(String::trim).filter(a -> a.startsWith("@")).map(a -> a.substring(1)).collect(Collectors.toList());
    }
}

