/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.report.html;

import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.report.html.ConfidenceMap;
import org.pitest.mutationtest.report.html.Line;

public class LineStyle {
    private final Line line;

    public LineStyle(Line line) {
        this.line = line;
    }

    public String getLineCoverage() {
        switch (this.line.getLineCovered()) {
            case Covered: {
                return "covered";
            }
            case NotCovered: {
                return "uncovered";
            }
        }
        return "na";
    }

    public String getCode() {
        switch (this.line.getLineCovered()) {
            case Covered: {
                return "covered";
            }
            case NotCovered: {
                return "uncovered";
            }
        }
        return "";
    }

    public String getMutation() {
        if (!this.line.detectionStatus().isPresent()) {
            return "";
        }
        DetectionStatus status = this.line.detectionStatus().get();
        if (!status.isDetected()) {
            return "survived";
        }
        if (ConfidenceMap.hasHighConfidence(status)) {
            return "killed";
        }
        return "uncertain";
    }

    public String getText() {
        return this.getLineCoverage();
    }
}

