/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven;

import java.io.File;
import java.util.function.Function;
import java.util.stream.Stream;

class PathToJavaClassConverter
implements Function<String, Stream<String>> {
    private final String sourceRoot;

    PathToJavaClassConverter(String sourceRoot) {
        this.sourceRoot = sourceRoot;
    }

    @Override
    public Stream<String> apply(String a) {
        File f = new File(a);
        String modifiedFilePath = f.getAbsolutePath();
        String fileName = f.getName();
        if (modifiedFilePath.startsWith(this.sourceRoot) && fileName.indexOf(46) != -1) {
            return this.createClassGlobFromFilePath(this.sourceRoot, modifiedFilePath);
        }
        return Stream.empty();
    }

    private Stream<String> createClassGlobFromFilePath(String sourceRoot, String modifiedFilePath) {
        String rootedPath = modifiedFilePath.substring(sourceRoot.length() + 1);
        return Stream.of(this.stripFileExtension(rootedPath).replace('/', '.').replace('\\', '.') + "*");
    }

    private String stripFileExtension(String rootedPath) {
        return rootedPath.substring(0, rootedPath.lastIndexOf("."));
    }
}

