/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.r2dbc.postgresql.client.AbstractPostgresSSLHandlerAdapter;
import io.r2dbc.postgresql.client.SSLConfig;
import io.r2dbc.postgresql.client.SSLMode;

final class SSLTunnelHandlerAdapter
extends AbstractPostgresSSLHandlerAdapter {
    private final SSLConfig sslConfig;

    SSLTunnelHandlerAdapter(ByteBufAllocator alloc, SSLConfig sslConfig) {
        super(alloc, sslConfig);
        this.sslConfig = sslConfig;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (this.sslConfig.getSslMode() == SSLMode.DISABLE) {
            AbstractPostgresSSLHandlerAdapter.PostgresqlSslException e = new AbstractPostgresSSLHandlerAdapter.PostgresqlSslException("Server requires SSL handshake, but client was configured with SSL mode DISABLE");
            this.completeHandshakeExceptionally((Throwable)((Object)e));
            return;
        }
        ctx.channel().pipeline().addFirst(new ChannelHandler[]{this.getSslHandler()});
    }
}

