/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import io.r2dbc.postgresql.client.ConnectionSettings;
import io.r2dbc.postgresql.client.TimeZoneUtils;
import io.r2dbc.postgresql.message.frontend.StartupMessage;
import io.r2dbc.postgresql.util.Assert;
import java.util.Map;
import java.util.TimeZone;
import org.jspecify.annotations.Nullable;

public final class PostgresStartupParameterProvider
implements StartupMessage.StartupParameterProvider {
    private final String applicationName;
    private final TimeZone timeZone;
    private final @Nullable Map<String, String> options;

    public PostgresStartupParameterProvider(String applicationName, TimeZone timeZone, @Nullable Map<String, String> options) {
        this.applicationName = Assert.requireNonNull(applicationName, "applicationName must not be null");
        this.timeZone = Assert.requireNonNull(timeZone, "timeZone must not be null");
        this.options = options;
    }

    public PostgresStartupParameterProvider(String applicationName, TimeZone timeZone, ConnectionSettings settings) {
        this.applicationName = Assert.requireNonNull(applicationName, "applicationName must not be null");
        this.timeZone = Assert.requireNonNull(timeZone, "timeZone must not be null");
        this.options = settings.getStartupOptions();
    }

    @Override
    public void accept(StartupMessage.ParameterWriter writer) {
        writer.write("application_name", this.applicationName);
        writer.write("client_encoding", "utf8");
        writer.write("DateStyle", "ISO");
        writer.write("extra_float_digits", "2");
        writer.write("TimeZone", TimeZoneUtils.createPostgresTimeZone(this.timeZone));
        if (this.options != null) {
            for (Map.Entry<String, String> option : this.options.entrySet()) {
                writer.write(option.getKey(), option.getValue());
            }
        }
    }
}

