/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractNumericCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.codec.PrimitiveCodec;
import io.r2dbc.postgresql.codec.PrimitiveWrapperCodecProvider;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import org.jspecify.annotations.Nullable;

final class LongCodec
extends AbstractNumericCodec<Long>
implements PrimitiveWrapperCodecProvider<Long> {
    LongCodec(ByteBufAllocator byteBufAllocator) {
        super(Long.class, byteBufAllocator);
    }

    @Override
    public PrimitiveCodec<Long> getPrimitiveCodec() {
        return new PrimitiveCodec<Long>(Long.TYPE, Long.class, this);
    }

    @Override
    Long doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, Format format, @Nullable Class<? extends Long> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        Assert.requireNonNull(format, "format must not be null");
        return this.decodeNumber(buffer, dataType, format, Long.class, Number::longValue);
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return PostgresqlObjectId.INT8;
    }

    @Override
    public PostgresTypeIdentifier getArrayDataType() {
        return PostgresqlObjectId.INT8_ARRAY;
    }
}

